/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.ai.embedding.EmbeddingOptions;

public class AzureOpenAiEmbeddingOptions
implements EmbeddingOptions {
    @JsonProperty(value="user")
    private String user;
    @JsonProperty(value="model")
    private String deploymentName;

    public static Builder builder() {
        return new Builder();
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public static class Builder {
        private final AzureOpenAiEmbeddingOptions options = new AzureOpenAiEmbeddingOptions();

        public Builder withUser(String user) {
            this.options.setUser(user);
            return this;
        }

        public Builder withDeploymentName(String model) {
            this.options.setDeploymentName(model);
            return this;
        }

        public AzureOpenAiEmbeddingOptions build() {
            return this.options;
        }
    }
}

