/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.plugin.release;

import io.spring.gradle.plugin.core.ProjectUtils;
import io.spring.gradle.plugin.core.RegularFileUtils;
import io.spring.gradle.plugin.release.SpringReleasePluginExtension;
import io.spring.release.SpringReleases;
import java.util.Objects;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class GetPreviousReleaseMilestoneTask
extends DefaultTask {
    public static final String TASK_NAME = "getPreviousReleaseMilestone";
    public static final String OUTPUT_VERSION_PATH = "previous-release-milestone-version.txt";

    @Input
    public abstract Property<String> getGitHubAccessToken();

    @Input
    public abstract Property<String> getProjectName();

    @Input
    public abstract Property<String> getVersion();

    @OutputFile
    public abstract RegularFileProperty getPreviousReleaseMilestoneFile();

    @TaskAction
    public void getPreviousReleaseMilestone() {
        String gitHubAccessToken = (String)this.getGitHubAccessToken().get();
        String projectName = (String)this.getProjectName().get();
        String version = (String)this.getVersion().get();
        RegularFile outputFile = (RegularFile)this.getPreviousReleaseMilestoneFile().get();
        SpringReleases springReleases = new SpringReleases(gitHubAccessToken);
        String previousReleaseMilestone = springReleases.getPreviousReleaseMilestone(projectName, version);
        if (previousReleaseMilestone != null) {
            RegularFileUtils.writeString(outputFile, previousReleaseMilestone);
            System.out.println(previousReleaseMilestone);
        } else {
            RegularFileUtils.writeString(outputFile, "");
            System.out.println();
            this.getLogger().warn("Unable to determine previous release milestone, either because multiple matches were found or none exists");
        }
    }

    public static void register(Project project) {
        SpringReleasePluginExtension springRelease = (SpringReleasePluginExtension)project.getExtensions().findByType(SpringReleasePluginExtension.class);
        Objects.requireNonNull(springRelease, "Cannot find " + SpringReleasePluginExtension.class);
        project.getTasks().register(TASK_NAME, GetPreviousReleaseMilestoneTask.class, task -> {
            task.setGroup("Release");
            task.setDescription("Finds the previous release version based on the current version.");
            task.doNotTrackState("API call to api.spring.io needs to check for releases every time");
            Provider versionProvider = ProjectUtils.getProperty(project, "currentVersion").orElse((Object)project.getRootProject().getVersion().toString());
            String name = (String)springRelease.getRepositoryName().get();
            task.getGitHubAccessToken().set(ProjectUtils.getProperty(project, "gitHubAccessToken"));
            task.getProjectName().set((Object)name);
            task.getVersion().set(versionProvider);
            task.getPreviousReleaseMilestoneFile().set(project.getLayout().getBuildDirectory().file(OUTPUT_VERSION_PATH));
        });
    }
}

