/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.plugin.release;

import com.github.api.Repository;
import io.spring.gradle.plugin.core.ProjectUtils;
import io.spring.gradle.plugin.release.SpringReleasePluginExtension;
import io.spring.release.SpringReleases;
import java.util.Objects;
import java.util.regex.Matcher;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class CreateSaganReleaseTask
extends DefaultTask {
    public static final String TASK_NAME = "createSaganRelease";

    @Input
    public abstract Property<String> getGitHubAccessToken();

    @Input
    public abstract Property<Repository> getRepository();

    @Input
    public abstract Property<String> getVersion();

    @Input
    public abstract Property<String> getReferenceDocUrl();

    @Input
    public abstract Property<String> getApiDocUrl();

    @Input
    @Optional
    @Deprecated
    public abstract Property<Boolean> getReplaceSnapshotVersionInReferenceDocUrl();

    @Input
    public abstract Property<Boolean> getReplaceVersionInReferenceDocUrl();

    @TaskAction
    public void createSaganRelease() {
        String gitHubAccessToken = (String)this.getGitHubAccessToken().get();
        Repository repository = (Repository)this.getRepository().get();
        String version = (String)this.getVersion().get();
        String referenceDocUrl = (String)this.getReferenceDocUrl().get();
        String apiDocUrl = (String)this.getApiDocUrl().get();
        Boolean replaceVersion = (Boolean)this.getReplaceVersionInReferenceDocUrl().get();
        Boolean replaceSnapshotVersion = (Boolean)this.getReplaceSnapshotVersionInReferenceDocUrl().getOrNull();
        if (replaceSnapshotVersion != null) {
            replaceVersion = replaceSnapshotVersion;
        }
        if (replaceVersion.booleanValue()) {
            Matcher versionMatcher = SpringReleases.versionMatcher(version);
            String majorVersion = versionMatcher.group(1);
            String minorVersion = versionMatcher.group(2);
            String majorMinorVersion = version.endsWith("-SNAPSHOT") ? "%s.%s-SNAPSHOT".formatted(majorVersion, minorVersion) : "%s.%s".formatted(majorVersion, minorVersion);
            referenceDocUrl = referenceDocUrl.replace("{version}", majorMinorVersion);
        }
        SpringReleases springReleases = new SpringReleases(gitHubAccessToken);
        springReleases.createSaganRelease(repository.name(), version, referenceDocUrl, apiDocUrl);
    }

    public static void register(Project project) {
        SpringReleasePluginExtension springRelease = (SpringReleasePluginExtension)project.getExtensions().findByType(SpringReleasePluginExtension.class);
        Objects.requireNonNull(springRelease, "Cannot find " + SpringReleasePluginExtension.class);
        project.getTasks().register(TASK_NAME, CreateSaganReleaseTask.class, task -> {
            task.setGroup("Release");
            task.setDescription("Create a version for the specified project on spring.io.");
            task.doNotTrackState("API call to api.spring.io needs to check for releases every time");
            Provider versionProvider = ProjectUtils.getProperty(project, "nextVersion").orElse((Object)project.getRootProject().getVersion().toString());
            String owner = (String)springRelease.getRepositoryOwner().get();
            String name = (String)springRelease.getRepositoryName().get();
            task.getGitHubAccessToken().set(ProjectUtils.getProperty(project, "gitHubAccessToken"));
            task.getRepository().set((Object)new Repository(owner, name));
            task.getVersion().set(versionProvider);
            task.getReferenceDocUrl().set(springRelease.getReferenceDocUrl());
            task.getApiDocUrl().set(springRelease.getApiDocUrl());
            task.getReplaceSnapshotVersionInReferenceDocUrl().set(springRelease.getReplaceSnapshotVersionInReferenceDocUrl());
            task.getReplaceVersionInReferenceDocUrl().set(springRelease.getReplaceVersionInReferenceDocUrl());
        });
    }
}

