/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.plugin.release;

import com.github.api.Repository;
import groovy.lang.MissingPropertyException;
import io.spring.gradle.plugin.core.ProjectUtils;
import io.spring.gradle.plugin.core.RegularFileUtils;
import io.spring.gradle.plugin.release.GenerateChangelogTask;
import io.spring.gradle.plugin.release.GetNextReleaseMilestoneTask;
import io.spring.gradle.plugin.release.SpringReleasePluginExtension;
import io.spring.release.SpringReleases;
import java.util.Objects;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class CreateGitHubReleaseTask
extends DefaultTask {
    public static final String TASK_NAME = "createGitHubRelease";

    @Input
    public abstract Property<Repository> getRepository();

    @Input
    public abstract Property<String> getVersion();

    @Input
    public abstract Property<String> getBranch();

    @Input
    public abstract Property<Boolean> getCreateRelease();

    @Input
    @Optional
    public abstract Property<String> getReleaseNotes();

    @Input
    @Optional
    public abstract Property<String> getVersionPrefix();

    @Input
    @Optional
    public abstract Property<String> getGitHubAccessToken();

    @TaskAction
    public void createGitHubRelease() {
        String gitHubAccessToken = (String)this.getGitHubAccessToken().getOrNull();
        Repository repository = (Repository)this.getRepository().get();
        String version = (String)this.getVersion().get();
        String versionPrefix = (String)this.getVersionPrefix().getOrElse((Object)"");
        String branch = (String)this.getBranch().get();
        Boolean createRelease = (Boolean)this.getCreateRelease().get();
        if (createRelease.booleanValue() && gitHubAccessToken == null) {
            throw new MissingPropertyException("Please provide an access token with -PgitHubAccessToken=...");
        }
        String body = (String)this.getReleaseNotes().getOrNull();
        if (body == null) {
            throw new MissingPropertyException("Nothing was generated by the release-notes-generator, perhaps because no issues were available in release milestone %s. Please ensure there is at least one issue in the release.".formatted(version));
        }
        System.out.printf("%sCreating GitHub release for %s/%s@%s%s%n", createRelease != false ? "" : "[DRY RUN] ", repository.owner(), repository.name(), versionPrefix, version);
        System.out.printf("%nRelease Notes:%n%n----%n%s%n----%n%n", body.trim());
        if (createRelease.booleanValue()) {
            SpringReleases springReleases = new SpringReleases(gitHubAccessToken);
            springReleases.createGitHubRelease(repository.owner(), repository.name(), versionPrefix + version, branch, body);
        }
    }

    public static void register(Project project) {
        SpringReleasePluginExtension springRelease = (SpringReleasePluginExtension)project.getExtensions().findByType(SpringReleasePluginExtension.class);
        Objects.requireNonNull(springRelease, "Cannot find " + SpringReleasePluginExtension.class);
        project.getTasks().register(TASK_NAME, CreateGitHubReleaseTask.class, task -> {
            task.setGroup("Release");
            task.setDescription("Create a GitHub release with release notes");
            task.doNotTrackState("API call to GitHub needs to check for new issues and create a release every time");
            Provider versionProvider = ProjectUtils.getProperty(project, "nextVersion").orElse(ProjectUtils.findTaskByType(project, GetNextReleaseMilestoneTask.class).getNextReleaseMilestoneFile().map(RegularFileUtils::readString));
            Provider releaseNotesProvider = ProjectUtils.findTaskByType(project, GenerateChangelogTask.class).getReleaseNotesFile().map(RegularFileUtils::readString);
            Provider createReleaseProvider = ProjectUtils.getProperty(project, "createRelease").map(Boolean::valueOf);
            String owner = (String)springRelease.getRepositoryOwner().get();
            String name = (String)springRelease.getRepositoryName().get();
            String releaseVersionPrefix = (String)springRelease.getReleaseVersionPrefix().get();
            task.getRepository().set((Object)new Repository(owner, name));
            task.getVersion().set(versionProvider);
            task.getVersionPrefix().set((Object)releaseVersionPrefix);
            task.getReleaseNotes().set(releaseNotesProvider);
            task.getBranch().set(ProjectUtils.getProperty(project, "branch").orElse((Object)"main"));
            task.getCreateRelease().set(createReleaseProvider.orElse((Object)false));
            task.getGitHubAccessToken().set(ProjectUtils.getProperty(project, "gitHubAccessToken"));
        });
    }
}

