/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.plugin.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;

public final class RegularFileUtils {
    private RegularFileUtils() {
    }

    public static String readString(RegularFile regularFile) {
        Path path = regularFile.getAsFile().toPath();
        try {
            String string = Files.readString(path);
            return string != null && !string.isEmpty() ? string : null;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Path writeString(RegularFile file, String value) {
        Path path = file.getAsFile().toPath();
        try {
            return Files.writeString(path, (CharSequence)value, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Transformer<Path, RegularFile> writeString(String value) {
        return regularFile -> RegularFileUtils.writeString(regularFile, value);
    }

    public static void mkdirs(DirectoryProperty property) {
        Directory directory = (Directory)property.get();
        if (!directory.getAsFile().mkdirs()) {
            throw new IllegalArgumentException("Unable to create directories for " + directory);
        }
    }
}

