/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.plugin.core;

import io.spring.gradle.plugin.core.RegularFileUtils;
import java.util.Objects;
import java.util.function.Function;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public final class ProjectUtils {
    private ProjectUtils() {
    }

    public static Provider<String> getProperty(Project project, String propertyName) {
        Property stringProperty = project.getObjects().property(String.class);
        if (project.hasProperty(propertyName)) {
            Object propertyValue = Objects.requireNonNull(project.property(propertyName));
            stringProperty.set((Object)propertyValue.toString());
        }
        return stringProperty;
    }

    public static <T extends Task> Provider<String> getProperty(Project project, Class<T> taskType, Function<T, RegularFileProperty> function) {
        T task = ProjectUtils.findTaskByType(project, taskType);
        return function.apply(task).map(RegularFileUtils::readString);
    }

    public static <T extends Task> T findTaskByType(Project project, Class<T> taskType) {
        return (T)project.getTasks().withType(taskType).stream().findFirst().map(taskType::cast).orElseThrow(() -> new UnknownTaskException("Unable to find task of type [%s]".formatted(taskType)));
    }
}

