/*
 * Decompiled with CFR 0.152.
 */
package io.spring.api;

import io.spring.api.Generation;
import io.spring.api.Project;
import io.spring.api.Release;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import shaded.com.fasterxml.jackson.annotation.JsonInclude;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import shaded.com.fasterxml.jackson.databind.ObjectMapper;
import shaded.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public class SaganApi {
    private final HttpClient httpClient = HttpClient.newHttpClient();
    private final ObjectMapper objectMapper = SaganApi.getObjectMapper();
    private final String baseUrl;
    private final String username;
    private final String accessToken;

    public SaganApi(String username, String accessToken) {
        this("https://api.spring.io", username, accessToken);
    }

    public SaganApi(String baseUrl, String username, String accessToken) {
        this.baseUrl = baseUrl;
        this.username = username;
        this.accessToken = accessToken;
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.registerModule(new JavaTimeModule());
        return objectMapper;
    }

    public List<Project> getProjects() {
        HttpRequest httpRequest = this.requestBuilder("/projects").GET().build();
        EmbeddedProjectsWrapper wrapper = this.performRequest(httpRequest, EmbeddedProjectsWrapper.class);
        return wrapper._embedded != null ? wrapper._embedded.projects : Collections.emptyList();
    }

    public Project getProject(String slug) {
        String uri = "/projects/%s".formatted(slug);
        HttpRequest httpRequest = this.requestBuilder(uri).GET().build();
        return this.performRequest(httpRequest, Project.class);
    }

    public List<Release> getReleases(String slug) {
        String uri = "/projects/%s/releases".formatted(slug);
        HttpRequest httpRequest = this.requestBuilder(uri).GET().build();
        EmbeddedReleasesWrapper wrapper = this.performRequest(httpRequest, EmbeddedReleasesWrapper.class);
        return wrapper._embedded != null ? wrapper._embedded.releases : Collections.emptyList();
    }

    public void createRelease(String slug, Release release) {
        String uri = "/projects/%s/releases".formatted(slug);
        HttpRequest httpRequest = this.requestBuilder(uri).header("Content-Type", "application/json").POST(this.bodyValue(release)).build();
        this.performRequest(httpRequest, Void.class);
    }

    public Release getRelease(String slug, String version) {
        String uri = "/projects/%s/releases/%s".formatted(slug, version);
        HttpRequest httpRequest = this.requestBuilder(uri).GET().build();
        return this.performRequest(httpRequest, Release.class);
    }

    public void deleteRelease(String slug, String version) {
        String uri = "/projects/%s/releases/%s".formatted(slug, version);
        HttpRequest httpRequest = this.requestBuilder(uri).DELETE().build();
        this.performRequest(httpRequest, Void.class);
    }

    public List<Generation> getGenerations(String slug) {
        String uri = "/projects/%s/generations".formatted(slug);
        HttpRequest httpRequest = this.requestBuilder(uri).GET().build();
        EmbeddedGenerationsWrapper wrapper = this.performRequest(httpRequest, EmbeddedGenerationsWrapper.class);
        return wrapper._embedded != null ? wrapper._embedded.generations : Collections.emptyList();
    }

    public Generation getGeneration(String slug, String name) {
        String uri = "/projects/%s/generations/%s".formatted(slug, name);
        HttpRequest httpRequest = this.requestBuilder(uri).GET().build();
        return this.performRequest(httpRequest, Generation.class);
    }

    private HttpRequest.Builder requestBuilder(String uri) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(this.baseUrl + uri).normalize());
        if (this.username != null && this.accessToken != null) {
            String credentials = "%s:%s".formatted(this.username, this.accessToken);
            String basicAuth = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            builder.setHeader("Authorization", "Basic %s".formatted(basicAuth));
        }
        return builder;
    }

    private <T> T performRequest(HttpRequest httpRequest, Class<T> responseType) {
        try {
            HttpResponse<String> httpResponse = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (httpResponse.statusCode() >= 300) {
                throw new HttpClientException(httpResponse.statusCode(), httpResponse.body());
            }
            String responseBody = Void.class.isAssignableFrom(responseType) ? "null" : httpResponse.body();
            return this.objectMapper.readValue(responseBody, responseType);
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException("Unable to perform request:", ex);
        }
    }

    private <T> HttpRequest.BodyPublisher bodyValue(T body) {
        try {
            return HttpRequest.BodyPublishers.ofString(this.objectMapper.writeValueAsString(body));
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Unable to serialize json:", ex);
        }
    }

    private record EmbeddedProjectsWrapper(EmbeddedProjects _embedded) {
    }

    private record EmbeddedProjects(List<Project> projects) {
    }

    private record EmbeddedReleasesWrapper(EmbeddedReleases _embedded) {
    }

    private record EmbeddedReleases(List<Release> releases) {
    }

    private record EmbeddedGenerationsWrapper(EmbeddedGenerations _embedded) {
    }

    private record EmbeddedGenerations(List<Generation> generations) {
    }

    public static class HttpClientException
    extends RuntimeException {
        private final int statusCode;
        private final String responseBody;

        private HttpClientException(int statusCode, String responseBody) {
            super(statusCode + "[" + responseBody + "]");
            this.statusCode = statusCode;
            this.responseBody = responseBody;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getResponseBody() {
            return this.responseBody;
        }

        @Override
        public String toString() {
            return this.statusCode + "[" + this.responseBody + "]";
        }
    }
}

