/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.bintray.task;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import io.spring.gradle.bintray.BintrayClient;
import io.spring.gradle.bintray.BintrayPackage;
import io.spring.gradle.bintray.task.UploadResponse;
import java.io.Closeable;
import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BI\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000eJ\b\u0010 \u001a\u00020\fH\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0018\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00190\u00198\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0012\u00a8\u0006#"}, d2={"Lio/spring/gradle/bintray/task/UploadWorker;", "Ljava/lang/Runnable;", "bintrayUser", "", "bintrayKey", "pkg", "Lio/spring/gradle/bintray/BintrayPackage;", "version", "path", "artifact", "Ljava/io/File;", "overrideOnUpload", "", "gpgPassphrase", "(Ljava/lang/String;Ljava/lang/String;Lio/spring/gradle/bintray/BintrayPackage;Ljava/lang/String;Ljava/lang/String;Ljava/io/File;ZLjava/lang/String;)V", "getArtifact", "()Ljava/io/File;", "getBintrayKey", "()Ljava/lang/String;", "getBintrayUser", "getGpgPassphrase", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getOverrideOnUpload", "()Z", "getPath", "getPkg", "()Lio/spring/gradle/bintray/BintrayPackage;", "getVersion", "artifactExists", "run", "", "spring-bintray-plugin"})
final class UploadWorker
implements Runnable {
    private final transient ObjectMapper mapper;
    private final transient Logger logger;
    @NotNull
    private final String bintrayUser;
    @NotNull
    private final String bintrayKey;
    @NotNull
    private final BintrayPackage pkg;
    @NotNull
    private final String version;
    @NotNull
    private final String path;
    @NotNull
    private final File artifact;
    private final boolean overrideOnUpload;
    @Nullable
    private final String gpgPassphrase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BintrayClient bintrayClient2 = new BintrayClient(this.bintrayUser, this.bintrayKey);
        if (this.overrideOnUpload || !this.artifactExists()) {
            this.logger.info("Uploading " + this.path);
            try {
                Closeable closeable = (Closeable)bintrayClient2.upload("content/" + this.pkg.getSubject() + '/' + this.pkg.getRepo() + '/' + this.pkg.getName() + '/' + this.version + '/' + this.path, this.artifact, this.gpgPassphrase);
                Throwable throwable = null;
                try {
                    Unit unit;
                    Response response = (Response)closeable;
                    if (!response.isSuccessful()) {
                        ResponseBody responseBody = response.body();
                        throw (Throwable)new GradleException("failed to upload " + this.path + ": HTTP " + response.code() + " / " + (responseBody != null ? responseBody.string() : null));
                    }
                    ResponseBody responseBody = response.body();
                    if (responseBody != null) {
                        ResponseBody responseBody2;
                        ResponseBody body = responseBody2 = responseBody;
                        String string = ((UploadResponse)this.mapper.readValue(body.string(), UploadResponse.class)).getWarn();
                        if (string != null) {
                            String string2;
                            String warning = string2 = string;
                            this.logger.warn("Upload response for " + this.path + " contained warning message: '{}'", (Object)warning);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable t) {
                throw (Throwable)new GradleException("failed to upload " + this.path, t);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean artifactExists() {
        boolean bl;
        Response response;
        void subject;
        BintrayPackage bintrayPackage = this.pkg;
        String string = bintrayPackage.component1();
        String repo = bintrayPackage.component2();
        Request request = new Request.Builder().head().url("https://dl.bintray.com/" + (String)subject + '/' + repo + '/' + this.path).build();
        Response response2 = response = new OkHttpClient.Builder().build().newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        if (response2.isSuccessful()) {
            this.logger.info('/' + (String)subject + '/' + repo + '/' + this.path + " already exists, skipping upload");
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String getBintrayUser() {
        return this.bintrayUser;
    }

    @NotNull
    public final String getBintrayKey() {
        return this.bintrayKey;
    }

    @NotNull
    public final BintrayPackage getPkg() {
        return this.pkg;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final File getArtifact() {
        return this.artifact;
    }

    public final boolean getOverrideOnUpload() {
        return this.overrideOnUpload;
    }

    @Nullable
    public final String getGpgPassphrase() {
        return this.gpgPassphrase;
    }

    @Inject
    public UploadWorker(@NotNull String bintrayUser, @NotNull String bintrayKey, @NotNull BintrayPackage pkg2, @NotNull String version2, @NotNull String path, @NotNull File artifact, boolean overrideOnUpload, @Nullable String gpgPassphrase) {
        Intrinsics.checkParameterIsNotNull((Object)bintrayUser, (String)"bintrayUser");
        Intrinsics.checkParameterIsNotNull((Object)bintrayKey, (String)"bintrayKey");
        Intrinsics.checkParameterIsNotNull((Object)pkg2, (String)"pkg");
        Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)artifact, (String)"artifact");
        this.bintrayUser = bintrayUser;
        this.bintrayKey = bintrayKey;
        this.pkg = pkg2;
        this.version = version2;
        this.path = path;
        this.artifact = artifact;
        this.overrideOnUpload = overrideOnUpload;
        this.gpgPassphrase = gpgPassphrase;
        this.mapper = new ObjectMapper().registerModule((Module)new KotlinModule(0, 1, null));
        this.logger = LoggerFactory.getLogger(UploadWorker.class);
    }
}

