/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.bintray.task;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.spring.gradle.bintray.task.AbstractBintrayTask;
import io.spring.gradle.bintray.task.MavenCentral;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lio/spring/gradle/bintray/task/MavenCentralSyncTask;", "Lio/spring/gradle/bintray/task/AbstractBintrayTask;", "()V", "mavenCentralSync", "", "MavenCentralSync", "spring-bintray-plugin"})
public class MavenCentralSyncTask
extends AbstractBintrayTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void mavenCentralSync() {
        String string = this.getExt().getOssrhUser();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = this.getExt().getOssrhPassword();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        MavenCentralSync sync = new MavenCentralSync(string, string2, 0, 4, null);
        String packageVersionPath = "" + this.getPkg().getSubject() + '/' + this.getPkg().getRepo() + '/' + this.getPkg().getName() + "/versions/" + this.getVersion();
        Closeable closeable = (Closeable)this.getBintrayClient().post("maven_central_sync/" + packageVersionPath, sync);
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            if (!response.isSuccessful()) {
                ResponseBody responseBody = response.body();
                throw (Throwable)new GradleException("Could not sync /" + packageVersionPath + " to Maven Central: HTTP " + response.code() + " / " + (responseBody != null ? responseBody.string() : null));
            }
            this.getLogger().info("Synced /" + packageVersionPath + " to Maven Central");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public MavenCentralSyncTask() {
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                return this.getBintrayClient().headIsSuccessful(this.getVersionPath());
            }
        });
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                boolean bl;
                Publication publication2 = this.getPublication();
                if (publication2 instanceof MavenPublication) {
                    Publication publication3 = this.getPublication();
                    if (publication3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.publish.maven.MavenPublication");
                    }
                    bl = !MavenCentral.INSTANCE.exists((MavenPublication)publication3);
                } else {
                    Logger logger = this.getLogger();
                    StringBuilder stringBuilder = new StringBuilder().append("Not attempting to sync ");
                    Project project = this.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                    logger.warn(stringBuilder.append(project.getName()).append(" to Maven Central, because no maven publication could be found on this project").toString());
                    bl = false;
                }
                return bl;
            }
        });
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                boolean bl;
                if (this.getExt().getOssrhUser() == null || this.getExt().getOssrhPassword() == null) {
                    Project project = this.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                    project.getLogger().warn("bintray.[ossrhUser, ossrhPassword] are required to sync to Maven Central");
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        });
    }

    @JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0083\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lio/spring/gradle/bintray/task/MavenCentralSyncTask$MavenCentralSync;", "", "username", "", "password", "close", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "getClose", "()I", "getPassword", "()Ljava/lang/String;", "getUsername", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "spring-bintray-plugin"})
    private static final class MavenCentralSync {
        @NotNull
        private final String username;
        @NotNull
        private final String password;
        private final int close;

        @NotNull
        public final String getUsername() {
            return this.username;
        }

        @NotNull
        public final String getPassword() {
            return this.password;
        }

        public final int getClose() {
            return this.close;
        }

        public MavenCentralSync(@NotNull String username, @NotNull String password, int close) {
            Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            this.username = username;
            this.password = password;
            this.close = close;
        }

        public /* synthetic */ MavenCentralSync(String string, String string2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = 1;
            }
            this(string, string2, n);
        }

        @NotNull
        public final String component1() {
            return this.username;
        }

        @NotNull
        public final String component2() {
            return this.password;
        }

        public final int component3() {
            return this.close;
        }

        @NotNull
        public final MavenCentralSync copy(@NotNull String username, @NotNull String password, int close) {
            Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            return new MavenCentralSync(username, password, close);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ MavenCentralSync copy$default(MavenCentralSync mavenCentralSync, String string, String string2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = mavenCentralSync.username;
            }
            if ((n2 & 2) != 0) {
                string2 = mavenCentralSync.password;
            }
            if ((n2 & 4) != 0) {
                n = mavenCentralSync.close;
            }
            return mavenCentralSync.copy(string, string2, n);
        }

        public String toString() {
            return "MavenCentralSync(username=" + this.username + ", password=" + this.password + ", close=" + this.close + ")";
        }

        public int hashCode() {
            String string = this.username;
            String string2 = this.password;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + this.close;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MavenCentralSync)) break block3;
                    MavenCentralSync mavenCentralSync = (MavenCentralSync)object;
                    if (!Intrinsics.areEqual((Object)this.username, (Object)mavenCentralSync.username) || !Intrinsics.areEqual((Object)this.password, (Object)mavenCentralSync.password) || !(this.close == mavenCentralSync.close)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

