/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.bintray;

import io.spring.gradle.bintray.SpringBintrayExtension;
import io.spring.gradle.bintray.SpringBintrayPlugin;
import io.spring.gradle.bintray.task.AbstractBintrayTask;
import io.spring.gradle.bintray.task.CreatePackageTask;
import io.spring.gradle.bintray.task.CreateVersionTask;
import io.spring.gradle.bintray.task.MavenCentralSyncTask;
import io.spring.gradle.bintray.task.PublishTask;
import io.spring.gradle.bintray.task.SignTask;
import io.spring.gradle.bintray.task.UploadTask;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenArtifactSet;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/spring/gradle/bintray/SpringBintrayPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "ext", "Lio/spring/gradle/bintray/SpringBintrayExtension;", "getExt", "()Lio/spring/gradle/bintray/SpringBintrayExtension;", "setExt", "(Lio/spring/gradle/bintray/SpringBintrayExtension;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "apply", "", "project", "spring-bintray-plugin"})
public final class SpringBintrayPlugin
implements Plugin<Project> {
    @NotNull
    public SpringBintrayExtension ext;
    private final Logger logger = LoggerFactory.getLogger(SpringBintrayPlugin.class);

    @NotNull
    public final SpringBintrayExtension getExt() {
        SpringBintrayExtension springBintrayExtension = this.ext;
        if (springBintrayExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ext");
        }
        return springBintrayExtension;
    }

    public final void setExt(@NotNull SpringBintrayExtension springBintrayExtension) {
        Intrinsics.checkParameterIsNotNull((Object)springBintrayExtension, (String)"<set-?>");
        this.ext = springBintrayExtension;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object object = project.getExtensions().create("bintray", SpringBintrayExtension.class, new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.extensions.creat\u2026rayExtension::class.java)");
        this.ext = (SpringBintrayExtension)object;
        CreatePackageTask createPackageTask = (CreatePackageTask)project.getTasks().create("bintrayCreatePackage", CreatePackageTask.class);
        CreateVersionTask createVersionTask = (CreateVersionTask)project.getTasks().create("bintrayCreateVersion", CreateVersionTask.class);
        createVersionTask.dependsOn(new Object[]{createPackageTask});
        UploadTask uploadTask = (UploadTask)project.getTasks().create("bintrayUpload", UploadTask.class);
        uploadTask.dependsOn(new Object[]{createVersionTask});
        SignTask signTask = (SignTask)project.getTasks().create("bintraySign", SignTask.class);
        signTask.dependsOn(new Object[]{uploadTask});
        PublishTask publishTask = (PublishTask)project.getTasks().create("bintrayPublish", PublishTask.class);
        publishTask.dependsOn(new Object[]{uploadTask});
        MavenCentralSyncTask mavenCentralSyncTask = (MavenCentralSyncTask)project.getTasks().create("mavenCentralSync", MavenCentralSyncTask.class);
        mavenCentralSyncTask.dependsOn(new Object[]{publishTask});
        project.afterEvaluate((Action)new Action<Project>(this, project, createPackageTask, createVersionTask, uploadTask, signTask, publishTask, mavenCentralSyncTask){
            final /* synthetic */ SpringBintrayPlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ CreatePackageTask $createPackageTask;
            final /* synthetic */ CreateVersionTask $createVersionTask;
            final /* synthetic */ UploadTask $uploadTask;
            final /* synthetic */ SignTask $signTask;
            final /* synthetic */ PublishTask $publishTask;
            final /* synthetic */ MavenCentralSyncTask $mavenCentralSyncTask;

            public final void execute(Project it) {
                this.$project.getTasks().withType(CreateVersionTask.class, (Action)new Action<CreateVersionTask>(this){
                    final /* synthetic */ apply.1 this$0;

                    public final void execute(CreateVersionTask t) {
                        System.out.println();
                        if (this.this$0.this$0.getExt().getPublication() != null) {
                            Object object = this.this$0.$project.getExtensions().getByType(PublishingExtension.class);
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.extensions.getBy\u2026ingExtension::class.java)");
                            Publication publication2 = (Publication)((PublishingExtension)object).getPublications().findByName(this.this$0.this$0.getExt().getPublication());
                            if (publication2 instanceof MavenPublication) {
                                MavenArtifactSet mavenArtifactSet = ((MavenPublication)publication2).getArtifacts();
                                Intrinsics.checkExpressionValueIsNotNull((Object)mavenArtifactSet, (String)"publication.artifacts");
                                Iterable $receiver$iv = (Iterable)mavenArtifactSet;
                                for (T element$iv : $receiver$iv) {
                                    MavenArtifact artifact = (MavenArtifact)element$iv;
                                    Object[] objectArray = new Object[1];
                                    MavenArtifact mavenArtifact = artifact;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)mavenArtifact, (String)"artifact");
                                    objectArray[0] = mavenArtifact.getBuildDependencies();
                                    t.dependsOn(objectArray);
                                }
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                this.$project.getTasks().withType(UploadTask.class, (Action)new Action<UploadTask>(this){
                    final /* synthetic */ apply.1 this$0;

                    public final void execute(UploadTask t) {
                        if (this.this$0.this$0.getExt().getPublication() != null) {
                            Object object = this.this$0.$project.getExtensions().getByType(PublishingExtension.class);
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.extensions.getBy\u2026ingExtension::class.java)");
                            Publication publication2 = (Publication)((PublishingExtension)object).getPublications().findByName(this.this$0.this$0.getExt().getPublication());
                            if (publication2 instanceof MavenPublication) {
                                Object[] objectArray = new Object[1];
                                StringBuilder stringBuilder = new StringBuilder().append("generatePomFileFor");
                                String string = ((MavenPublication)publication2).getName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"publication.name");
                                objectArray[0] = stringBuilder.append(StringsKt.capitalize((String)string)).append("Publication").toString();
                                t.dependsOn(objectArray);
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                if (this.this$0.getExt().bintrayUser(this.$project) == null || this.this$0.getExt().bintrayKey(this.$project) == null || this.this$0.getExt().getRepo() == null || this.this$0.getExt().getPublication() == null || this.this$0.getExt().getLicenses() == null) {
                    Iterable $receiver$iv = CollectionsKt.listOf((Object[])new AbstractBintrayTask[]{this.$createPackageTask, this.$createVersionTask, this.$uploadTask, this.$signTask, this.$publishTask, this.$mavenCentralSyncTask});
                    for (T element$iv : $receiver$iv) {
                        AbstractBintrayTask it2 = (AbstractBintrayTask)((Object)element$iv);
                        it2.onlyIf((Spec)new Spec<Task>(this){
                            final /* synthetic */ apply.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final boolean isSatisfiedBy(Task it) {
                                this.this$0.$project.getLogger().warn("bintray.[bintrayUser, bintrayKey, repo, publication, licenses] are all required for Bintray publishing");
                                return false;
                            }
                        });
                    }
                }
            }
            {
                this.this$0 = springBintrayPlugin;
                this.$project = project;
                this.$createPackageTask = createPackageTask;
                this.$createVersionTask = createVersionTask;
                this.$uploadTask = uploadTask;
                this.$signTask = signTask;
                this.$publishTask = publishTask;
                this.$mavenCentralSyncTask = mavenCentralSyncTask;
            }
        });
    }
}

