/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.bintray;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.io.Closeable;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0001J \u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/spring/gradle/bintray/BintrayClient;", "", "bintrayUser", "", "bintrayKey", "(Ljava/lang/String;Ljava/lang/String;)V", "getBintrayKey", "()Ljava/lang/String;", "getBintrayUser", "interceptors", "", "Lokhttp3/Interceptor;", "getInterceptors", "()Ljava/util/List;", "setInterceptors", "(Ljava/util/List;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "get", "Lokhttp3/Response;", "path", "head", "headIsSuccessful", "", "httpClient", "Lokhttp3/OkHttpClient;", "post", "body", "upload", "artifact", "Ljava/io/File;", "gpgPassphrase", "Companion", "spring-bintray-plugin"})
public final class BintrayClient {
    private final ObjectMapper mapper;
    @NotNull
    private List<? extends Interceptor> interceptors;
    @Nullable
    private final String bintrayUser;
    @Nullable
    private final String bintrayKey;
    @NotNull
    public static final String BINTRAY_API_URL = "https://api.bintray.com";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public final void setInterceptors(@NotNull List<? extends Interceptor> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.interceptors = list;
    }

    private final OkHttpClient httpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.MINUTES).writeTimeout(6L, TimeUnit.MINUTES);
        Iterable $receiver$iv = this.interceptors;
        for (Object element$iv : $receiver$iv) {
            Interceptor it = (Interceptor)element$iv;
            builder = builder.addInterceptor(it);
        }
        OkHttpClient okHttpClient = builder.authenticator(new Authenticator(this){
            final /* synthetic */ BintrayClient this$0;

            @Nullable
            public final Request authenticate(Route $noName_0, Response response) {
                Request request;
                if (this.this$0.getBintrayUser() != null && this.this$0.getBintrayKey() != null) {
                    String credential = Credentials.basic((String)this.this$0.getBintrayUser(), (String)this.this$0.getBintrayKey());
                    request = response.request().newBuilder().header("Authorization", credential).build();
                } else {
                    request = response.request().newBuilder().build();
                }
                return request;
            }
            {
                this.this$0 = bintrayClient2;
            }
        }).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"builder\n\t\t\t\t.authenticat\u2026ild()\n\t\t\t\t})\n\t\t\t\t.build()");
        return okHttpClient;
    }

    @NotNull
    public final Response head(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Response response = this.httpClient().newCall(new Request.Builder().head().url("https://api.bintray.com/" + path).build()).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"httpClient()\n\t\t\t.newCall\u2026\").build())\n\t\t\t.execute()");
        return response;
    }

    @NotNull
    public final Response get(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Response response = this.httpClient().newCall(new Request.Builder().get().url("https://api.bintray.com/" + path).build()).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"httpClient()\n\t\t\t.newCall\u2026\").build())\n\t\t\t.execute()");
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean headIsSuccessful(@NotNull String path) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Closeable closeable = (Closeable)this.head(path);
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            bl = response.isSuccessful();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return bl;
    }

    @NotNull
    public final Response post(@NotNull String path, @NotNull Object body) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        RequestBody bodyStr = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.mapper.writeValueAsString(body));
        Request request = new Request.Builder().url("https://api.bintray.com/" + path).post(bodyStr).build();
        Response response = this.httpClient().newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"httpClient().newCall(request).execute()");
        return response;
    }

    @NotNull
    public final Response upload(@NotNull String path, @NotNull File artifact, @Nullable String gpgPassphrase) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)artifact, (String)"artifact");
        Request.Builder requestBuilder = new Request.Builder().header("Content-Type", "*/*");
        CharSequence charSequence = gpgPassphrase;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String string = gpgPassphrase;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            requestBuilder = requestBuilder.header("X-GPG-PASSPHRASE", string);
        }
        Request request = requestBuilder.put(RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)artifact)).url("https://api.bintray.com/" + path).build();
        Response response = this.httpClient().newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"httpClient().newCall(request).execute()");
        return response;
    }

    @Nullable
    public final String getBintrayUser() {
        return this.bintrayUser;
    }

    @Nullable
    public final String getBintrayKey() {
        return this.bintrayKey;
    }

    public BintrayClient(@Nullable String bintrayUser, @Nullable String bintrayKey) {
        this.bintrayUser = bintrayUser;
        this.bintrayKey = bintrayKey;
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new KotlinModule(0, 1, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"ObjectMapper().registerModule(KotlinModule())");
        this.mapper = objectMapper;
        this.interceptors = CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/spring/gradle/bintray/BintrayClient$Companion;", "", "()V", "BINTRAY_API_URL", "", "spring-bintray-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

