/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.javadoc;

import io.spring.gradle.javadoc.JavadocPlugin;
import java.io.File;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.javadoc.Javadoc;

public class AggregateJavadocPlugin
implements Plugin<Project> {
    public static final String AGGREGATE_JAVADOC_TASK_NAME = "aggregateJavadoc";

    public void apply(Project project) {
        project.getPlugins().apply(JavaPlugin.class);
        this.aggregatedDependencies(project);
        Configuration sourcesPath = this.sourcesPath(project);
        this.aggregatedJavadoc(project, sourcesPath);
    }

    private void aggregatedDependencies(final Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        final Configuration implementation = configurations.getByName("implementation");
        project.getGradle().getRootProject().subprojects((Action)new Action<Project>(){

            public void execute(final Project subproject) {
                subproject.getPlugins().withType(JavadocPlugin.class, (Action)new Action<JavadocPlugin>(){

                    public void execute(JavadocPlugin javadoc) {
                        Dependency dependency = project.getDependencies().create((Object)subproject);
                        implementation.getDependencies().add((Object)dependency);
                    }
                });
            }
        });
    }

    private Configuration sourcesPath(final Project project) {
        final ConfigurationContainer configurations = project.getConfigurations();
        return (Configuration)configurations.create("sourcesPath", (Action)new Action<Configuration>(){

            public void execute(Configuration config) {
                config.setCanBeResolved(true);
                config.setCanBeConsumed(false);
                config.extendsFrom(new Configuration[]{configurations.getByName("implementation")});
                config.attributes((Action)new Action<AttributeContainer>(){

                    public void execute(AttributeContainer attributes) {
                        ObjectFactory objects = project.getObjects();
                        attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "java-runtime"));
                        attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)objects.named(Category.class, "documentation"));
                        attributes.attribute(DocsType.DOCS_TYPE_ATTRIBUTE, (Object)objects.named(DocsType.class, "sources"));
                        attributes.attribute(Attribute.of((String)"org.gradle.docselements", String.class), (Object)"sources");
                    }
                });
                config.outgoing((Action)new Action<ConfigurationPublications>(){

                    public void execute(final ConfigurationPublications publications) {
                        JavaPluginConvention javaPlugin = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                        SourceSet mainSrc = (SourceSet)javaPlugin.getSourceSets().getByName("main");
                        mainSrc.getAllJava().getSrcDirs().forEach(new Consumer<File>(){

                            @Override
                            public void accept(File file) {
                                publications.artifact((Object)file);
                            }
                        });
                    }
                });
            }
        });
    }

    private void aggregatedJavadoc(final Project project, final Configuration sourcesPath) {
        project.getTasks().create(AGGREGATE_JAVADOC_TASK_NAME, Javadoc.class, (Action)new Action<Javadoc>(){

            public void execute(Javadoc javadoc) {
                javadoc.setGroup("Documentation");
                javadoc.setDescription("Generates the aggregate Javadoc");
                ConfigurationContainer configurations = project.getConfigurations();
                Configuration compile = configurations.getByName("compileClasspath");
                javadoc.setSource((Object)sourcesPath);
                javadoc.setClasspath((FileCollection)compile);
            }
        });
    }
}

