/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.org.eclipse.sisu.space;

import com.google.inject.Injector;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.DeferredClass;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.DeferredProvider;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.Logs;
import javax.inject.Inject;

abstract class AbstractDeferredClass<T>
implements DeferredClass<T>,
DeferredProvider<T> {
    @Inject
    private Injector injector;

    AbstractDeferredClass() {
    }

    @Override
    public final DeferredProvider<T> asProvider() {
        return this;
    }

    public final T get() {
        try {
            return (T)this.injector.getInstance(this.load());
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                Logs.warn("Error injecting: {}", this.getName(), e);
            }
            finally {
                Logs.throwUnchecked(e);
            }
            return null;
        }
    }

    @Override
    public final DeferredClass<T> getImplementationClass() {
        return this;
    }
}

