/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.antora;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public abstract class GenerateAntoraYmlTask
extends DefaultTask {
    @OutputFile
    abstract RegularFileProperty getOutputFile();

    @Internal
    abstract Property<String> getComponentName();

    @Internal
    public abstract Property<String> getVersion();

    @Internal
    public abstract MapProperty<String, Object> getAsciidocAttributes();

    @Internal
    public abstract MapProperty<String, Object> getAsciidoc();

    @Internal
    abstract MapProperty<String, Object> getYml();

    @Internal
    abstract RegularFileProperty getBaseAntoraYmlFile();

    @Input
    final Map<String, Object> getAntoraYmlMap() throws FileNotFoundException {
        String componentName = (String)this.getComponentName().getOrElse(null);
        Map<String, Object> versionAttributes = this.getAntoraVersionAttributes();
        Map asciidocAttributes = (Map)this.getAsciidocAttributes().getOrElse(Collections.emptyMap());
        Map asciidoc = (Map)this.getAsciidoc().getOrElse(Collections.emptyMap());
        Map yml = (Map)this.getYml().getOrElse(Collections.emptyMap());
        Map<String, Object> baseAntoraYml = this.loadBaseAntoraYmlFile();
        Map<String, Object> mergedAsciidocAttributes = GenerateAntoraYmlTask.mergeMaps(asciidocAttributes, GenerateAntoraYmlTask.fromMapGetNestedMap(asciidoc, "attributes"), GenerateAntoraYmlTask.fromMapGetNestedMap(yml, "asciidoc", "attributes"), GenerateAntoraYmlTask.fromMapGetNestedMap(baseAntoraYml, "asciidoc", "attributes"));
        Map<String, Object> mergedAsciidoc = GenerateAntoraYmlTask.mergeMaps(asciidoc, GenerateAntoraYmlTask.fromMapGetNestedMap(yml, "asciidoc"), GenerateAntoraYmlTask.fromMapGetNestedMap(baseAntoraYml, "asciidoc"));
        Map<String, Object> mergedYml = GenerateAntoraYmlTask.mergeMaps(yml, baseAntoraYml);
        if (!mergedAsciidocAttributes.isEmpty()) {
            mergedAsciidoc.put("attributes", mergedAsciidocAttributes);
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Object mergedName = mergedYml.get("name");
        if (mergedName == null) {
            result.put("name", componentName);
        } else {
            result.put("name", mergedName);
        }
        GenerateAntoraYmlTask.intoMapPutAllFromMapIfAbsent(result, versionAttributes);
        GenerateAntoraYmlTask.intoMapPutAllFromMapIfAbsent(result, mergedYml);
        if (!mergedAsciidoc.isEmpty()) {
            result.put("asciidoc", mergedAsciidoc);
        }
        return result;
    }

    private static Map<String, Object> fromMapGetNestedMap(Map<String, Object> map, String ... keys) {
        if (map == null) {
            return new LinkedHashMap<String, Object>();
        }
        for (String key : keys) {
            if ((map = (Map)map.get(key)) != null) continue;
            return new LinkedHashMap<String, Object>();
        }
        return map;
    }

    private static Map<String, Object> mergeMaps(Map<String, Object> ... maps) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map<String, Object> map : maps) {
            GenerateAntoraYmlTask.intoMapPutAllFromMapIfAbsent(result, map);
        }
        return result;
    }

    private static void intoMapPutAllFromMapIfAbsent(Map<String, Object> intoMap, Map<String, Object> fromMap) {
        for (Map.Entry<String, Object> entry : fromMap.entrySet()) {
            intoMap.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    @TaskAction
    public void writeAntoraYml() throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        Yaml yaml = new Yaml(options);
        File generatedAntoraYmlFile = ((RegularFile)this.getOutputFile().get()).getAsFile();
        Map<String, Object> data = this.getAntoraYmlMap();
        if (data.isEmpty()) {
            generatedAntoraYmlFile.createNewFile();
            return;
        }
        yaml.dump(data, (Writer)new FileWriter(generatedAntoraYmlFile));
    }

    private Map<String, Object> getAntoraVersionAttributes() {
        String configuredVersion = (String)this.getVersion().getOrNull();
        if (configuredVersion == null) {
            return Collections.emptyMap();
        }
        String antoraVersion = configuredVersion;
        Object prerelease = null;
        String[] versionComponents = configuredVersion.split("(?=-)");
        if (versionComponents.length > 1) {
            if ("-SNAPSHOT".equals(versionComponents[1])) {
                antoraVersion = versionComponents[0];
                prerelease = "-SNAPSHOT";
            } else {
                prerelease = Boolean.TRUE;
            }
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(2);
        result.put("version", antoraVersion);
        if (prerelease != null) {
            result.put("prerelease", prerelease);
        }
        return result;
    }

    private Map<String, Object> loadBaseAntoraYmlFile() throws FileNotFoundException {
        File antoraYmlFile;
        RegularFile baseAntoraYmlRegularFile = (RegularFile)this.getBaseAntoraYmlFile().getOrNull();
        File file = antoraYmlFile = baseAntoraYmlRegularFile == null ? null : baseAntoraYmlRegularFile.getAsFile();
        if (antoraYmlFile == null || !antoraYmlFile.exists()) {
            return Collections.emptyMap();
        }
        Yaml yaml = new Yaml();
        return (Map)yaml.loadAs((InputStream)new FileInputStream(antoraYmlFile), LinkedHashMap.class);
    }
}

