/*
 * Decompiled with CFR 0.152.
 */
package io.split.service;

import io.split.client.utils.Utils;
import io.split.telemetry.domain.enums.HttpParamsWrapper;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;
import split.org.apache.hc.client5.http.classic.methods.HttpPost;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import split.org.apache.hc.core5.http.HttpEntity;

public class HttpPostImp {
    private static final Logger _logger = LoggerFactory.getLogger(HttpPostImp.class);
    private CloseableHttpClient _client;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;

    public HttpPostImp(CloseableHttpClient client, TelemetryRuntimeProducer telemetryRuntimeProducer) {
        this._client = client;
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
    }

    public void post(URI uri, Object object, String posted, HttpParamsWrapper httpParamsWrapper) {
        long initTime = System.currentTimeMillis();
        HttpEntity entity = Utils.toJsonEntity(object);
        HttpPost request = new HttpPost(uri);
        request.setEntity(entity);
        try (CloseableHttpResponse response = this._client.execute(request);){
            int status = response.getCode();
            if (status < 200 || status >= 300) {
                this._telemetryRuntimeProducer.recordSyncError(httpParamsWrapper.getResourceEnum(), status);
                _logger.warn("Response status was: " + status);
                return;
            }
            this._telemetryRuntimeProducer.recordSyncLatency(httpParamsWrapper.getHttpLatenciesEnum(), System.currentTimeMillis() - initTime);
            this._telemetryRuntimeProducer.recordSuccessfulSync(httpParamsWrapper.getLastSynchronizationRecordsEnum(), System.currentTimeMillis());
        }
        catch (Throwable t) {
            _logger.warn("Exception when posting " + posted + object, t);
        }
    }
}

