/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.utils;

import io.split.client.utils.Json;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import split.com.google.common.base.Preconditions;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import split.org.apache.hc.core5.http.ContentType;
import split.org.apache.hc.core5.http.HttpEntity;
import split.org.apache.hc.core5.http.io.entity.HttpEntities;
import split.org.apache.hc.core5.net.URIBuilder;

public class Utils {
    public static HttpEntity toJsonEntity(Object obj) {
        String json = Json.toJson(obj);
        return HttpEntities.create(json, ContentType.APPLICATION_JSON);
    }

    public static void forceClose(CloseableHttpResponse response) {
        try {
            if (response != null) {
                response.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static URI appendPath(URI root, String pathToAppend) throws URISyntaxException {
        Preconditions.checkNotNull(root);
        Preconditions.checkNotNull(pathToAppend);
        String path = String.format("%s%s%s", root.getPath(), root.getPath().endsWith("/") ? "" : "/", pathToAppend);
        return new URIBuilder(root).setPath(path).build();
    }
}

