/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.sdk.serde;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import com.netflix.spinnaker.kork.plugins.api.serde.SerdeService;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\u0005\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J-\u0010\u0012\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0016\u00a2\u0006\u0002\u0010\u0014J7\u0010\u0012\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/netflix/spinnaker/kork/plugins/sdk/serde/SerdeServiceImpl;", "Lcom/netflix/spinnaker/kork/plugins/api/serde/SerdeService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "fromJson", "T", "", "json", "", "type", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getPointer", "Lcom/fasterxml/jackson/databind/JsonNode;", "pointer", "rootNode", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "mapTo", "obj", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;", "toJson", "kork-plugins"})
public final class SerdeServiceImpl
implements SerdeService {
    private final ObjectMapper objectMapper;

    @NotNull
    public String toJson(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        try {
            String string = this.objectMapper.writeValueAsString(obj);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"objectMapper.writeValueAsString(obj)");
            return string;
        }
        catch (JsonProcessingException e) {
            throw (Throwable)new IntegrationException("Failed serializing object to json", (Throwable)e);
        }
    }

    @NotNull
    public <T> T fromJson(@NotNull String json, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        try {
            Object object = this.objectMapper.readValue(json, type);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.readValue(json, type)");
            return (T)object;
        }
        catch (JsonProcessingException e) {
            throw (Throwable)new IntegrationException("Failed deserializing json to class", (Throwable)e);
        }
    }

    @NotNull
    public <T> T mapTo(@NotNull Object obj, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.mapTo(null, obj, type);
    }

    @NotNull
    public <T> T mapTo(@Nullable String pointer, @NotNull Object obj, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        try {
            JsonNode jsonNode = this.objectMapper.valueToTree(obj);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"objectMapper.valueToTree(obj)");
            Object object = this.objectMapper.readValue((JsonParser)new TreeTraversingParser(this.getPointer(pointer, (ObjectNode)jsonNode), (ObjectCodec)this.objectMapper), type);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.readValue(\n\u2026  ),\n        type\n      )");
            return (T)object;
        }
        catch (IOException e) {
            throw (Throwable)new IntegrationException("Failed mapping object to '" + type + '\'', (Throwable)e);
        }
    }

    private final JsonNode getPointer(String pointer, ObjectNode rootNode) {
        JsonNode jsonNode;
        if (pointer != null) {
            JsonNode jsonNode2 = rootNode.at(pointer);
            jsonNode = jsonNode2;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"rootNode.at(pointer)");
        } else {
            jsonNode = (JsonNode)rootNode;
        }
        return jsonNode;
    }

    public SerdeServiceImpl(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.objectMapper = objectMapper;
    }
}

