/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.sdk.httpclient.internal;

import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import com.netflix.spinnaker.kork.plugins.api.httpclient.HttpClientConfig;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.OkHttp3ClientFactory;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/internal/CompositeOkHttpClientFactory;", "Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/OkHttp3ClientFactory;", "factories", "", "(Ljava/util/List;)V", "create", "Lokhttp3/OkHttpClient;", "baseUrl", "", "config", "Lcom/netflix/spinnaker/kork/plugins/api/httpclient/HttpClientConfig;", "normalizeBaseUrl", "supports", "", "kork-plugins"})
public final class CompositeOkHttpClientFactory
implements OkHttp3ClientFactory {
    private final List<OkHttp3ClientFactory> factories;

    @Override
    public boolean supports(@NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        return true;
    }

    @Override
    @NotNull
    public String normalizeBaseUrl(@NotNull String baseUrl) {
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Iterable $this$firstOrNull$iv = this.factories;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OkHttp3ClientFactory it = (OkHttp3ClientFactory)element$iv;
                boolean bl = false;
                if (!it.supports(baseUrl)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (OkHttp3ClientFactory)v0) == null || (object = object.normalizeBaseUrl(baseUrl)) == null) {
            throw (Throwable)new IntegrationException("No HttpClientFactory supports the provided baseUrl: " + baseUrl);
        }
        return object;
    }

    @Override
    @NotNull
    public OkHttpClient create(@NotNull String baseUrl, @NotNull HttpClientConfig config) {
        OkHttp3ClientFactory okHttp3ClientFactory;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Iterable $this$firstOrNull$iv = this.factories;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OkHttp3ClientFactory it = (OkHttp3ClientFactory)element$iv;
                boolean bl = false;
                if (!it.supports(baseUrl)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((okHttp3ClientFactory = (OkHttp3ClientFactory)v0) == null || (okHttp3ClientFactory = okHttp3ClientFactory.create(baseUrl, config)) == null) {
            throw (Throwable)new IntegrationException("No HttpClientFactory supports the provided baseUrl: " + baseUrl);
        }
        return okHttp3ClientFactory;
    }

    public CompositeOkHttpClientFactory(@NotNull List<? extends OkHttp3ClientFactory> factories) {
        Intrinsics.checkNotNullParameter(factories, (String)"factories");
        this.factories = factories;
    }
}

