/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.api.expressions;

import com.netflix.spinnaker.kork.plugins.api.internal.SpinnakerExtensionPoint;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public interface ExpressionFunctionProvider
extends SpinnakerExtensionPoint {
    @Nullable
    public String getNamespace();

    public Functions getFunctions();

    public static class FunctionUsageExample {
        private final String usage;
        private final String description;

        public FunctionUsageExample(String usage, String description) {
            this.usage = usage;
            this.description = description;
        }

        public String getUsage() {
            return this.usage;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class FunctionDocumentation {
        private final String documentation;
        @Nullable
        private final List<FunctionUsageExample> examples;

        public FunctionDocumentation(String documentation) {
            this.documentation = documentation;
            this.examples = null;
        }

        public FunctionDocumentation(String documentation, List<FunctionUsageExample> examples) {
            this.documentation = documentation;
            this.examples = examples;
        }

        public FunctionDocumentation(String documentation, FunctionUsageExample ... examples) {
            this.documentation = documentation;
            this.examples = Arrays.asList(examples);
        }

        public String getDocumentation() {
            return this.documentation;
        }

        @Nullable
        public List<FunctionUsageExample> getExamples() {
            return this.examples;
        }
    }

    public static class FunctionParameter {
        private final Class<?> type;
        private final String name;
        private final String description;

        public FunctionParameter(Class<?> type, String name, String description) {
            this.type = type;
            this.name = name;
            this.description = description;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class FunctionDefinition {
        private final String name;
        private final String description;
        private final List<FunctionParameter> parameters;
        @Nullable
        private final FunctionDocumentation documentation;

        @Deprecated
        public FunctionDefinition(String name, FunctionParameter ... functionParameters) {
            this(name, "", Arrays.asList(functionParameters));
        }

        public FunctionDefinition(String name, String description, List<FunctionParameter> parameters, @Nullable FunctionDocumentation documentation) {
            this.name = name;
            this.description = description;
            this.parameters = parameters;
            this.documentation = documentation;
        }

        public FunctionDefinition(String name, String description, FunctionParameter ... parameters) {
            this(name, description, Arrays.asList(parameters));
        }

        public FunctionDefinition(String name, String description, List<FunctionParameter> parameters) {
            this(name, description, parameters, null);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<FunctionParameter> getParameters() {
            return this.parameters;
        }

        @Nullable
        public FunctionDocumentation getDocumentation() {
            return this.documentation;
        }
    }

    public static class Functions {
        private final Collection<FunctionDefinition> functionsDefinitions;

        public Functions(Collection<FunctionDefinition> functionsDefinitions) {
            this.functionsDefinitions = functionsDefinitions;
        }

        public Functions(FunctionDefinition ... functionDefinitions) {
            this(Arrays.asList(functionDefinitions));
        }

        public Collection<FunctionDefinition> getFunctionsDefinitions() {
            return this.functionsDefinitions;
        }
    }
}

