/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.sql;

import com.netflix.spinnaker.keel.persistence.TaskRecord;
import com.netflix.spinnaker.keel.persistence.TaskTrackingRepository;
import com.netflix.spinnaker.keel.persistence.metamodel.Tables;
import com.netflix.spinnaker.keel.sql.RetryCategory;
import com.netflix.spinnaker.keel.sql.SqlRetry;
import com.netflix.spinnaker.keel.sql.SqlTaskTrackingRepository;
import java.time.Clock;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.RecordMapper;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/netflix/spinnaker/keel/sql/SqlTaskTrackingRepository;", "Lcom/netflix/spinnaker/keel/persistence/TaskTrackingRepository;", "jooq", "Lorg/jooq/DSLContext;", "clock", "Ljava/time/Clock;", "sqlRetry", "Lcom/netflix/spinnaker/keel/sql/SqlRetry;", "(Lorg/jooq/DSLContext;Ljava/time/Clock;Lcom/netflix/spinnaker/keel/sql/SqlRetry;)V", "delete", "", "taskId", "", "getTasks", "", "Lcom/netflix/spinnaker/keel/persistence/TaskRecord;", "store", "task", "keel-sql"})
public final class SqlTaskTrackingRepository
implements TaskTrackingRepository {
    private final DSLContext jooq;
    private final Clock clock;
    private final SqlRetry sqlRetry;

    public void store(@NotNull TaskRecord task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, task){
            final /* synthetic */ SqlTaskTrackingRepository this$0;
            final /* synthetic */ TaskRecord $task;

            public final int invoke() {
                return SqlTaskTrackingRepository.access$getJooq$p(this.this$0).insertInto((Table)Tables.TASK_TRACKING).set((Field)Tables.TASK_TRACKING.SUBJECT, (Object)this.$task.getSubject()).set((Field)Tables.TASK_TRACKING.TASK_ID, (Object)this.$task.getId()).set((Field)Tables.TASK_TRACKING.TASK_NAME, (Object)this.$task.getName()).set((Field)Tables.TASK_TRACKING.TIMESTAMP, (Object)SqlTaskTrackingRepository.access$getClock$p(this.this$0).instant()).onDuplicateKeyIgnore().execute();
            }
            {
                this.this$0 = sqlTaskTrackingRepository;
                this.$task = taskRecord;
                super(0);
            }
        });
    }

    @NotNull
    public Set<TaskRecord> getTasks() {
        return (Set)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Set<? extends TaskRecord>>(this){
            final /* synthetic */ SqlTaskTrackingRepository this$0;

            @NotNull
            public final Set<TaskRecord> invoke() {
                List list = SqlTaskTrackingRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.TASK_TRACKING.SUBJECT, (SelectField)Tables.TASK_TRACKING.TASK_ID, (SelectField)Tables.TASK_TRACKING.TASK_NAME).from((TableLike)Tables.TASK_TRACKING).fetch().map((RecordMapper)getTasks.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq\n        .select(TAS\u2026e, resource_id)\n        }");
                return CollectionsKt.toSet((Iterable)list);
            }
            {
                this.this$0 = sqlTaskTrackingRepository;
                super(0);
            }
        });
    }

    public void delete(@NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, taskId){
            final /* synthetic */ SqlTaskTrackingRepository this$0;
            final /* synthetic */ String $taskId;

            public final int invoke() {
                return SqlTaskTrackingRepository.access$getJooq$p(this.this$0).deleteFrom((Table)Tables.TASK_TRACKING).where(Tables.TASK_TRACKING.TASK_ID.eq((Object)this.$taskId)).execute();
            }
            {
                this.this$0 = sqlTaskTrackingRepository;
                this.$taskId = string;
                super(0);
            }
        });
    }

    public SqlTaskTrackingRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull SqlRetry sqlRetry) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)sqlRetry, (String)"sqlRetry");
        this.jooq = jooq;
        this.clock = clock;
        this.sqlRetry = sqlRetry;
    }

    public static final /* synthetic */ DSLContext access$getJooq$p(SqlTaskTrackingRepository $this) {
        return $this.jooq;
    }

    public static final /* synthetic */ Clock access$getClock$p(SqlTaskTrackingRepository $this) {
        return $this.clock;
    }
}

