/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.sql;

import com.netflix.spinnaker.keel.pause.Pause;
import com.netflix.spinnaker.keel.pause.PauseScope;
import com.netflix.spinnaker.keel.persistence.PausedRepository;
import com.netflix.spinnaker.keel.persistence.metamodel.Tables;
import com.netflix.spinnaker.keel.sql.RetryCategory;
import com.netflix.spinnaker.keel.sql.SqlPausedRepository;
import com.netflix.spinnaker.keel.sql.SqlRetry;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.RecordMapper;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0018\u0010 \u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J\u0018\u0010#\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0012H\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0012H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lcom/netflix/spinnaker/keel/sql/SqlPausedRepository;", "Lcom/netflix/spinnaker/keel/persistence/PausedRepository;", "jooq", "Lorg/jooq/DSLContext;", "sqlRetry", "Lcom/netflix/spinnaker/keel/sql/SqlRetry;", "clock", "Ljava/time/Clock;", "(Lorg/jooq/DSLContext;Lcom/netflix/spinnaker/keel/sql/SqlRetry;Ljava/time/Clock;)V", "getClock", "()Ljava/time/Clock;", "getJooq", "()Lorg/jooq/DSLContext;", "getSqlRetry", "()Lcom/netflix/spinnaker/keel/sql/SqlRetry;", "applicationPaused", "", "application", "", "exists", "scope", "Lcom/netflix/spinnaker/keel/pause/PauseScope;", "name", "get", "", "getPause", "Lcom/netflix/spinnaker/keel/pause/Pause;", "getPausedApplications", "getPausedResources", "insert", "", "user", "pauseApplication", "pauseResource", "id", "remove", "resourcePaused", "resumeApplication", "resumeResource", "keel-sql"})
public final class SqlPausedRepository
implements PausedRepository {
    @NotNull
    private final DSLContext jooq;
    @NotNull
    private final SqlRetry sqlRetry;
    @NotNull
    private final Clock clock;

    @Nullable
    public Pause getPause(@NotNull PauseScope scope, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Pause)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Pause>(this, scope, name){
            final /* synthetic */ SqlPausedRepository this$0;
            final /* synthetic */ PauseScope $scope;
            final /* synthetic */ String $name;

            public final Pause invoke() {
                return (Pause)this.this$0.getJooq().select((SelectField)Tables.PAUSED.PAUSED_AT, (SelectField)Tables.PAUSED.PAUSED_BY).from((TableLike)Tables.PAUSED).where(Tables.PAUSED.SCOPE.eq((Object)this.$scope)).and(Tables.PAUSED.NAME.eq((Object)this.$name)).fetchOne((RecordMapper)new RecordMapper<Record2<Instant, String>, Pause>(this){
                    final /* synthetic */ getPause.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final Pause map(Record2<Instant, String> $dstr$timestamp$user) {
                        void timestamp;
                        Instant instant = (Instant)$dstr$timestamp$user.component1();
                        String user = (String)$dstr$timestamp$user.component2();
                        PauseScope pauseScope = this.this$0.$scope;
                        String string = this.this$0.$name;
                        String string2 = user;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"user");
                        void v3 = timestamp;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"timestamp");
                        return new Pause(pauseScope, string, string2, (Instant)v3);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlPausedRepository;
                this.$scope = pauseScope;
                this.$name = string;
                super(0);
            }
        });
    }

    public void pauseApplication(@NotNull String application2, @NotNull String user) {
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.insert(PauseScope.APPLICATION, application2, user);
    }

    public void resumeApplication(@NotNull String application2) {
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        this.remove(PauseScope.APPLICATION, application2);
    }

    public boolean applicationPaused(@NotNull String application2) {
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        return this.exists(PauseScope.APPLICATION, application2);
    }

    public void pauseResource(@NotNull String id2, @NotNull String user) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.insert(PauseScope.RESOURCE, id2, user);
    }

    public void resumeResource(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.remove(PauseScope.RESOURCE, id2);
    }

    public boolean resourcePaused(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.exists(PauseScope.RESOURCE, id2);
    }

    @NotNull
    public List<String> getPausedApplications() {
        return this.get(PauseScope.APPLICATION);
    }

    @NotNull
    public List<String> getPausedResources() {
        return this.get(PauseScope.RESOURCE);
    }

    private final void insert(PauseScope scope, String name, String user) {
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, scope, name, user){
            final /* synthetic */ SqlPausedRepository this$0;
            final /* synthetic */ PauseScope $scope;
            final /* synthetic */ String $name;
            final /* synthetic */ String $user;

            public final int invoke() {
                return this.this$0.getJooq().insertInto((Table)Tables.PAUSED).set((Field)Tables.PAUSED.SCOPE, (Object)this.$scope).set((Field)Tables.PAUSED.NAME, (Object)this.$name).set((Field)Tables.PAUSED.PAUSED_AT, (Object)this.this$0.getClock().instant()).set((Field)Tables.PAUSED.PAUSED_BY, (Object)this.$user).onDuplicateKeyIgnore().execute();
            }
            {
                this.this$0 = sqlPausedRepository;
                this.$scope = pauseScope;
                this.$name = string;
                this.$user = string2;
                super(0);
            }
        });
    }

    private final void remove(PauseScope scope, String name) {
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, scope, name){
            final /* synthetic */ SqlPausedRepository this$0;
            final /* synthetic */ PauseScope $scope;
            final /* synthetic */ String $name;

            public final int invoke() {
                return this.this$0.getJooq().deleteFrom((Table)Tables.PAUSED).where(Tables.PAUSED.SCOPE.eq((Object)this.$scope)).and(Tables.PAUSED.NAME.eq((Object)this.$name)).execute();
            }
            {
                this.this$0 = sqlPausedRepository;
                this.$scope = pauseScope;
                this.$name = string;
                super(0);
            }
        });
    }

    private final boolean exists(PauseScope scope, String name) {
        return this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Record1<String>>(this, scope, name){
            final /* synthetic */ SqlPausedRepository this$0;
            final /* synthetic */ PauseScope $scope;
            final /* synthetic */ String $name;

            public final Record1<String> invoke() {
                return (Record1)this.this$0.getJooq().select((SelectField)Tables.PAUSED.NAME).from((TableLike)Tables.PAUSED).where(Tables.PAUSED.SCOPE.eq((Object)this.$scope)).and(Tables.PAUSED.NAME.eq((Object)this.$name)).fetchOne();
            }
            {
                this.this$0 = sqlPausedRepository;
                this.$scope = pauseScope;
                this.$name = string;
                super(0);
            }
        }) != null;
    }

    private final List<String> get(PauseScope scope) {
        Object t = this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<String>>(this, scope){
            final /* synthetic */ SqlPausedRepository this$0;
            final /* synthetic */ PauseScope $scope;

            public final List<String> invoke() {
                return this.this$0.getJooq().select((SelectField)Tables.PAUSED.NAME).from((TableLike)Tables.PAUSED).where(Tables.PAUSED.SCOPE.eq((Object)this.$scope)).fetch((Field)Tables.PAUSED.NAME);
            }
            {
                this.this$0 = sqlPausedRepository;
                this.$scope = pauseScope;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026.fetch(PAUSED.NAME)\n    }");
        return (List)t;
    }

    @NotNull
    public final DSLContext getJooq() {
        return this.jooq;
    }

    @NotNull
    public final SqlRetry getSqlRetry() {
        return this.sqlRetry;
    }

    @NotNull
    public Clock getClock() {
        return this.clock;
    }

    public SqlPausedRepository(@NotNull DSLContext jooq, @NotNull SqlRetry sqlRetry, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)sqlRetry, (String)"sqlRetry");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.jooq = jooq;
        this.sqlRetry = sqlRetry;
        this.clock = clock;
    }
}

