/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.sql;

import com.netflix.spinnaker.keel.notifications.NotificationScope;
import com.netflix.spinnaker.keel.notifications.NotificationType;
import com.netflix.spinnaker.keel.persistence.NotificationRepository;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.Notification;
import com.netflix.spinnaker.keel.sql.RetryCategory;
import com.netflix.spinnaker.keel.sql.SqlRetry;
import java.time.Clock;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0016\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/netflix/spinnaker/keel/sql/SqlNotificationRepository;", "Lcom/netflix/spinnaker/keel/persistence/NotificationRepository;", "clock", "Ljava/time/Clock;", "jooq", "Lorg/jooq/DSLContext;", "sqlRetry", "Lcom/netflix/spinnaker/keel/sql/SqlRetry;", "(Ljava/time/Clock;Lorg/jooq/DSLContext;Lcom/netflix/spinnaker/keel/sql/SqlRetry;)V", "getClock", "()Ljava/time/Clock;", "addNotification", "", "scope", "Lcom/netflix/spinnaker/keel/notifications/NotificationScope;", "ref", "", "type", "Lcom/netflix/spinnaker/keel/notifications/NotificationType;", "clearNotification", "", "dueForNotification", "markSent", "keel-sql"})
public final class SqlNotificationRepository
extends NotificationRepository {
    @NotNull
    private final Clock clock;
    private final DSLContext jooq;
    private final SqlRetry sqlRetry;

    public boolean addNotification(@NotNull NotificationScope scope, @NotNull String ref, @NotNull NotificationType type) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Long l = (Long)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Long>(this, scope, ref, type){
            final /* synthetic */ SqlNotificationRepository this$0;
            final /* synthetic */ NotificationScope $scope;
            final /* synthetic */ String $ref;
            final /* synthetic */ NotificationType $type;

            public final Long invoke() {
                return (Long)SqlNotificationRepository.access$getJooq$p(this.this$0).select((SelectField)Notification.NOTIFICATION.NOTIFY_AT).from((TableLike)Notification.NOTIFICATION).where(Notification.NOTIFICATION.SCOPE.eq((Object)this.$scope)).and(Notification.NOTIFICATION.REF.eq((Object)this.$ref)).and(Notification.NOTIFICATION.TYPE.eq((Object)this.$type)).fetchOne((Field)Notification.NOTIFICATION.NOTIFY_AT);
            }
            {
                this.this$0 = sqlNotificationRepository;
                this.$scope = notificationScope;
                this.$ref = string;
                this.$type = notificationType;
                super(0);
            }
        });
        if (l != null) {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long notificationTime = ((Number)l2).longValue();
            boolean bl3 = false;
            return notificationTime < this.getClock().millis();
        }
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, scope, ref, type){
            final /* synthetic */ SqlNotificationRepository this$0;
            final /* synthetic */ NotificationScope $scope;
            final /* synthetic */ String $ref;
            final /* synthetic */ NotificationType $type;

            public final int invoke() {
                return SqlNotificationRepository.access$getJooq$p(this.this$0).insertInto((Table)Notification.NOTIFICATION).set((Field)Notification.NOTIFICATION.SCOPE, (Object)this.$scope).set((Field)Notification.NOTIFICATION.REF, (Object)this.$ref).set((Field)Notification.NOTIFICATION.TYPE, (Object)this.$type).set((Field)Notification.NOTIFICATION.TIME_DETECTED, (Object)this.this$0.getClock().millis()).set((Field)Notification.NOTIFICATION.NOTIFY_AT, (Object)this.this$0.getClock().millis()).onDuplicateKeyIgnore().execute();
            }
            {
                this.this$0 = sqlNotificationRepository;
                this.$scope = notificationScope;
                this.$ref = string;
                this.$type = notificationType;
                super(0);
            }
        });
        return true;
    }

    public void clearNotification(@NotNull NotificationScope scope, @NotNull String ref, @NotNull NotificationType type) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, scope, ref, type){
            final /* synthetic */ SqlNotificationRepository this$0;
            final /* synthetic */ NotificationScope $scope;
            final /* synthetic */ String $ref;
            final /* synthetic */ NotificationType $type;

            public final int invoke() {
                return SqlNotificationRepository.access$getJooq$p(this.this$0).deleteFrom((Table)Notification.NOTIFICATION).where(Notification.NOTIFICATION.SCOPE.eq((Object)this.$scope)).and(Notification.NOTIFICATION.REF.eq((Object)this.$ref)).and(Notification.NOTIFICATION.TYPE.eq((Object)this.$type)).execute();
            }
            {
                this.this$0 = sqlNotificationRepository;
                this.$scope = notificationScope;
                this.$ref = string;
                this.$type = notificationType;
                super(0);
            }
        });
    }

    public boolean dueForNotification(@NotNull NotificationScope scope, @NotNull String ref, @NotNull NotificationType type) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Long l = (Long)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Long>(this, scope, ref, type){
            final /* synthetic */ SqlNotificationRepository this$0;
            final /* synthetic */ NotificationScope $scope;
            final /* synthetic */ String $ref;
            final /* synthetic */ NotificationType $type;

            public final Long invoke() {
                return (Long)SqlNotificationRepository.access$getJooq$p(this.this$0).select((SelectField)Notification.NOTIFICATION.NOTIFY_AT).from((TableLike)Notification.NOTIFICATION).where(Notification.NOTIFICATION.SCOPE.eq((Object)this.$scope)).and(Notification.NOTIFICATION.REF.eq((Object)this.$ref)).and(Notification.NOTIFICATION.TYPE.eq((Object)this.$type)).fetchOne((Field)Notification.NOTIFICATION.NOTIFY_AT);
            }
            {
                this.this$0 = sqlNotificationRepository;
                this.$scope = notificationScope;
                this.$ref = string;
                this.$type = notificationType;
                super(0);
            }
        });
        if (l != null) {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long notificationTime = ((Number)l2).longValue();
            boolean bl3 = false;
            return notificationTime < this.getClock().millis();
        }
        return false;
    }

    public void markSent(@NotNull NotificationScope scope, @NotNull String ref, @NotNull NotificationType type) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        long waitingMillis = Duration.parse(this.getWaitingDuration()).toMillis();
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, waitingMillis, scope, ref, type){
            final /* synthetic */ SqlNotificationRepository this$0;
            final /* synthetic */ long $waitingMillis;
            final /* synthetic */ NotificationScope $scope;
            final /* synthetic */ String $ref;
            final /* synthetic */ NotificationType $type;

            public final int invoke() {
                return SqlNotificationRepository.access$getJooq$p(this.this$0).update((Table)Notification.NOTIFICATION).set((Field)Notification.NOTIFICATION.NOTIFY_AT, (Object)(this.this$0.getClock().millis() + this.$waitingMillis)).where(new Condition[]{Notification.NOTIFICATION.SCOPE.eq((Object)this.$scope), Notification.NOTIFICATION.REF.eq((Object)this.$ref), Notification.NOTIFICATION.TYPE.eq((Object)this.$type)}).execute();
            }
            {
                this.this$0 = sqlNotificationRepository;
                this.$waitingMillis = l;
                this.$scope = notificationScope;
                this.$ref = string;
                this.$type = notificationType;
                super(0);
            }
        });
    }

    @NotNull
    public Clock getClock() {
        return this.clock;
    }

    public SqlNotificationRepository(@NotNull Clock clock, @NotNull DSLContext jooq, @NotNull SqlRetry sqlRetry) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)sqlRetry, (String)"sqlRetry");
        super(clock, null, 2, null);
        this.clock = clock;
        this.jooq = jooq;
        this.sqlRetry = sqlRetry;
    }

    public static final /* synthetic */ DSLContext access$getJooq$p(SqlNotificationRepository $this) {
        return $this.jooq;
    }
}

