/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.sql;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.keel.api.Constraint;
import com.netflix.spinnaker.keel.api.DeliveryConfig;
import com.netflix.spinnaker.keel.api.Environment;
import com.netflix.spinnaker.keel.api.EnvironmentKt;
import com.netflix.spinnaker.keel.api.NotificationConfig;
import com.netflix.spinnaker.keel.api.PreviewEnvironmentSpec;
import com.netflix.spinnaker.keel.api.Resource;
import com.netflix.spinnaker.keel.api.ResourceSpec;
import com.netflix.spinnaker.keel.api.Verification;
import com.netflix.spinnaker.keel.api.artifacts.DeliveryArtifact;
import com.netflix.spinnaker.keel.api.artifacts.PublishedArtifact;
import com.netflix.spinnaker.keel.api.constraints.ConstraintState;
import com.netflix.spinnaker.keel.api.constraints.ConstraintStateAttributes;
import com.netflix.spinnaker.keel.api.constraints.ConstraintStatus;
import com.netflix.spinnaker.keel.api.constraints.DslKt;
import com.netflix.spinnaker.keel.api.plugins.ArtifactSupplier;
import com.netflix.spinnaker.keel.api.postdeploy.PostDeployAction;
import com.netflix.spinnaker.keel.core.api.ApplicationSummary;
import com.netflix.spinnaker.keel.core.api.UIDKt;
import com.netflix.spinnaker.keel.events.PersistentEvent;
import com.netflix.spinnaker.keel.pause.PauseScope;
import com.netflix.spinnaker.keel.persistence.DeliveryConfigRepository;
import com.netflix.spinnaker.keel.persistence.DependentAttachFilter;
import com.netflix.spinnaker.keel.persistence.NoDeliveryConfigForApplication;
import com.netflix.spinnaker.keel.persistence.NoSuchDeliveryConfigName;
import com.netflix.spinnaker.keel.persistence.OrphanedResourceException;
import com.netflix.spinnaker.keel.persistence.metamodel.Tables;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.DeliveryConfigLastCheckedRecord;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.EnvironmentArtifactQueuedApprovalRecord;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.ResourceRecord;
import com.netflix.spinnaker.keel.resources.ResourceSpecIdentifier;
import com.netflix.spinnaker.keel.resources.SpecMigrator;
import com.netflix.spinnaker.keel.sql.ArtifactUtilsKt;
import com.netflix.spinnaker.keel.sql.JooqKt;
import com.netflix.spinnaker.keel.sql.RetryCategory;
import com.netflix.spinnaker.keel.sql.SqlDeliveryConfigRepository;
import com.netflix.spinnaker.keel.sql.SqlDeliveryConfigRepository$deleteEnvironment$;
import com.netflix.spinnaker.keel.sql.SqlDeliveryConfigRepository$storeConstraintState$;
import com.netflix.spinnaker.keel.sql.SqlRetry;
import com.netflix.spinnaker.keel.sql.SqlStorageContext;
import com.netflix.spinnaker.keel.sql.deliveryconfigs.DeliveryconfigsKt;
import com.netflix.spinnaker.keel.telemetry.AboutToBeChecked;
import de.huxhorn.sulky.ulid.ULID;
import java.net.InetAddress;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.Record10;
import org.jooq.Record11;
import org.jooq.Record2;
import org.jooq.Record3;
import org.jooq.Record5;
import org.jooq.Record8;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TransactionalRunnable;
import org.jooq.UpdateSetFirstStep;
import org.jooq.impl.DSL;
import org.jooq.util.mysql.MySQLDSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 y2\u00020\u00012\u00020\u0002:\u0001yBe\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0016\b\u0002\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f0\u000e\u0012\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00110\u000e\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J(\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020\u0016H\u0016J'\u0010/\u001a\b\u0012\u0004\u0012\u00020+002\u0012\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020302\"\u000203H\u0016\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u0016H\u0002J\u0016\u00107\u001a\b\u0012\u0004\u0012\u0002080\u000e2\u0006\u00109\u001a\u00020\u0016H\u0016J&\u00107\u001a\b\u0012\u0004\u0012\u0002080\u000e2\u0006\u0010:\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u00162\u0006\u0010;\u001a\u00020<H\u0016J.\u00107\u001a\b\u0012\u0004\u0012\u0002080\u000e2\u0006\u0010:\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u00162\u0006\u0010=\u001a\u00020\u00162\u0006\u0010>\u001a\u00020\u0016H\u0016J8\u0010?\u001a\b\u0012\u0004\u0012\u0002080\u000e2\u0006\u0010:\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u00162\u0006\u0010=\u001a\u00020\u00162\u0006\u0010>\u001a\u00020\u00162\b\b\u0002\u0010@\u001a\u00020\u0004H\u0002J(\u0010A\u001a\u00020)2\u0006\u0010:\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020!2\u0006\u0010=\u001a\u00020\u0016H\u0016J\u0010\u0010B\u001a\u00020)2\u0006\u00109\u001a\u00020\u0016H\u0016J\u0010\u0010C\u001a\u00020)2\u0006\u00106\u001a\u00020\u0016H\u0016J \u0010D\u001a\u00020)2\u0006\u0010:\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u00162\u0006\u0010E\u001a\u00020\u0016H\u0016J\u0018\u0010F\u001a\u00020)2\u0006\u0010:\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u0016H\u0016J\u0018\u0010G\u001a\u00020)2\u0006\u0010:\u001a\u00020\u00162\u0006\u0010H\u001a\u00020\u0016H\u0016J \u0010I\u001a\u00020)2\u0006\u0010:\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u00162\u0006\u0010J\u001a\u00020\u0016H\u0016J\u0010\u0010K\u001a\u00020+2\u0006\u0010J\u001a\u00020\u0016H\u0016J\u0010\u0010L\u001a\u00020M2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010N\u001a\n \u0019*\u0004\u0018\u00010\u00160\u00162\u0006\u0010:\u001a\u00020\u0016H\u0002J$\u0010O\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160 0%2\u0006\u0010:\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u0016H\u0002J\u0010\u0010P\u001a\u00020Q2\u0006\u0010J\u001a\u00020\u0016H\u0016J\u001e\u0010R\u001a\b\u0012\u0004\u0012\u00020S002\u0006\u0010:\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u0016H\u0016J\u001a\u0010T\u001a\u0004\u0018\u00010\u00162\u0006\u0010:\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u0016H\u0002J\u0010\u0010U\u001a\u00020+2\u0006\u00106\u001a\u00020\u0016H\u0016J\u000e\u0010V\u001a\b\u0012\u0004\u0012\u00020X0WH\u0016J\u001c\u0010Y\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160 0%2\u0006\u0010Z\u001a\u00020\u0016H\u0002J&\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0\u000e2\u0006\u0010:\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020!H\u0016J\u0010\u0010]\u001a\u00020+2\u0006\u00109\u001a\u00020\u0016H\u0016J4\u0010^\u001a\u0004\u0018\u0001082\u0006\u0010:\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u00162\u0006\u0010=\u001a\u00020\u00162\u0006\u0010E\u001a\u00020\u00162\b\u0010>\u001a\u0004\u0018\u00010\u0016H\u0016J\u0016\u0010_\u001a\u0004\u0018\u0001082\n\u0010\u001e\u001a\u00060`j\u0002`aH\u0016J&\u0010b\u001a\b\u0012\u0004\u0012\u00020\\0\u000e2\u0006\u0010:\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020!H\u0016J\u001c\u0010c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160 0%2\u0006\u00109\u001a\u00020\u0016H\u0002J\u001c\u0010d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160 0%2\u0006\u00109\u001a\u00020\u0016H\u0002J\u0010\u0010e\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u0016H\u0002J\u001e\u0010f\u001a\b\u0012\u0004\u0012\u00020+0W2\u0006\u0010g\u001a\u00020h2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010i\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J(\u0010j\u001a\u00020)2\u0006\u0010:\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020!2\u0006\u0010=\u001a\u00020\u0016H\u0016J4\u0010k\u001a\u001e\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00160\u0016\u0012\f\u0012\n \u0019*\u0004\u0018\u00010<0<0l2\u0006\u0010m\u001a\u00020\u00162\u0006\u0010.\u001a\u00020<H\u0002J\u0010\u0010n\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010o\u001a\u00020)2\u0006\u0010p\u001a\u000208H\u0016J\u0018\u0010q\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010r\u001a\u00020QH\u0002J\u0018\u0010q\u001a\u00020)2\u0006\u0010:\u001a\u00020\u00162\u0006\u0010r\u001a\u00020QH\u0016J\u0010\u0010s\u001a\u00020)2\u0006\u00109\u001a\u00020\u0016H\u0016J(\u0010t\u001a\u001e\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00160\u0016\u0012\f\u0012\n \u0019*\u0004\u0018\u00010<0<0l*\u00020QH\u0002J#\u0010u\u001a\n \u0019*\u0004\u0018\u00010\u00160\u0016\"\b\b\u0000\u0010v*\u00020w*\u0002HvH\u0002\u00a2\u0006\u0002\u0010xR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R#\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rt\u0010\u001e\u001a^\u0012(\u0012&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00160\u0016 \u0019*\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00160\u0016\u0018\u00010 0  \u0019*.\u0012(\u0012&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00160\u0016 \u0019*\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00160\u0016\u0018\u00010 0 \u0018\u00010\u001f0\u001f*\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R$\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160 0%*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006z"}, d2={"Lcom/netflix/spinnaker/keel/sql/SqlDeliveryConfigRepository;", "Lcom/netflix/spinnaker/keel/sql/SqlStorageContext;", "Lcom/netflix/spinnaker/keel/persistence/DeliveryConfigRepository;", "jooq", "Lorg/jooq/DSLContext;", "clock", "Ljava/time/Clock;", "resourceSpecIdentifier", "Lcom/netflix/spinnaker/keel/resources/ResourceSpecIdentifier;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "sqlRetry", "Lcom/netflix/spinnaker/keel/sql/SqlRetry;", "artifactSuppliers", "", "Lcom/netflix/spinnaker/keel/api/plugins/ArtifactSupplier;", "specMigrators", "Lcom/netflix/spinnaker/keel/resources/SpecMigrator;", "publisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lorg/jooq/DSLContext;Ljava/time/Clock;Lcom/netflix/spinnaker/keel/resources/ResourceSpecIdentifier;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/netflix/spinnaker/keel/sql/SqlRetry;Ljava/util/List;Ljava/util/List;Lorg/springframework/context/ApplicationEventPublisher;)V", "RECHECK_LEASE_NAME", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "uid", "Lorg/jooq/SelectConditionStep;", "Lorg/jooq/Record1;", "Lcom/netflix/spinnaker/keel/api/artifacts/DeliveryArtifact;", "getUid", "(Lcom/netflix/spinnaker/keel/api/artifacts/DeliveryArtifact;)Lorg/jooq/SelectConditionStep;", "uids", "Lorg/jooq/Select;", "getUids", "(Ljava/lang/String;)Lorg/jooq/Select;", "addArtifactVersionToEnvironment", "", "deliveryConfig", "Lcom/netflix/spinnaker/keel/api/DeliveryConfig;", "environmentName", "artifact", "version", "all", "", "dependentAttachFilter", "", "Lcom/netflix/spinnaker/keel/persistence/DependentAttachFilter;", "([Lcom/netflix/spinnaker/keel/persistence/DependentAttachFilter;)Ljava/util/Set;", "applicationByDeliveryConfigName", "name", "constraintStateFor", "Lcom/netflix/spinnaker/keel/api/constraints/ConstraintState;", "application", "deliveryConfigName", "limit", "", "artifactVersion", "artifactReference", "constraintStateForWithTransaction", "txn", "deleteArtifactVersionQueuedForApproval", "deleteByApplication", "deleteByName", "deleteConstraintState", "type", "deleteEnvironment", "deletePreviewEnvironment", "baseEnvironmentName", "deleteResourceFromEnv", "resourceId", "deliveryConfigFor", "deliveryConfigLastChecked", "Ljava/time/Instant;", "deliveryConfigUidByName", "envUid", "environmentFor", "Lcom/netflix/spinnaker/keel/api/Environment;", "environmentNotifications", "Lcom/netflix/spinnaker/keel/api/NotificationConfig;", "environmentUidByName", "get", "getApplicationSummaries", "", "Lcom/netflix/spinnaker/keel/core/api/ApplicationSummary;", "getArtifactUIDs", "deliveryConfigUid", "getArtifactVersionsQueuedForApproval", "Lcom/netflix/spinnaker/keel/api/artifacts/PublishedArtifact;", "getByApplication", "getConstraintState", "getConstraintStateById", "Lde/huxhorn/sulky/ulid/ULID$Value;", "Lcom/netflix/spinnaker/keel/core/api/UID;", "getPendingConstraintsForArtifactVersions", "getResourceIDs", "getResourceUIDs", "getUIDByApplication", "itemsDueForCheck", "minTimeSinceLastCheck", "Ljava/time/Duration;", "markCheckComplete", "queueArtifactVersionForApproval", "resourceUidsAndVersionsFor", "", "environmentUid", "store", "storeConstraintState", "state", "storeEnvironment", "environment", "triggerRecheck", "latestResourceUidsAndVersions", "toJson", "T", "", "(Ljava/lang/Object;)Ljava/lang/String;", "Companion", "keel-sql"})
public final class SqlDeliveryConfigRepository
extends SqlStorageContext
implements DeliveryConfigRepository {
    private final Lazy log$delegate;
    private final String RECHECK_LEASE_NAME;
    private final ApplicationEventPublisher publisher;
    private static final int DELETE_CHUNK_SIZE = 20;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        SqlDeliveryConfigRepository sqlDeliveryConfigRepository = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public DeliveryConfig getByApplication(@NotNull String application2) {
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        DeliveryConfig deliveryConfig = (DeliveryConfig)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<DeliveryConfig>(this, application2){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $application;

            public final DeliveryConfig invoke() {
                return (DeliveryConfig)this.this$0.getJooq$keel_sql().select((SelectField)Tables.DELIVERY_CONFIG.UID, (SelectField)Tables.DELIVERY_CONFIG.NAME, (SelectField)Tables.DELIVERY_CONFIG.APPLICATION, (SelectField)Tables.DELIVERY_CONFIG.SERVICE_ACCOUNT, (SelectField)Tables.DELIVERY_CONFIG.METADATA).from((TableLike)Tables.DELIVERY_CONFIG).where(Tables.DELIVERY_CONFIG.APPLICATION.eq((Object)this.$application)).fetchOne((RecordMapper)new RecordMapper<Record5<String, String, String, String, Map<String, ?>>, DeliveryConfig>(this){
                    final /* synthetic */ getByApplication.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final DeliveryConfig map(Record5<String, String, String, String, Map<String, ?>> $dstr$uid$name$application$serviceAccount$metadata) {
                        void uid2;
                        void serviceAccount;
                        void application2;
                        void name;
                        String string = (String)$dstr$uid$name$application$serviceAccount$metadata.component1();
                        String string2 = (String)$dstr$uid$name$application$serviceAccount$metadata.component2();
                        String string3 = (String)$dstr$uid$name$application$serviceAccount$metadata.component3();
                        String string4 = (String)$dstr$uid$name$application$serviceAccount$metadata.component4();
                        Map metadata = (Map)$dstr$uid$name$application$serviceAccount$metadata.component5();
                        void v0 = name;
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"name");
                        void v1 = application2;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"application");
                        void v2 = serviceAccount;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"serviceAccount");
                        Map map = metadata;
                        if (map == null) {
                            map = MapsKt.emptyMap();
                        }
                        ULID.Value value = ULID.parseULID((String)uid2);
                        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"ULID.parseULID(uid)");
                        Map map2 = MapsKt.plus((Map)map, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"createdAt", (Object)UIDKt.timestampAsInstant((ULID.Value)value))));
                        String string5 = null;
                        Set set = null;
                        Set set2 = null;
                        Set set3 = null;
                        void var12_15 = v2;
                        void var13_16 = v1;
                        void var14_17 = v0;
                        map2 = new DeliveryConfig((String)var13_16, (String)var14_17, (String)var12_15, set3, set2, set, string5, map2, 120, null);
                        boolean bl = false;
                        boolean bl2 = false;
                        Map it = map2;
                        boolean bl3 = false;
                        return DeliveryconfigsKt.attachDependents$default(this.this$0.this$0, (DeliveryConfig)it, null, 2, null);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$application = string;
                super(0);
            }
        });
        if (deliveryConfig == null) {
            throw (Throwable)new NoDeliveryConfigForApplication(application2);
        }
        return deliveryConfig;
    }

    public void deleteResourceFromEnv(@NotNull String deliveryConfigName, @NotNull String environmentName, @NotNull String resourceId) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        this.getSqlRetry$keel_sql().withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, deliveryConfigName, environmentName, resourceId){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $deliveryConfigName;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ String $resourceId;

            public final int invoke() {
                return this.this$0.getJooq$keel_sql().deleteFrom((Table)Tables.ENVIRONMENT_RESOURCE).where(Tables.ENVIRONMENT_RESOURCE.ENVIRONMENT_UID.eq(SqlDeliveryConfigRepository.access$envUid(this.this$0, this.$deliveryConfigName, this.$environmentName))).and(Tables.ENVIRONMENT_RESOURCE.RESOURCE_UID.in(SqlDeliveryConfigRepository.access$getUids$p(this.this$0, this.$resourceId))).execute();
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$deliveryConfigName = string;
                this.$environmentName = string2;
                this.$resourceId = string3;
                super(0);
            }
        });
    }

    public void deleteEnvironment(@NotNull String deliveryConfigName, @NotNull String environmentName) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
            Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
            String deliveryConfigUid = this.deliveryConfigUidByName(deliveryConfigName);
            String string = this.environmentUidByName(deliveryConfigName, environmentName);
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String envUid = string2;
            boolean bl3 = false;
            this.getSqlRetry$keel_sql().withRetry(RetryCategory.WRITE, (Function0)new Function0<Unit>(envUid, this, deliveryConfigUid){
                final /* synthetic */ String $envUid;
                final /* synthetic */ SqlDeliveryConfigRepository this$0;
                final /* synthetic */ String $deliveryConfigUid$inlined;
                {
                    this.$envUid = string;
                    this.this$0 = sqlDeliveryConfigRepository;
                    this.$deliveryConfigUid$inlined = string2;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getJooq$keel_sql().transaction(new TransactionalRunnable(this){
                        final /* synthetic */ deleteEnvironment$$inlined$let$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run(Configuration config) {
                            DSLContext txn = DSL.using((Configuration)config);
                            txn.deleteFrom((Table)Tables.ENVIRONMENT).where(Tables.ENVIRONMENT.UID.eq((Object)this.this$0.$envUid)).and(Tables.ENVIRONMENT.DELIVERY_CONFIG_UID.eq((Object)this.this$0.$deliveryConfigUid$inlined)).execute();
                        }
                    });
                }
            });
        }
    }

    public void deletePreviewEnvironment(@NotNull String deliveryConfigName, @NotNull String baseEnvironmentName) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
            Intrinsics.checkNotNullParameter((Object)baseEnvironmentName, (String)"baseEnvironmentName");
            String deliveryConfigUid = this.deliveryConfigUidByName(deliveryConfigName);
            String string = this.environmentUidByName(deliveryConfigName, baseEnvironmentName);
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String baseEnvironmentUid = string2;
            boolean bl3 = false;
            ((Number)this.getSqlRetry$keel_sql().withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(baseEnvironmentUid, this, deliveryConfigUid){
                final /* synthetic */ String $baseEnvironmentUid;
                final /* synthetic */ SqlDeliveryConfigRepository this$0;
                final /* synthetic */ String $deliveryConfigUid$inlined;
                {
                    this.$baseEnvironmentUid = string;
                    this.this$0 = sqlDeliveryConfigRepository;
                    this.$deliveryConfigUid$inlined = string2;
                    super(0);
                }

                public final int invoke() {
                    return this.this$0.getJooq$keel_sql().deleteFrom((Table)Tables.PREVIEW_ENVIRONMENT).where(Tables.PREVIEW_ENVIRONMENT.DELIVERY_CONFIG_UID.eq((Object)this.$deliveryConfigUid$inlined)).and(Tables.PREVIEW_ENVIRONMENT.BASE_ENVIRONMENT_UID.eq((Object)this.$baseEnvironmentUid)).execute();
                }
            })).intValue();
        }
    }

    public void deleteByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = (String)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<String>(this, name){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $name;

            public final String invoke() {
                return (String)this.this$0.getJooq$keel_sql().select((SelectField)Tables.DELIVERY_CONFIG.APPLICATION).from((TableLike)Tables.DELIVERY_CONFIG).where(Tables.DELIVERY_CONFIG.NAME.eq((Object)this.$name)).fetchOne((Field)Tables.DELIVERY_CONFIG.APPLICATION);
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$name = string;
                super(0);
            }
        });
        if (string == null) {
            throw (Throwable)new NoSuchDeliveryConfigName(name);
        }
        String application2 = string;
        this.deleteByApplication(application2);
    }

    public void deleteByApplication(@NotNull String application2) {
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        String configUid = this.getUIDByApplication(application2);
        Select<Record1<String>> resourceUids = this.getResourceUIDs(application2);
        Select<Record1<String>> resourceIds = this.getResourceIDs(application2);
        Select<Record1<String>> artifactUids = this.getArtifactUIDs(configUid);
        this.getSqlRetry$keel_sql().withRetry(RetryCategory.WRITE, (Function0)new Function0<Unit>(this, resourceIds, application2, resourceUids, artifactUids, configUid){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ Select $resourceIds;
            final /* synthetic */ String $application;
            final /* synthetic */ Select $resourceUids;
            final /* synthetic */ Select $artifactUids;
            final /* synthetic */ String $configUid;

            public final void invoke() {
                this.this$0.getJooq$keel_sql().transaction(new TransactionalRunnable(this){
                    final /* synthetic */ deleteByApplication.1 this$0;

                    public final void run(Configuration config) {
                        DSLContext txn = DSL.using((Configuration)config);
                        txn.deleteFrom((Table)Tables.EVENT).where(Tables.EVENT.SCOPE.eq((Object)PersistentEvent.EventScope.RESOURCE)).and(Tables.EVENT.REF.in(this.this$0.$resourceIds)).execute();
                        txn.deleteFrom((Table)Tables.EVENT).where(Tables.EVENT.SCOPE.eq((Object)PersistentEvent.EventScope.APPLICATION)).and(Tables.EVENT.REF.eq((Object)this.this$0.$application)).execute();
                        txn.deleteFrom((Table)Tables.PAUSED).where(Tables.PAUSED.SCOPE.eq((Object)PauseScope.RESOURCE)).and(Tables.PAUSED.NAME.in(this.this$0.$resourceIds)).execute();
                        txn.deleteFrom((Table)Tables.PAUSED).where(Tables.PAUSED.SCOPE.eq((Object)PauseScope.APPLICATION)).and(Tables.PAUSED.NAME.eq((Object)this.this$0.$application)).execute();
                        txn.deleteFrom((Table)Tables.RESOURCE).where(Tables.RESOURCE.UID.in(this.this$0.$resourceUids)).execute();
                        txn.deleteFrom((Table)Tables.DELIVERY_ARTIFACT).where(Tables.DELIVERY_ARTIFACT.UID.in(this.this$0.$artifactUids)).execute();
                        txn.deleteFrom((Table)Tables.DELIVERY_CONFIG).where(Tables.DELIVERY_CONFIG.UID.eq((Object)this.this$0.$configUid)).execute();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$resourceIds = select;
                this.$application = string;
                this.$resourceUids = select2;
                this.$artifactUids = select3;
                this.$configUid = string2;
                super(0);
            }
        });
    }

    private final String getUIDByApplication(String application2) {
        String string = (String)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<String>(this, application2){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $application;

            public final String invoke() {
                return (String)this.this$0.getJooq$keel_sql().select((SelectField)Tables.DELIVERY_CONFIG.UID).from((TableLike)Tables.DELIVERY_CONFIG).where(Tables.DELIVERY_CONFIG.APPLICATION.eq((Object)this.$application)).fetchOne((Field)Tables.DELIVERY_CONFIG.UID);
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$application = string;
                super(0);
            }
        });
        if (string == null) {
            throw (Throwable)new NoDeliveryConfigForApplication(application2);
        }
        return string;
    }

    private final Select<Record1<String>> getResourceUIDs(String application2) {
        SelectConditionStep selectConditionStep = this.getJooq$keel_sql().select((SelectField)Tables.RESOURCE.UID).from((TableLike)Tables.RESOURCE).where(Tables.RESOURCE.APPLICATION.eq((Object)application2));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"jooq\n      .select(RESOU\u2026LICATION.eq(application))");
        return (Select)selectConditionStep;
    }

    private final Select<Record1<String>> getResourceIDs(String application2) {
        SelectConditionStep selectConditionStep = this.getJooq$keel_sql().selectDistinct((SelectField)Tables.RESOURCE.ID).from((TableLike)Tables.RESOURCE).where(Tables.RESOURCE.APPLICATION.eq((Object)application2));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"jooq\n      .selectDistin\u2026LICATION.eq(application))");
        return (Select)selectConditionStep;
    }

    private final Select<Record1<String>> getArtifactUIDs(String deliveryConfigUid) {
        SelectConditionStep selectConditionStep = this.getJooq$keel_sql().select((SelectField)Tables.DELIVERY_CONFIG_ARTIFACT.ARTIFACT_UID).from((TableLike)Tables.DELIVERY_CONFIG_ARTIFACT).where(Tables.DELIVERY_CONFIG_ARTIFACT.DELIVERY_CONFIG_UID.eq((Object)deliveryConfigUid));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"jooq\n      .select(DELIV\u2026ID.eq(deliveryConfigUid))");
        return (Select)selectConditionStep;
    }

    public void store(@NotNull DeliveryConfig deliveryConfig) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        boolean bl = false;
        boolean bl2 = false;
        DeliveryConfig $this$with = deliveryConfig;
        boolean bl3 = false;
        String string = this.deliveryConfigUidByName($this$with.getName());
        if (string == null) {
            String string2 = UIDKt.randomUID().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUID().toString()");
        }
        String deliveryConfigUid = string;
        this.getJooq$keel_sql().insertInto((Table)Tables.DELIVERY_CONFIG).set((Field)Tables.DELIVERY_CONFIG.UID, (Object)deliveryConfigUid).set((Field)Tables.DELIVERY_CONFIG.NAME, (Object)$this$with.getName()).set((Field)Tables.DELIVERY_CONFIG.APPLICATION, (Object)$this$with.getApplication()).set((Field)Tables.DELIVERY_CONFIG.SERVICE_ACCOUNT, (Object)$this$with.getServiceAccount()).set((Field)Tables.DELIVERY_CONFIG.METADATA, (Object)$this$with.getMetadata()).onDuplicateKeyUpdate().set((Field)Tables.DELIVERY_CONFIG.SERVICE_ACCOUNT, (Object)$this$with.getServiceAccount()).set((Field)Tables.DELIVERY_CONFIG.METADATA, (Object)$this$with.getMetadata()).execute();
        Iterable $this$forEach$iv = $this$with.getArtifacts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeliveryArtifact artifact = (DeliveryArtifact)element$iv;
            boolean bl4 = false;
            this.getJooq$keel_sql().insertInto((Table)Tables.DELIVERY_CONFIG_ARTIFACT).set((Field)Tables.DELIVERY_CONFIG_ARTIFACT.DELIVERY_CONFIG_UID, (Object)deliveryConfigUid).set((Field)Tables.DELIVERY_CONFIG_ARTIFACT.ARTIFACT_UID, (Select)this.getJooq$keel_sql().select((SelectField)Tables.DELIVERY_ARTIFACT.UID).from((TableLike)Tables.DELIVERY_ARTIFACT).where(Tables.DELIVERY_ARTIFACT.NAME.eq((Object)artifact.getName())).and(Tables.DELIVERY_ARTIFACT.TYPE.eq((Object)artifact.getType())).and(Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME.eq((Object)artifact.getDeliveryConfigName())).and(Tables.DELIVERY_ARTIFACT.REFERENCE.eq((Object)artifact.getReference()))).onDuplicateKeyIgnore().execute();
        }
        $this$forEach$iv = $this$with.getEnvironments();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Environment environment = (Environment)element$iv;
            boolean bl5 = false;
            this.storeEnvironment($this$with, environment);
        }
        $this$forEach$iv = $this$with.getPreviewEnvironments();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string3;
            PreviewEnvironmentSpec previewEnvSpec = (PreviewEnvironmentSpec)element$iv;
            boolean bl6 = false;
            if (this.environmentUidByName($this$with.getName(), previewEnvSpec.getBaseEnvironment()) == null) continue;
            boolean bl7 = false;
            boolean bl8 = false;
            String baseEnvironmentUid = string3;
            boolean bl9 = false;
            this.getJooq$keel_sql().insertInto((Table)Tables.PREVIEW_ENVIRONMENT).set((Field)Tables.PREVIEW_ENVIRONMENT.DELIVERY_CONFIG_UID, (Object)deliveryConfigUid).set((Field)Tables.PREVIEW_ENVIRONMENT.BASE_ENVIRONMENT_UID, (Object)baseEnvironmentUid).set((Field)Tables.PREVIEW_ENVIRONMENT.BRANCH_FILTER, (Object)this.toJson(previewEnvSpec.getBranch())).set((Field)Tables.PREVIEW_ENVIRONMENT.VERIFICATIONS, (Object)this.toJson(previewEnvSpec.getVerifyWith())).set((Field)Tables.PREVIEW_ENVIRONMENT.NOTIFICATIONS, (Object)this.toJson(previewEnvSpec.getNotifications())).onDuplicateKeyUpdate().set((Field)Tables.PREVIEW_ENVIRONMENT.BRANCH_FILTER, (Object)this.toJson(previewEnvSpec.getBranch())).set((Field)Tables.PREVIEW_ENVIRONMENT.VERIFICATIONS, (Object)this.toJson(previewEnvSpec.getVerifyWith())).set((Field)Tables.PREVIEW_ENVIRONMENT.NOTIFICATIONS, (Object)this.toJson(previewEnvSpec.getNotifications())).execute();
        }
        this.getJooq$keel_sql().insertInto((Table)Tables.DELIVERY_CONFIG_LAST_CHECKED).set((Field)Tables.DELIVERY_CONFIG_LAST_CHECKED.DELIVERY_CONFIG_UID, (Object)deliveryConfigUid).set((Field)Tables.DELIVERY_CONFIG_LAST_CHECKED.AT, (Object)Instant.EPOCH.plusSeconds(1L)).onDuplicateKeyUpdate().set((Field)Tables.DELIVERY_CONFIG_LAST_CHECKED.AT, (Object)Instant.EPOCH.plusSeconds(1L)).execute();
    }

    /*
     * WARNING - void declaration
     */
    private final void storeEnvironment(DeliveryConfig deliveryConfig, Environment environment) {
        boolean newVersionRequired;
        boolean bl;
        void $this$fetchOneInto$iv;
        String string = (String)this.getJooq$keel_sql().select((SelectField)Tables.ENVIRONMENT.UID).from((TableLike)Tables.ENVIRONMENT).where(Tables.ENVIRONMENT.DELIVERY_CONFIG_UID.eq(DeliveryconfigsKt.getUid(deliveryConfig))).and(Tables.ENVIRONMENT.NAME.eq((Object)environment.getName())).fetchOne((Field)Tables.ENVIRONMENT.UID);
        if (string == null) {
            String string2 = UIDKt.randomUID().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUID().toString()");
        }
        String environmentUid = string;
        this.getJooq$keel_sql().insertInto((Table)Tables.ENVIRONMENT).set((Field)Tables.ENVIRONMENT.UID, (Object)environmentUid).set((Field)Tables.ENVIRONMENT.DELIVERY_CONFIG_UID, DeliveryconfigsKt.getUid(deliveryConfig)).set((Field)Tables.ENVIRONMENT.NAME, (Object)environment.getName()).set((Field)Tables.ENVIRONMENT.IS_PREVIEW, (Object)environment.isPreview()).set((Field)Tables.ENVIRONMENT.CONSTRAINTS, (Object)this.toJson(environment.getConstraints())).set((Field)Tables.ENVIRONMENT.NOTIFICATIONS, (Object)this.toJson(environment.getNotifications())).set((Field)Tables.ENVIRONMENT.VERIFICATIONS, (Object)this.toJson(environment.getVerifyWith())).set((Field)Tables.ENVIRONMENT.POST_DEPLOY_ACTIONS, (Object)this.toJson(environment.getPostDeploy())).onDuplicateKeyUpdate().set((Field)Tables.ENVIRONMENT.CONSTRAINTS, (Object)this.toJson(environment.getConstraints())).set((Field)Tables.ENVIRONMENT.NOTIFICATIONS, (Object)this.toJson(environment.getNotifications())).set((Field)Tables.ENVIRONMENT.VERIFICATIONS, (Object)this.toJson(environment.getVerifyWith())).set((Field)Tables.ENVIRONMENT.POST_DEPLOY_ACTIONS, (Object)this.toJson(environment.getPostDeploy())).execute();
        SelectConditionStep selectConditionStep = this.getJooq$keel_sql().select((SelectField)DSL.coalesce((Field)((Field)DSL.max((Field)((Field)Tables.ENVIRONMENT_VERSION.VERSION))), (Field[])new Field[]{(Field)DSL.value((int)0)})).from((TableLike)Tables.ENVIRONMENT_VERSION).where(Tables.ENVIRONMENT_VERSION.ENVIRONMENT_UID.eq((Object)environmentUid));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"jooq\n      .select(coale\u2026T_UID.eq(environmentUid))");
        ResultQuery resultQuery = (ResultQuery)selectConditionStep;
        boolean $i$f$fetchOneInto = false;
        Integer currentVersion = (Integer)$this$fetchOneInto$iv.fetchOneInto(Integer.class);
        int newVersion = currentVersion + 1;
        Integer n = currentVersion;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"currentVersion");
        Map<String, Integer> currentVersionResources = this.resourceUidsAndVersionsFor(environmentUid, n);
        Map<String, Integer> newVersionResources = this.latestResourceUidsAndVersions(environment);
        if (currentVersion == 0) {
            this.getLog().debug("Creating initial version of environment {}/{}", (Object)deliveryConfig.getApplication(), (Object)environment.getName());
            bl = true;
        } else if (Intrinsics.areEqual(currentVersionResources, newVersionResources) ^ true) {
            this.getLog().debug("Creating a new version {} of environment {}/{} because resources changed from {} to {}", new Object[]{newVersion, deliveryConfig.getApplication(), environment.getName(), currentVersionResources, newVersionResources});
            bl = true;
        } else {
            bl = newVersionRequired = false;
        }
        if (newVersionRequired) {
            this.getJooq$keel_sql().insertInto((Table)Tables.ENVIRONMENT_VERSION).set((Field)Tables.ENVIRONMENT_VERSION.ENVIRONMENT_UID, (Object)environmentUid).set((Field)Tables.ENVIRONMENT_VERSION.VERSION, (Object)newVersion).set((Field)Tables.ENVIRONMENT_VERSION.CREATED_AT, (Object)this.getClock$keel_sql().instant()).execute();
            this.getJooq$keel_sql().insertInto((Table)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION).columns((Field)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ENVIRONMENT_UID, (Field)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ENVIRONMENT_VERSION, (Field)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ARTIFACT_UID, (Field)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ARTIFACT_VERSION).select((Select)DSL.select((SelectField)((SelectField)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ENVIRONMENT_UID), (SelectField)((SelectField)DSL.value((int)newVersion)), (SelectField)((SelectField)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ARTIFACT_UID), (SelectField)((SelectField)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ARTIFACT_VERSION)).from((TableLike)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION).where(Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ENVIRONMENT_UID.eq((Object)environmentUid)).and(Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ENVIRONMENT_VERSION.eq((Object)currentVersion))).execute();
        }
        Map<String, Integer> $this$forEach$iv = newVersionResources;
        boolean $i$f$forEach = false;
        Map<String, Integer> map = $this$forEach$iv;
        boolean bl2 = false;
        Iterator<Map.Entry<String, Integer>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void resourceUid;
            Map.Entry<String, Integer> element$iv;
            Map.Entry<String, Integer> $dstr$resourceUid$resourceVersion = element$iv = iterator.next();
            boolean bl3 = false;
            Map.Entry<String, Integer> entry = $dstr$resourceUid$resourceVersion;
            boolean bl4 = false;
            String string3 = entry.getKey();
            entry = $dstr$resourceUid$resourceVersion;
            bl4 = false;
            Integer resourceVersion = entry.getValue();
            this.getJooq$keel_sql().insertInto((Table)Tables.ENVIRONMENT_RESOURCE).set((Field)Tables.ENVIRONMENT_RESOURCE.ENVIRONMENT_UID, (Object)environmentUid).set((Field)Tables.ENVIRONMENT_RESOURCE.ENVIRONMENT_VERSION, (Object)newVersion).set((Field)Tables.ENVIRONMENT_RESOURCE.RESOURCE_UID, (Object)resourceUid).set((Field)Tables.ENVIRONMENT_RESOURCE.RESOURCE_VERSION, (Object)resourceVersion).onDuplicateKeyIgnore().execute();
        }
    }

    public void storeEnvironment(@NotNull String deliveryConfigName, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        DeliveryConfig deliveryConfig = DeliveryconfigsKt.deliveryConfigByName(this, deliveryConfigName, DependentAttachFilter.ATTACH_NONE);
        this.storeEnvironment(deliveryConfig, environment);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Integer> latestResourceUidsAndVersions(Environment $this$latestResourceUidsAndVersions) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $this$latestResourceUidsAndVersions.getResources();
        TableField<ResourceRecord, String> tableField = Tables.RESOURCE.ID;
        SelectOnConditionStep selectOnConditionStep = this.getJooq$keel_sql().select((SelectField)Tables.RESOURCE.UID, (SelectField)DSL.max((Field)((Field)Tables.RESOURCE_VERSION.VERSION))).from((TableLike)Tables.RESOURCE).join((TableLike)Tables.RESOURCE_VERSION).on(Tables.RESOURCE.UID.eq((Field)Tables.RESOURCE_VERSION.RESOURCE_UID));
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            String string = ((Resource)receiver).getId();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        List list = selectOnConditionStep.where(tableField.in((Collection)collection)).groupBy(new GroupField[]{(GroupField)Tables.RESOURCE.UID}).fetch((RecordMapper)latestResourceUidsAndVersions.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq.select(RESOURCE.UID\u2026sion) -> uid to version }");
        return MapsKt.toMap((Iterable)list);
    }

    private final Map<String, Integer> resourceUidsAndVersionsFor(String environmentUid, int version) {
        Map map;
        switch (version) {
            case 0: {
                map = MapsKt.emptyMap();
                break;
            }
            default: {
                List list = this.getJooq$keel_sql().select((SelectField)Tables.RESOURCE.UID, (SelectField)Tables.RESOURCE_VERSION.VERSION).from((TableLike)Tables.RESOURCE).join((TableLike)Tables.RESOURCE_VERSION).on(Tables.RESOURCE.UID.eq((Field)Tables.RESOURCE_VERSION.RESOURCE_UID)).whereExists((Select)DSL.selectOne().from((TableLike)Tables.ENVIRONMENT_RESOURCE).where(Tables.ENVIRONMENT_RESOURCE.RESOURCE_UID.eq((Field)Tables.RESOURCE.UID)).and(Tables.ENVIRONMENT_RESOURCE.RESOURCE_VERSION.eq((Field)Tables.RESOURCE_VERSION.VERSION)).and(Tables.ENVIRONMENT_RESOURCE.ENVIRONMENT_UID.eq((Object)environmentUid)).and(Tables.ENVIRONMENT_RESOURCE.ENVIRONMENT_VERSION.eq((Object)version))).fetch((RecordMapper)resourceUidsAndVersionsFor.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq\n        .select(RES\u2026sion) -> uid to version }");
                map = MapsKt.toMap((Iterable)list);
            }
        }
        return map;
    }

    @NotNull
    public DeliveryConfig get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return DeliveryconfigsKt.deliveryConfigByName$default(this, name, null, 2, null);
    }

    @NotNull
    public Set<DeliveryConfig> all(DependentAttachFilter ... dependentAttachFilter) {
        Intrinsics.checkNotNullParameter((Object)dependentAttachFilter, (String)"dependentAttachFilter");
        return (Set)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<Set<? extends DeliveryConfig>>(this, dependentAttachFilter){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ DependentAttachFilter[] $dependentAttachFilter;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<DeliveryConfig> invoke() {
                void $this$mapTo$iv$iv;
                List list = this.this$0.getJooq$keel_sql().select((SelectField)Tables.DELIVERY_CONFIG.UID, (SelectField)Tables.DELIVERY_CONFIG.NAME, (SelectField)Tables.DELIVERY_CONFIG.APPLICATION, (SelectField)Tables.DELIVERY_CONFIG.SERVICE_ACCOUNT, (SelectField)Tables.DELIVERY_CONFIG.METADATA).from((TableLike)Tables.DELIVERY_CONFIG).fetch((RecordMapper)all.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq.select(\n        DEL\u2026())\n          )\n        }");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void deliveryConfig;
                    DeliveryConfig deliveryConfig2 = (DeliveryConfig)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = deliveryConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"deliveryConfig");
                    DeliveryConfig deliveryConfig3 = DeliveryconfigsKt.attachDependents(this.this$0, (DeliveryConfig)v1, Arrays.copyOf(this.$dependentAttachFilter, this.$dependentAttachFilter.length));
                    collection.add(deliveryConfig3);
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$dependentAttachFilter = dependentAttachFilterArray;
                super(0);
            }
        });
    }

    @NotNull
    public Environment environmentFor(@NotNull String resourceId) {
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        Environment environment = (Environment)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<Environment>(this, resourceId){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $resourceId;

            public final Environment invoke() {
                return (Environment)this.this$0.getJooq$keel_sql().select((SelectField)Tables.LATEST_ENVIRONMENT.UID, (SelectField)Tables.LATEST_ENVIRONMENT.NAME, (SelectField)Tables.LATEST_ENVIRONMENT.VERSION, (SelectField)Tables.LATEST_ENVIRONMENT.IS_PREVIEW, (SelectField)Tables.LATEST_ENVIRONMENT.CONSTRAINTS, (SelectField)Tables.LATEST_ENVIRONMENT.NOTIFICATIONS, (SelectField)Tables.LATEST_ENVIRONMENT.VERIFICATIONS, (SelectField)Tables.LATEST_ENVIRONMENT.POST_DEPLOY_ACTIONS).from(new TableLike[]{(TableLike)Tables.LATEST_ENVIRONMENT, (TableLike)Tables.ENVIRONMENT_RESOURCE, (TableLike)Tables.RESOURCE}).where(Tables.RESOURCE.ID.eq((Object)this.$resourceId)).and(Tables.ENVIRONMENT_RESOURCE.RESOURCE_UID.eq((Field)Tables.RESOURCE.UID)).and(Tables.ENVIRONMENT_RESOURCE.ENVIRONMENT_UID.eq((Field)Tables.LATEST_ENVIRONMENT.UID)).and(Tables.ENVIRONMENT_RESOURCE.ENVIRONMENT_VERSION.eq((Field)Tables.LATEST_ENVIRONMENT.VERSION)).fetchOne((RecordMapper)new RecordMapper<Record8<String, String, Integer, Boolean, String, String, String, String>, Environment>(this){
                    final /* synthetic */ environmentFor.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final Environment map(Record8<String, String, Integer, Boolean, String, String, String, String> $dstr$uid$name$_u24__u24$isPreview$constraintsJson$notificationsJson$verifyWithJson$postDeployActionsJson) {
                        boolean bl;
                        Object object;
                        List list;
                        Set set;
                        Set set2;
                        Object object2;
                        Object object3;
                        Set<Resource<ResourceSpec>> set3;
                        boolean bl2;
                        void v1;
                        block11: {
                            block10: {
                                List list2;
                                Set set4;
                                TypeReference typeReference;
                                boolean $i$f$jacksonTypeRef;
                                ObjectMapper objectMapper;
                                ObjectMapper objectMapper2;
                                ObjectMapper it;
                                void var22_35;
                                boolean bl3;
                                Set<Resource<ResourceSpec>> set5;
                                Set set6;
                                boolean bl4;
                                String postDeployActionsJson;
                                block9: {
                                    block8: {
                                        void verifyWithJson;
                                        block7: {
                                            block6: {
                                                void notificationsJson;
                                                void $this$readValue$iv;
                                                void constraintsJson;
                                                void uid2;
                                                void isPreview;
                                                void name;
                                                String string = (String)$dstr$uid$name$_u24__u24$isPreview$constraintsJson$notificationsJson$verifyWithJson$postDeployActionsJson.component1();
                                                String string2 = (String)$dstr$uid$name$_u24__u24$isPreview$constraintsJson$notificationsJson$verifyWithJson$postDeployActionsJson.component2();
                                                Boolean bl5 = (Boolean)$dstr$uid$name$_u24__u24$isPreview$constraintsJson$notificationsJson$verifyWithJson$postDeployActionsJson.component4();
                                                String string3 = (String)$dstr$uid$name$_u24__u24$isPreview$constraintsJson$notificationsJson$verifyWithJson$postDeployActionsJson.component5();
                                                String string4 = (String)$dstr$uid$name$_u24__u24$isPreview$constraintsJson$notificationsJson$verifyWithJson$postDeployActionsJson.component6();
                                                String string5 = (String)$dstr$uid$name$_u24__u24$isPreview$constraintsJson$notificationsJson$verifyWithJson$postDeployActionsJson.component7();
                                                postDeployActionsJson = (String)$dstr$uid$name$_u24__u24$isPreview$constraintsJson$notificationsJson$verifyWithJson$postDeployActionsJson.component8();
                                                void v0 = name;
                                                v1 = v0;
                                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"name");
                                                void v2 = isPreview;
                                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"isPreview");
                                                bl2 = v2.booleanValue();
                                                SqlDeliveryConfigRepository sqlDeliveryConfigRepository = this.this$0.this$0;
                                                void v5 = uid2;
                                                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"uid");
                                                set3 = DeliveryconfigsKt.resourcesForEnvironment(sqlDeliveryConfigRepository, (String)v5);
                                                object3 = this.this$0.this$0.getObjectMapper$keel_sql();
                                                void v7 = constraintsJson;
                                                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"constraintsJson");
                                                void content$iv = v7;
                                                boolean $i$f$readValue = false;
                                                object2 = content$iv;
                                                void var13_18 = $this$readValue$iv;
                                                boolean $i$f$jacksonTypeRef2 = false;
                                                TypeReference typeReference2 = (TypeReference)new TypeReference<Set<? extends Constraint>>(){};
                                                set2 = (Set)var13_18.readValue((String)object2, typeReference2);
                                                set = notificationsJson;
                                                if (set == null) break block6;
                                                object3 = set;
                                                boolean bl6 = false;
                                                bl4 = false;
                                                object2 = object3;
                                                set6 = set2;
                                                set5 = set3;
                                                bl3 = bl2;
                                                var22_35 = v1;
                                                boolean bl7 = false;
                                                ObjectMapper $this$readValue$iv2 = this.this$0.this$0.getObjectMapper$keel_sql();
                                                boolean $i$f$readValue2 = false;
                                                objectMapper2 = it;
                                                objectMapper = $this$readValue$iv2;
                                                $i$f$jacksonTypeRef = false;
                                                typeReference = (TypeReference)new TypeReference<Set<? extends NotificationConfig>>(){};
                                                set4 = (Set)objectMapper.readValue((String)objectMapper2, typeReference);
                                                v1 = var22_35;
                                                bl2 = bl3;
                                                set3 = set5;
                                                set2 = set6;
                                                set = set4;
                                                if (set != null) break block7;
                                            }
                                            set = SetsKt.emptySet();
                                        }
                                        if ((list = verifyWithJson) == null) break block8;
                                        object3 = list;
                                        boolean bl8 = false;
                                        bl4 = false;
                                        it = object3;
                                        set4 = set;
                                        set6 = set2;
                                        set5 = set3;
                                        bl3 = bl2;
                                        var22_35 = v1;
                                        boolean bl9 = false;
                                        ObjectMapper $this$readValue$iv = this.this$0.this$0.getObjectMapper$keel_sql();
                                        boolean $i$f$readValue = false;
                                        objectMapper2 = it;
                                        objectMapper = $this$readValue$iv;
                                        $i$f$jacksonTypeRef = false;
                                        typeReference = (TypeReference)new TypeReference<List<? extends Verification>>(){};
                                        list2 = (List)objectMapper.readValue((String)objectMapper2, typeReference);
                                        v1 = var22_35;
                                        bl2 = bl3;
                                        set3 = set5;
                                        set2 = set6;
                                        set = set4;
                                        list = list2;
                                        if (list != null) break block9;
                                    }
                                    list = CollectionsKt.emptyList();
                                }
                                if ((object = postDeployActionsJson) == null) break block10;
                                object3 = object;
                                boolean bl10 = false;
                                bl4 = false;
                                it = object3;
                                list2 = list;
                                set4 = set;
                                set6 = set2;
                                set5 = set3;
                                bl3 = bl2;
                                var22_35 = v1;
                                boolean bl11 = false;
                                ObjectMapper $this$readValue$iv = this.this$0.this$0.getObjectMapper$keel_sql();
                                boolean $i$f$readValue = false;
                                objectMapper2 = it;
                                objectMapper = $this$readValue$iv;
                                $i$f$jacksonTypeRef = false;
                                typeReference = (TypeReference)new TypeReference<List<? extends PostDeployAction>>(){};
                                List list3 = (List)objectMapper.readValue((String)objectMapper2, typeReference);
                                v1 = var22_35;
                                bl2 = bl3;
                                set3 = set5;
                                set2 = set6;
                                set = set4;
                                list = list2;
                                object = list3;
                                if (object != null) break block11;
                            }
                            object = CollectionsKt.emptyList();
                        }
                        object3 = object;
                        List list4 = list;
                        Set set7 = set;
                        object2 = set2;
                        Set<Resource<ResourceSpec>> set8 = set3;
                        boolean bl12 = bl = bl2;
                        Object object4 = object3;
                        Set set9 = set7;
                        List list5 = list4;
                        Object object5 = object2;
                        Set<Resource<ResourceSpec>> set10 = set8;
                        void var35_49 = v1;
                        return new Environment((String)var35_49, set10, (Set)object5, list5, set9, (List)object4, bl12);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$resourceId = string;
                super(0);
            }
        });
        if (environment == null) {
            throw (Throwable)new OrphanedResourceException(resourceId);
        }
        return environment;
    }

    @NotNull
    public Set<NotificationConfig> environmentNotifications(@NotNull String deliveryConfigName, @NotNull String environmentName) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        return (Set)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<Set<? extends NotificationConfig>>(this, deliveryConfigName, environmentName){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $deliveryConfigName;
            final /* synthetic */ String $environmentName;

            @NotNull
            public final Set<NotificationConfig> invoke() {
                String string = (String)this.this$0.getJooq$keel_sql().select((SelectField)Tables.DELIVERY_CONFIG.UID).from((TableLike)Tables.DELIVERY_CONFIG).where(Tables.DELIVERY_CONFIG.NAME.eq((Object)this.$deliveryConfigName)).fetchOne((Field)Tables.DELIVERY_CONFIG.UID);
                if (string == null) {
                    String string2 = UIDKt.randomUID().toString();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUID().toString()");
                }
                String uid2 = string;
                Set set = (Set)this.this$0.getJooq$keel_sql().select((SelectField)Tables.ENVIRONMENT.NOTIFICATIONS).from((TableLike)Tables.ENVIRONMENT).where(Tables.ENVIRONMENT.NAME.eq((Object)this.$environmentName)).and(Tables.ENVIRONMENT.DELIVERY_CONFIG_UID.eq((Object)uid2)).fetchOne((RecordMapper)new RecordMapper<Record1<String>, Set<? extends NotificationConfig>>(this){
                    final /* synthetic */ environmentNotifications.1 this$0;

                    @Nullable
                    public final Set<NotificationConfig> map(Record1<String> $dstr$notificationsJson) {
                        Set set;
                        String notificationsJson;
                        String string = notificationsJson = (String)$dstr$notificationsJson.component1();
                        if (string != null) {
                            String string2 = string;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            ObjectMapper $this$readValue$iv = this.this$0.this$0.getObjectMapper$keel_sql();
                            boolean $i$f$readValue = false;
                            String string3 = it;
                            ObjectMapper objectMapper = $this$readValue$iv;
                            boolean $i$f$jacksonTypeRef = false;
                            TypeReference typeReference = (TypeReference)new TypeReference<Set<? extends NotificationConfig>>(){};
                            set = (Set)objectMapper.readValue(string3, typeReference);
                        } else {
                            set = null;
                        }
                        return set;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                return set;
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$deliveryConfigName = string;
                this.$environmentName = string2;
                super(0);
            }
        });
    }

    @NotNull
    public DeliveryConfig deliveryConfigFor(@NotNull String resourceId) {
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        DeliveryConfig deliveryConfig = (DeliveryConfig)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<DeliveryConfig>(this, resourceId){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $resourceId;

            public final DeliveryConfig invoke() {
                return (DeliveryConfig)this.this$0.getJooq$keel_sql().select((SelectField)Tables.DELIVERY_CONFIG.NAME).from(new TableLike[]{(TableLike)Tables.LATEST_ENVIRONMENT, (TableLike)Tables.ENVIRONMENT_RESOURCE, (TableLike)Tables.RESOURCE, (TableLike)Tables.DELIVERY_CONFIG}).where(Tables.RESOURCE.ID.eq((Object)this.$resourceId)).and(Tables.ENVIRONMENT_RESOURCE.RESOURCE_UID.eq((Field)Tables.RESOURCE.UID)).and(Tables.ENVIRONMENT_RESOURCE.ENVIRONMENT_UID.eq((Field)Tables.LATEST_ENVIRONMENT.UID)).and(Tables.ENVIRONMENT_RESOURCE.ENVIRONMENT_VERSION.eq((Field)Tables.LATEST_ENVIRONMENT.VERSION)).and(Tables.LATEST_ENVIRONMENT.DELIVERY_CONFIG_UID.eq((Field)Tables.DELIVERY_CONFIG.UID)).fetchOne((RecordMapper)new RecordMapper<Record1<String>, DeliveryConfig>(this){
                    final /* synthetic */ deliveryConfigFor.1 this$0;

                    public final DeliveryConfig map(Record1<String> $dstr$name) {
                        String name = (String)$dstr$name.component1();
                        SqlDeliveryConfigRepository sqlDeliveryConfigRepository = this.this$0.this$0;
                        String string = name;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                        return sqlDeliveryConfigRepository.get(string);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$resourceId = string;
                super(0);
            }
        });
        if (deliveryConfig == null) {
            throw (Throwable)new OrphanedResourceException(resourceId);
        }
        return deliveryConfig;
    }

    /*
     * WARNING - void declaration
     */
    public void storeConstraintState(@NotNull ConstraintState state) {
        block4: {
            Object v3;
            Object object;
            String application2;
            String uid2;
            String envUid;
            block3: {
                void $this$firstOrNull$iv;
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                String string = this.environmentUidByName(state.getDeliveryConfigName(), state.getEnvironmentName());
                if (string == null) break block4;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                envUid = string2;
                boolean bl3 = false;
                String string3 = (String)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<String>(envUid, this, state){
                    final /* synthetic */ String $envUid;
                    final /* synthetic */ SqlDeliveryConfigRepository this$0;
                    final /* synthetic */ ConstraintState $state$inlined;
                    {
                        this.$envUid = string;
                        this.this$0 = sqlDeliveryConfigRepository;
                        this.$state$inlined = constraintState;
                        super(0);
                    }

                    public final String invoke() {
                        return (String)this.this$0.getJooq$keel_sql().select((SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.UID).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT).where(new Condition[]{Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ENVIRONMENT_UID.eq((Object)this.$envUid), Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.TYPE.eq((Object)this.$state$inlined.getType()), Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_VERSION.eq((Object)this.$state$inlined.getArtifactVersion()), Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_REFERENCE.eq((Object)this.$state$inlined.getArtifactReference())}).fetchOne((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.UID);
                    }
                });
                if (string3 == null) {
                    String string4 = UIDKt.randomUID().toString();
                    string3 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"randomUID().toString()");
                }
                uid2 = string3;
                application2 = this.applicationByDeliveryConfigName(state.getDeliveryConfigName());
                object = this.get(state.getDeliveryConfigName()).getEnvironments();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Environment it = (Environment)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)state.getEnvironmentName())) continue;
                    v3 = element$iv;
                    break block3;
                }
                v3 = null;
            }
            Environment environment = v3;
            if (environment == null) {
                object = "Environment " + state.getEnvironmentName() + " does not exist in " + state.getDeliveryConfigName();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            Environment environment2 = environment;
            this.getSqlRetry$keel_sql().withRetry(RetryCategory.WRITE, (Function0)new Function0<Unit>(uid2, envUid, application2, environment2, this, state){
                final /* synthetic */ String $uid;
                final /* synthetic */ String $envUid;
                final /* synthetic */ String $application;
                final /* synthetic */ Environment $environment;
                final /* synthetic */ SqlDeliveryConfigRepository this$0;
                final /* synthetic */ ConstraintState $state$inlined;
                {
                    this.$uid = string;
                    this.$envUid = string2;
                    this.$application = string3;
                    this.$environment = environment;
                    this.this$0 = sqlDeliveryConfigRepository;
                    this.$state$inlined = constraintState;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getJooq$keel_sql().transaction(new TransactionalRunnable(this){
                        final /* synthetic */ storeConstraintState$$inlined$also$lambda$2 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run(Configuration config) {
                            DSLContext txn = DSL.using((Configuration)config);
                            txn.insertInto((Table)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.UID, (Object)this.this$0.$uid).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ENVIRONMENT_UID, (Object)this.this$0.$envUid).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_VERSION, (Object)this.this$0.$state$inlined.getArtifactVersion()).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_REFERENCE, (Object)this.this$0.$state$inlined.getArtifactReference()).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.TYPE, (Object)this.this$0.$state$inlined.getType()).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.CREATED_AT, (Object)this.this$0.$state$inlined.getCreatedAt()).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.STATUS, (Object)this.this$0.$state$inlined.getStatus()).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_BY, (Object)this.this$0.$state$inlined.getJudgedBy()).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_AT, (Object)this.this$0.$state$inlined.getJudgedAt()).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.COMMENT, (Object)this.this$0.$state$inlined.getComment()).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ATTRIBUTES, (Object)this.this$0.this$0.getObjectMapper$keel_sql().writeValueAsString((Object)this.this$0.$state$inlined.getAttributes())).onDuplicateKeyUpdate().set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.STATUS, MySQLDSL.values((Field)((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.STATUS))).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_BY, MySQLDSL.values((Field)((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_BY))).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_AT, MySQLDSL.values((Field)((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_AT))).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.COMMENT, MySQLDSL.values((Field)((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.COMMENT))).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ATTRIBUTES, MySQLDSL.values((Field)((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ATTRIBUTES))).set((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_REFERENCE, (Object)this.this$0.$state$inlined.getArtifactReference()).execute();
                            txn.insertInto((Table)Tables.CURRENT_CONSTRAINT).set((Field)Tables.CURRENT_CONSTRAINT.APPLICATION, (Object)this.this$0.$application).set((Field)Tables.CURRENT_CONSTRAINT.ENVIRONMENT_UID, (Object)this.this$0.$envUid).set((Field)Tables.CURRENT_CONSTRAINT.TYPE, (Object)this.this$0.$state$inlined.getType()).set((Field)Tables.CURRENT_CONSTRAINT.CONSTRAINT_UID, (Object)this.this$0.$uid).onDuplicateKeyUpdate().set((Field)Tables.CURRENT_CONSTRAINT.CONSTRAINT_UID, MySQLDSL.values((Field)((Field)Tables.CURRENT_CONSTRAINT.CONSTRAINT_UID))).execute();
                            SqlDeliveryConfigRepository sqlDeliveryConfigRepository = this.this$0.this$0;
                            String string = this.this$0.$state$inlined.getDeliveryConfigName();
                            String string2 = this.this$0.$state$inlined.getEnvironmentName();
                            String string3 = this.this$0.$state$inlined.getArtifactVersion();
                            String string4 = this.this$0.$state$inlined.getArtifactReference();
                            DSLContext dSLContext = txn;
                            Intrinsics.checkNotNullExpressionValue((Object)dSLContext, (String)"txn");
                            List allStates = SqlDeliveryConfigRepository.access$constraintStateForWithTransaction(sqlDeliveryConfigRepository, string, string2, string3, string4, dSLContext);
                            if (DslKt.getAllPass((List)allStates) && allStates.size() >= EnvironmentKt.getStatefulCount((Set)this.this$0.$environment.getConstraints())) {
                                txn.insertInto((Table)Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL).set((Field)Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL.ENVIRONMENT_UID, (Object)this.this$0.$envUid).set((Field)Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL.ARTIFACT_VERSION, (Object)this.this$0.$state$inlined.getArtifactVersion()).set((Field)Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL.QUEUED_AT, (Object)this.this$0.this$0.getClock$keel_sql().instant()).set((Field)Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL.ARTIFACT_REFERENCE, (Object)this.this$0.$state$inlined.getArtifactReference()).onDuplicateKeyIgnore().execute();
                            }
                        }
                    });
                    this.$state$inlined.setUid(UIDKt.parseUID((String)this.$uid));
                }
            });
        }
    }

    @Nullable
    public ConstraintState getConstraintState(@NotNull String deliveryConfigName, @NotNull String environmentName, @NotNull String artifactVersion, @NotNull String type, @Nullable String artifactReference) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)artifactVersion, (String)"artifactVersion");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String string = this.environmentUidByName(deliveryConfigName, environmentName);
        if (string == null) {
            return null;
        }
        String environmentUID = string;
        return (ConstraintState)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<ConstraintState>(this, deliveryConfigName, environmentName, environmentUID, artifactVersion, type, artifactReference){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $deliveryConfigName;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ String $environmentUID;
            final /* synthetic */ String $artifactVersion;
            final /* synthetic */ String $type;
            final /* synthetic */ String $artifactReference;

            public final ConstraintState invoke() {
                return (ConstraintState)this.this$0.getJooq$keel_sql().select((SelectField)DSL.inline((String)this.$deliveryConfigName).as("deliveryConfigName"), (SelectField)DSL.inline((String)this.$environmentName).as("environmentName"), (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_VERSION, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_REFERENCE, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.TYPE, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.STATUS, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.CREATED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_BY, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.COMMENT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ATTRIBUTES).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT).where(new Condition[]{Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ENVIRONMENT_UID.eq((Object)this.$environmentUID), Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_VERSION.eq((Object)this.$artifactVersion), Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.TYPE.eq((Object)this.$type), Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_REFERENCE.eq((Object)this.$artifactReference)}).fetchOne((RecordMapper)new RecordMapper<Record11<String, String, String, String, String, ConstraintStatus, Instant, String, Instant, String, String>, ConstraintState>(this){
                    final /* synthetic */ getConstraintState.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final ConstraintState map(Record11<String, String, String, String, String, ConstraintStatus, Instant, String, Instant, String, String> $dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes) {
                        void comment;
                        void judgedAt;
                        void judgedBy;
                        void $this$readValue$iv;
                        void createdAt;
                        void status;
                        void constraintType;
                        void artifactReference;
                        void artifactVersion;
                        void environmentName;
                        void deliveryConfigName;
                        String string = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component1();
                        String string2 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component2();
                        String string3 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component3();
                        String string4 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component4();
                        String string5 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component5();
                        ConstraintStatus constraintStatus = (ConstraintStatus)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component6();
                        Instant instant = (Instant)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component7();
                        String string6 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component8();
                        Instant instant2 = (Instant)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component9();
                        String string7 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component10();
                        String attributes = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component11();
                        void v0 = deliveryConfigName;
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"deliveryConfigName");
                        void v1 = environmentName;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"environmentName");
                        void v2 = artifactVersion;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"artifactVersion");
                        void v3 = artifactReference;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"artifactReference");
                        void v4 = constraintType;
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"constraintType");
                        void v5 = status;
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"status");
                        void v6 = createdAt;
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"createdAt");
                        ObjectMapper objectMapper = this.this$0.this$0.getObjectMapper$keel_sql();
                        String string8 = attributes;
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"attributes");
                        String content$iv = string8;
                        boolean $i$f$readValue = false;
                        String string9 = content$iv;
                        void var17_17 = $this$readValue$iv;
                        boolean $i$f$jacksonTypeRef = false;
                        TypeReference typeReference = (TypeReference)new TypeReference<ConstraintStateAttributes>(){};
                        return new ConstraintState((String)v0, (String)v1, (String)v2, (String)v3, (String)v4, (ConstraintStatus)v5, (Instant)v6, (String)judgedBy, (Instant)judgedAt, (String)comment, (ConstraintStateAttributes)var17_17.readValue(string9, typeReference), null, 2048, null);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$deliveryConfigName = string;
                this.$environmentName = string2;
                this.$environmentUID = string3;
                this.$artifactVersion = string4;
                this.$type = string5;
                this.$artifactReference = string6;
                super(0);
            }
        });
    }

    @Nullable
    public ConstraintState getConstraintStateById(@NotNull ULID.Value uid2) {
        Intrinsics.checkNotNullParameter((Object)uid2, (String)"uid");
        return (ConstraintState)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<ConstraintState>(this, uid2){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ ULID.Value $uid;

            public final ConstraintState invoke() {
                return (ConstraintState)this.this$0.getJooq$keel_sql().select((SelectField)Tables.DELIVERY_CONFIG.NAME, (SelectField)Tables.ENVIRONMENT.NAME, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_VERSION, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_REFERENCE, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.TYPE, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.STATUS, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.CREATED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_BY, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.COMMENT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ATTRIBUTES).from(new TableLike[]{(TableLike)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT, (TableLike)Tables.DELIVERY_CONFIG, (TableLike)Tables.ENVIRONMENT}).where(Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.UID.eq((Object)this.$uid.toString())).and(Tables.ENVIRONMENT.UID.eq((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ENVIRONMENT_UID)).and(Tables.DELIVERY_CONFIG.UID.eq((Field)Tables.ENVIRONMENT.DELIVERY_CONFIG_UID)).fetchOne((RecordMapper)new RecordMapper<Record11<String, String, String, String, String, ConstraintStatus, Instant, String, Instant, String, String>, ConstraintState>(this){
                    final /* synthetic */ getConstraintStateById.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final ConstraintState map(Record11<String, String, String, String, String, ConstraintStatus, Instant, String, Instant, String, String> $dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes) {
                        void comment;
                        void judgedAt;
                        void judgedBy;
                        void $this$readValue$iv;
                        void createdAt;
                        void status;
                        void constraintType;
                        void artifactReference;
                        void artifactVersion;
                        void environmentName;
                        void deliveryConfigName;
                        String string = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component1();
                        String string2 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component2();
                        String string3 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component3();
                        String string4 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component4();
                        String string5 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component5();
                        ConstraintStatus constraintStatus = (ConstraintStatus)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component6();
                        Instant instant = (Instant)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component7();
                        String string6 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component8();
                        Instant instant2 = (Instant)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component9();
                        String string7 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component10();
                        String attributes = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component11();
                        void v0 = deliveryConfigName;
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"deliveryConfigName");
                        void v1 = environmentName;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"environmentName");
                        void v2 = artifactVersion;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"artifactVersion");
                        void v3 = artifactReference;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"artifactReference");
                        void v4 = constraintType;
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"constraintType");
                        void v5 = status;
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"status");
                        void v6 = createdAt;
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"createdAt");
                        ObjectMapper objectMapper = this.this$0.this$0.getObjectMapper$keel_sql();
                        String string8 = attributes;
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"attributes");
                        String content$iv = string8;
                        boolean $i$f$readValue = false;
                        String string9 = content$iv;
                        void var17_17 = $this$readValue$iv;
                        boolean $i$f$jacksonTypeRef = false;
                        TypeReference typeReference = (TypeReference)new TypeReference<ConstraintStateAttributes>(){};
                        return new ConstraintState((String)v0, (String)v1, (String)v2, (String)v3, (String)v4, (ConstraintStatus)v5, (Instant)v6, (String)judgedBy, (Instant)judgedAt, (String)comment, (ConstraintStateAttributes)var17_17.readValue(string9, typeReference), null, 2048, null);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$uid = value;
                super(0);
            }
        });
    }

    public void deleteConstraintState(@NotNull String deliveryConfigName, @NotNull String environmentName, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Select<Record1<String>> envUidSelect = this.envUid(deliveryConfigName, environmentName);
        this.getSqlRetry$keel_sql().withRetry(RetryCategory.WRITE, (Function0)new Function0<Unit>(this, envUidSelect, type){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ Select $envUidSelect;
            final /* synthetic */ String $type;

            public final void invoke() {
                this.this$0.getJooq$keel_sql().select((SelectField)Tables.CURRENT_CONSTRAINT.APPLICATION, (SelectField)Tables.CURRENT_CONSTRAINT.ENVIRONMENT_UID).from((TableLike)Tables.CURRENT_CONSTRAINT).where(new Condition[]{Tables.CURRENT_CONSTRAINT.ENVIRONMENT_UID.eq(this.$envUidSelect), Tables.CURRENT_CONSTRAINT.TYPE.eq((Object)this.$type)}).fetch((RecordMapper)new RecordMapper<Record2<String, String>, Integer>(this){
                    final /* synthetic */ deleteConstraintState.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final Integer map(Record2<String, String> $dstr$application$envUid) {
                        void application2;
                        String string = (String)$dstr$application$envUid.component1();
                        String envUid = (String)$dstr$application$envUid.component2();
                        return this.this$0.this$0.getJooq$keel_sql().deleteFrom((Table)Tables.CURRENT_CONSTRAINT).where(new Condition[]{Tables.CURRENT_CONSTRAINT.APPLICATION.eq((Object)application2), Tables.CURRENT_CONSTRAINT.ENVIRONMENT_UID.eq((Object)envUid), Tables.CURRENT_CONSTRAINT.TYPE.eq((Object)this.this$0.$type)}).execute();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                List list = this.this$0.getJooq$keel_sql().select((SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.UID).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT).where(new Condition[]{Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ENVIRONMENT_UID.eq(this.$envUidSelect), Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.TYPE.eq((Object)this.$type)}).fetch((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.UID);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq.select(ENVIRONMENT_\u2026_ARTIFACT_CONSTRAINT.UID)");
                List ids = CollectionsKt.sorted((Iterable)list);
                Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)ids, (int)20);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    List it = (List)element$iv;
                    boolean bl = false;
                    Collection $this$toTypedArray$iv = it;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    this.this$0.getJooq$keel_sql().deleteFrom((Table)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT).where(Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.UID.in((Object[])Arrays.copyOf(stringArray, stringArray.length))).execute();
                }
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$envUidSelect = select;
                this.$type = string;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ConstraintState> constraintStateFor(@NotNull String application2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        boolean bl = false;
        Map environmentNames = new LinkedHashMap();
        boolean bl2 = false;
        Map deliveryConfigsByEnv = new LinkedHashMap();
        Result constraintResult2 = (Result)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<Result<Record10<String, String, String, String, Instant, ConstraintStatus, String, Instant, String, String>>>(this, application2){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $application;

            public final Result<Record10<String, String, String, String, Instant, ConstraintStatus, String, Instant, String, String>> invoke() {
                return this.this$0.getJooq$keel_sql().select((SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ENVIRONMENT_UID, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_VERSION, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_REFERENCE, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.TYPE, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.CREATED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.STATUS, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_BY, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.COMMENT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ATTRIBUTES).from((TableLike)Tables.CURRENT_CONSTRAINT).innerJoin((TableLike)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT).on(Tables.CURRENT_CONSTRAINT.CONSTRAINT_UID.eq((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.UID)).where(Tables.CURRENT_CONSTRAINT.APPLICATION.eq((Object)this.$application)).fetch();
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$application = string;
                super(0);
            }
        });
        if (constraintResult2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<List<Unit>>(this, application2, environmentNames, deliveryConfigsByEnv){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $application;
            final /* synthetic */ Map $environmentNames;
            final /* synthetic */ Map $deliveryConfigsByEnv;

            public final List<Unit> invoke() {
                return this.this$0.getJooq$keel_sql().select((SelectField)Tables.CURRENT_CONSTRAINT.ENVIRONMENT_UID, (SelectField)Tables.ENVIRONMENT.NAME, (SelectField)Tables.DELIVERY_CONFIG.NAME).from((TableLike)Tables.CURRENT_CONSTRAINT).innerJoin((TableLike)Tables.ENVIRONMENT).on(Tables.ENVIRONMENT.UID.eq((Field)Tables.CURRENT_CONSTRAINT.ENVIRONMENT_UID)).innerJoin((TableLike)Tables.DELIVERY_CONFIG).on(Tables.DELIVERY_CONFIG.UID.eq((Field)Tables.ENVIRONMENT.DELIVERY_CONFIG_UID)).where(Tables.CURRENT_CONSTRAINT.APPLICATION.eq((Object)this.$application)).fetch((RecordMapper)new RecordMapper<Record3<String, String, String>, Unit>(this){
                    final /* synthetic */ constraintStateFor.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void map(Record3<String, String, String> $dstr$envId$envName$dcName) {
                        void envName;
                        void envId;
                        String string = (String)$dstr$envId$envName$dcName.component1();
                        String string2 = (String)$dstr$envId$envName$dcName.component2();
                        String dcName = (String)$dstr$envId$envName$dcName.component3();
                        Map map = this.this$0.$environmentNames;
                        void v1 = envId;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"envId");
                        void v2 = envName;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"envName");
                        map.put(v1, v2);
                        Map map2 = this.this$0.$deliveryConfigsByEnv;
                        String string3 = dcName;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"dcName");
                        map2.put(envId, string3);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$application = string;
                this.$environmentNames = map;
                this.$deliveryConfigsByEnv = map2;
                super(0);
            }
        });
        Result result = constraintResult2;
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"constraintResult");
        Iterable $this$mapNotNull$iv = (Iterable)result;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ConstraintState constraintState;
            void type;
            void artifactVersion;
            void envId;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl3 = false;
            Record10 $dstr$envId$artifactVersion$artifactReference$type$createdAt$status$judgedBy$judgedAt$comment$attributes = (Record10)element$iv$iv;
            boolean bl4 = false;
            String string = (String)$dstr$envId$artifactVersion$artifactReference$type$createdAt$status$judgedBy$judgedAt$comment$attributes.component1();
            String string2 = (String)$dstr$envId$artifactVersion$artifactReference$type$createdAt$status$judgedBy$judgedAt$comment$attributes.component2();
            String string3 = (String)$dstr$envId$artifactVersion$artifactReference$type$createdAt$status$judgedBy$judgedAt$comment$attributes.component3();
            String string4 = (String)$dstr$envId$artifactVersion$artifactReference$type$createdAt$status$judgedBy$judgedAt$comment$attributes.component4();
            Instant instant = (Instant)$dstr$envId$artifactVersion$artifactReference$type$createdAt$status$judgedBy$judgedAt$comment$attributes.component5();
            ConstraintStatus constraintStatus = (ConstraintStatus)$dstr$envId$artifactVersion$artifactReference$type$createdAt$status$judgedBy$judgedAt$comment$attributes.component6();
            String string5 = (String)$dstr$envId$artifactVersion$artifactReference$type$createdAt$status$judgedBy$judgedAt$comment$attributes.component7();
            Instant instant2 = (Instant)$dstr$envId$artifactVersion$artifactReference$type$createdAt$status$judgedBy$judgedAt$comment$attributes.component8();
            String string6 = (String)$dstr$envId$artifactVersion$artifactReference$type$createdAt$status$judgedBy$judgedAt$comment$attributes.component9();
            String attributes = (String)$dstr$envId$artifactVersion$artifactReference$type$createdAt$status$judgedBy$judgedAt$comment$attributes.component10();
            if (deliveryConfigsByEnv.containsKey(envId) && environmentNames.containsKey(envId)) {
                void comment;
                void judgedAt;
                void judgedBy;
                void $this$readValue$iv;
                String content$iv;
                void createdAt;
                void status;
                void artifactReference;
                String string7;
                String string8 = (String)deliveryConfigsByEnv.get(envId);
                if (string8 == null) {
                    string7 = "Environment id " + (String)envId + " does not belong to a delivery-config";
                    boolean bl5 = false;
                    throw (Throwable)new IllegalStateException(string7.toString());
                }
                String string9 = (String)environmentNames.get(envId);
                if (string9 == null) {
                    string7 = "Invalid environment id " + (String)envId;
                    boolean bl6 = false;
                    throw (Throwable)new IllegalStateException(string7.toString());
                }
                void v3 = artifactVersion;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"artifactVersion");
                void v4 = artifactReference;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"artifactReference");
                void v5 = type;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"type");
                void v6 = status;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"status");
                void v7 = createdAt;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"createdAt");
                string7 = this.getObjectMapper$keel_sql();
                Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"attributes");
                boolean $i$f$readValue = false;
                String string10 = content$iv;
                void var32_36 = $this$readValue$iv;
                boolean $i$f$jacksonTypeRef = false;
                TypeReference typeReference = (TypeReference)new TypeReference<ConstraintStateAttributes>(){};
                constraintState = new ConstraintState(string8, string9, (String)v3, (String)v4, (String)v5, (ConstraintStatus)v6, (Instant)v7, (String)judgedBy, (Instant)judgedAt, (String)comment, (ConstraintStateAttributes)var32_36.readValue(string10, typeReference), null, 2048, null);
            } else {
                this.getLog().warn("constraint state for " + "envId=" + (String)envId + ", " + "artifactVersion=" + (String)artifactVersion + ", " + "type=" + (String)type + ", " + " does not belong to a valid environment.");
                constraintState = null;
            }
            if (constraintState == null) continue;
            ConstraintState constraintState2 = constraintState;
            boolean bl7 = false;
            boolean bl8 = false;
            ConstraintState it$iv$iv = constraintState2;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<ConstraintState> constraintStateFor(@NotNull String deliveryConfigName, @NotNull String environmentName, int limit) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        String string = this.environmentUidByName(deliveryConfigName, environmentName);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String environmentUID = string;
        Object t = this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<List<ConstraintState>>(this, deliveryConfigName, environmentName, environmentUID, limit){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $deliveryConfigName;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ String $environmentUID;
            final /* synthetic */ int $limit;

            public final List<ConstraintState> invoke() {
                return this.this$0.getJooq$keel_sql().select((SelectField)DSL.inline((String)this.$deliveryConfigName).as("deliveryConfigName"), (SelectField)DSL.inline((String)this.$environmentName).as("environmentName"), (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_VERSION, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_REFERENCE, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.TYPE, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.STATUS, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.CREATED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_BY, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.COMMENT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ATTRIBUTES).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT).where(Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ENVIRONMENT_UID.eq((Object)this.$environmentUID)).orderBy((OrderField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.CREATED_AT.desc()).limit(this.$limit).fetch((RecordMapper)new RecordMapper<Record11<String, String, String, String, String, ConstraintStatus, Instant, String, Instant, String, String>, ConstraintState>(this){
                    final /* synthetic */ constraintStateFor.3 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final ConstraintState map(Record11<String, String, String, String, String, ConstraintStatus, Instant, String, Instant, String, String> $dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes) {
                        void comment;
                        void judgedAt;
                        void judgedBy;
                        void $this$readValue$iv;
                        void createdAt;
                        void status;
                        void constraintType;
                        void artifactReference;
                        void artifactVersion;
                        void environmentName;
                        void deliveryConfigName;
                        String string = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component1();
                        String string2 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component2();
                        String string3 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component3();
                        String string4 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component4();
                        String string5 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component5();
                        ConstraintStatus constraintStatus = (ConstraintStatus)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component6();
                        Instant instant = (Instant)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component7();
                        String string6 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component8();
                        Instant instant2 = (Instant)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component9();
                        String string7 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component10();
                        String attributes = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component11();
                        void v0 = deliveryConfigName;
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"deliveryConfigName");
                        void v1 = environmentName;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"environmentName");
                        void v2 = artifactVersion;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"artifactVersion");
                        void v3 = artifactReference;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"artifactReference");
                        void v4 = constraintType;
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"constraintType");
                        void v5 = status;
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"status");
                        void v6 = createdAt;
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"createdAt");
                        ObjectMapper objectMapper = this.this$0.this$0.getObjectMapper$keel_sql();
                        String string8 = attributes;
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"attributes");
                        String content$iv = string8;
                        boolean $i$f$readValue = false;
                        String string9 = content$iv;
                        void var17_17 = $this$readValue$iv;
                        boolean $i$f$jacksonTypeRef = false;
                        TypeReference typeReference = (TypeReference)new TypeReference<ConstraintStateAttributes>(){};
                        return new ConstraintState((String)v0, (String)v1, (String)v2, (String)v3, (String)v4, (ConstraintStatus)v5, (Instant)v6, (String)judgedBy, (Instant)judgedAt, (String)comment, (ConstraintStateAttributes)var17_17.readValue(string9, typeReference), null, 2048, null);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$deliveryConfigName = string;
                this.$environmentName = string2;
                this.$environmentUID = string3;
                this.$limit = n;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026        )\n        }\n    }");
        return (List)t;
    }

    @NotNull
    public List<ConstraintState> constraintStateFor(@NotNull String deliveryConfigName, @NotNull String environmentName, @NotNull String artifactVersion, @NotNull String artifactReference) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)artifactVersion, (String)"artifactVersion");
        Intrinsics.checkNotNullParameter((Object)artifactReference, (String)"artifactReference");
        return SqlDeliveryConfigRepository.constraintStateForWithTransaction$default(this, deliveryConfigName, environmentName, artifactVersion, artifactReference, null, 16, null);
    }

    private final List<ConstraintState> constraintStateForWithTransaction(String deliveryConfigName, String environmentName, String artifactVersion, String artifactReference, DSLContext txn) {
        String string = this.environmentUidByName(deliveryConfigName, environmentName);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String environmentUID = string;
        Object t = this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<List<ConstraintState>>(this, txn, deliveryConfigName, environmentName, environmentUID, artifactVersion, artifactReference){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ DSLContext $txn;
            final /* synthetic */ String $deliveryConfigName;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ String $environmentUID;
            final /* synthetic */ String $artifactVersion;
            final /* synthetic */ String $artifactReference;

            public final List<ConstraintState> invoke() {
                return this.$txn.select((SelectField)DSL.inline((String)this.$deliveryConfigName).as("deliveryConfigName"), (SelectField)DSL.inline((String)this.$environmentName).as("environmentName"), (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_VERSION, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_REFERENCE, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.TYPE, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.STATUS, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.CREATED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_BY, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.JUDGED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.COMMENT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ATTRIBUTES).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT).where(new Condition[]{Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ENVIRONMENT_UID.eq((Object)this.$environmentUID), Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_VERSION.eq((Object)this.$artifactVersion), Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_REFERENCE.eq((Object)this.$artifactReference)}).fetch((RecordMapper)new RecordMapper<Record11<String, String, String, String, String, ConstraintStatus, Instant, String, Instant, String, String>, ConstraintState>(this){
                    final /* synthetic */ constraintStateForWithTransaction.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final ConstraintState map(Record11<String, String, String, String, String, ConstraintStatus, Instant, String, Instant, String, String> $dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes) {
                        void comment;
                        void judgedAt;
                        void judgedBy;
                        void $this$readValue$iv;
                        void createdAt;
                        void status;
                        void constraintType;
                        void artifactReference;
                        void artifactVersion;
                        void environmentName;
                        void deliveryConfigName;
                        String string = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component1();
                        String string2 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component2();
                        String string3 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component3();
                        String string4 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component4();
                        String string5 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component5();
                        ConstraintStatus constraintStatus = (ConstraintStatus)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component6();
                        Instant instant = (Instant)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component7();
                        String string6 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component8();
                        Instant instant2 = (Instant)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component9();
                        String string7 = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component10();
                        String attributes = (String)$dstr$deliveryConfigName$environmentName$artifactVersion$artifactReference$constraintType$status$createdAt$judgedBy$judgedAt$comment$attributes.component11();
                        void v0 = deliveryConfigName;
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"deliveryConfigName");
                        void v1 = environmentName;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"environmentName");
                        void v2 = artifactVersion;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"artifactVersion");
                        void v3 = artifactReference;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"artifactReference");
                        void v4 = constraintType;
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"constraintType");
                        void v5 = status;
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"status");
                        void v6 = createdAt;
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"createdAt");
                        ObjectMapper objectMapper = this.this$0.this$0.getObjectMapper$keel_sql();
                        String string8 = attributes;
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"attributes");
                        String content$iv = string8;
                        boolean $i$f$readValue = false;
                        String string9 = content$iv;
                        void var17_17 = $this$readValue$iv;
                        boolean $i$f$jacksonTypeRef = false;
                        TypeReference typeReference = (TypeReference)new TypeReference<ConstraintStateAttributes>(){};
                        return new ConstraintState((String)v0, (String)v1, (String)v2, (String)v3, (String)v4, (ConstraintStatus)v5, (Instant)v6, (String)judgedBy, (Instant)judgedAt, (String)comment, (ConstraintStateAttributes)var17_17.readValue(string9, typeReference), null, 2048, null);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$txn = dSLContext;
                this.$deliveryConfigName = string;
                this.$environmentName = string2;
                this.$environmentUID = string3;
                this.$artifactVersion = string4;
                this.$artifactReference = string5;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026        )\n        }\n    }");
        return (List)t;
    }

    static /* synthetic */ List constraintStateForWithTransaction$default(SqlDeliveryConfigRepository sqlDeliveryConfigRepository, String string, String string2, String string3, String string4, DSLContext dSLContext, int n, Object object) {
        if ((n & 0x10) != 0) {
            dSLContext = sqlDeliveryConfigRepository.getJooq$keel_sql();
        }
        return sqlDeliveryConfigRepository.constraintStateForWithTransaction(string, string2, string3, string4, dSLContext);
    }

    @NotNull
    public List<PublishedArtifact> getPendingConstraintsForArtifactVersions(@NotNull String deliveryConfigName, @NotNull String environmentName, @NotNull DeliveryArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        String string = this.environmentUidByName(deliveryConfigName, environmentName);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String environmentUID = string;
        return (List)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<List<? extends PublishedArtifact>>(this, environmentUID, artifact){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $environmentUID;
            final /* synthetic */ DeliveryArtifact $artifact;

            @NotNull
            public final List<PublishedArtifact> invoke() {
                SelectConditionStep selectConditionStep = this.this$0.getJooq$keel_sql().select((SelectField)Tables.ARTIFACT_VERSIONS.NAME, (SelectField)Tables.ARTIFACT_VERSIONS.TYPE, (SelectField)Tables.ARTIFACT_VERSIONS.VERSION, (SelectField)Tables.ARTIFACT_VERSIONS.RELEASE_STATUS, (SelectField)Tables.ARTIFACT_VERSIONS.CREATED_AT, (SelectField)Tables.ARTIFACT_VERSIONS.GIT_METADATA, (SelectField)Tables.ARTIFACT_VERSIONS.BUILD_METADATA).from(new TableLike[]{(TableLike)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT, (TableLike)Tables.ARTIFACT_VERSIONS}).where(new Condition[]{Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ENVIRONMENT_UID.eq((Object)this.$environmentUID), Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.STATUS.eq((Object)ConstraintStatus.PENDING)}).and(Tables.ARTIFACT_VERSIONS.NAME.eq((Object)this.$artifact.getName())).and(Tables.ARTIFACT_VERSIONS.TYPE.eq((Object)this.$artifact.getType())).and(Tables.ARTIFACT_VERSIONS.VERSION.eq((Field)Tables.ENVIRONMENT_ARTIFACT_CONSTRAINT.ARTIFACT_VERSION));
                Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"jooq\n        .select(\n  \u2026TRAINT.ARTIFACT_VERSION))");
                return ArtifactUtilsKt.fetchSortedArtifactVersions$default(selectConditionStep, this.$artifact, null, 2, null);
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$environmentUID = string;
                this.$artifact = deliveryArtifact;
                super(0);
            }
        });
    }

    @NotNull
    public List<PublishedArtifact> getArtifactVersionsQueuedForApproval(@NotNull String deliveryConfigName, @NotNull String environmentName, @NotNull DeliveryArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        String string = this.environmentUidByName(deliveryConfigName, environmentName);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String environmentUID = string;
        return (List)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<List<? extends PublishedArtifact>>(this, environmentUID, artifact){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $environmentUID;
            final /* synthetic */ DeliveryArtifact $artifact;

            @NotNull
            public final List<PublishedArtifact> invoke() {
                SelectConditionStep selectConditionStep = this.this$0.getJooq$keel_sql().select((SelectField)Tables.ARTIFACT_VERSIONS.NAME, (SelectField)Tables.ARTIFACT_VERSIONS.TYPE, (SelectField)Tables.ARTIFACT_VERSIONS.VERSION, (SelectField)Tables.ARTIFACT_VERSIONS.RELEASE_STATUS, (SelectField)Tables.ARTIFACT_VERSIONS.CREATED_AT, (SelectField)Tables.ARTIFACT_VERSIONS.GIT_METADATA, (SelectField)Tables.ARTIFACT_VERSIONS.BUILD_METADATA).from(new TableLike[]{(TableLike)Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL, (TableLike)Tables.ARTIFACT_VERSIONS}).where(Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL.ENVIRONMENT_UID.eq((Object)this.$environmentUID));
                Condition condition = Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL.ARTIFACT_REFERENCE.eq((Object)this.$artifact.getReference());
                TableField<EnvironmentArtifactQueuedApprovalRecord, String> tableField = Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL.ARTIFACT_REFERENCE;
                Intrinsics.checkNotNullExpressionValue(tableField, (String)"ENVIRONMENT_ARTIFACT_QUE\u2026PROVAL.ARTIFACT_REFERENCE");
                SelectConditionStep selectConditionStep2 = selectConditionStep.and(condition.or(tableField.isNull())).and(Tables.ARTIFACT_VERSIONS.VERSION.eq((Field)Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL.ARTIFACT_VERSION)).and(Tables.ARTIFACT_VERSIONS.NAME.eq((Object)this.$artifact.getName())).and(Tables.ARTIFACT_VERSIONS.TYPE.eq((Object)this.$artifact.getType()));
                Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"jooq.select(\n        ART\u2026S.TYPE.eq(artifact.type))");
                return ArtifactUtilsKt.fetchSortedArtifactVersions$default(selectConditionStep2, this.$artifact, null, 2, null);
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$environmentUID = string;
                this.$artifact = deliveryArtifact;
                super(0);
            }
        });
    }

    public void queueArtifactVersionForApproval(@NotNull String deliveryConfigName, @NotNull String environmentName, @NotNull DeliveryArtifact artifact, @NotNull String artifactVersion) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)artifactVersion, (String)"artifactVersion");
        this.getSqlRetry$keel_sql().withRetry(RetryCategory.WRITE, (Function0)new Function0<String>(this, deliveryConfigName, environmentName, artifactVersion, artifact){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $deliveryConfigName;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ String $artifactVersion;
            final /* synthetic */ DeliveryArtifact $artifact;

            @Nullable
            public final String invoke() {
                String string;
                String string2 = SqlDeliveryConfigRepository.access$environmentUidByName(this.this$0, this.$deliveryConfigName, this.$environmentName);
                if (string2 != null) {
                    String string3 = string2;
                    boolean bl = false;
                    boolean bl2 = false;
                    String envUid = string3;
                    boolean bl3 = false;
                    this.this$0.getJooq$keel_sql().insertInto((Table)Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL).set((Field)Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL.ENVIRONMENT_UID, (Object)envUid).set((Field)Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL.ARTIFACT_VERSION, (Object)this.$artifactVersion).set((Field)Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL.QUEUED_AT, (Object)this.this$0.getClock$keel_sql().instant()).set((Field)Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL.ARTIFACT_REFERENCE, (Object)this.$artifact.getReference()).onDuplicateKeyIgnore().execute();
                    string = string3;
                } else {
                    string = null;
                }
                return string;
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$deliveryConfigName = string;
                this.$environmentName = string2;
                this.$artifactVersion = string3;
                this.$artifact = deliveryArtifact;
                super(0);
            }
        });
    }

    public void deleteArtifactVersionQueuedForApproval(@NotNull String deliveryConfigName, @NotNull String environmentName, @NotNull DeliveryArtifact artifact, @NotNull String artifactVersion) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)artifactVersion, (String)"artifactVersion");
        this.getSqlRetry$keel_sql().withRetry(RetryCategory.WRITE, (Function0)new Function0<String>(this, deliveryConfigName, environmentName, artifactVersion, artifact){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $deliveryConfigName;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ String $artifactVersion;
            final /* synthetic */ DeliveryArtifact $artifact;

            @Nullable
            public final String invoke() {
                String string;
                String string2 = SqlDeliveryConfigRepository.access$environmentUidByName(this.this$0, this.$deliveryConfigName, this.$environmentName);
                if (string2 != null) {
                    String string3 = string2;
                    boolean bl = false;
                    boolean bl2 = false;
                    String envUid = string3;
                    boolean bl3 = false;
                    this.this$0.getJooq$keel_sql().deleteFrom((Table)Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL).where(new Condition[]{Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL.ENVIRONMENT_UID.eq((Object)envUid), Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL.ARTIFACT_VERSION.eq((Object)this.$artifactVersion), Tables.ENVIRONMENT_ARTIFACT_QUEUED_APPROVAL.ARTIFACT_REFERENCE.eq((Object)this.$artifact.getReference())}).execute();
                    string = string3;
                } else {
                    string = null;
                }
                return string;
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$deliveryConfigName = string;
                this.$environmentName = string2;
                this.$artifactVersion = string3;
                this.$artifact = deliveryArtifact;
                super(0);
            }
        });
    }

    public void triggerRecheck(@NotNull String application2) {
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        String uid2 = (String)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<String>(this, application2){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $application;

            public final String invoke() {
                return (String)this.this$0.getJooq$keel_sql().select((SelectField)Tables.DELIVERY_CONFIG.UID).from((TableLike)Tables.DELIVERY_CONFIG).where(Tables.DELIVERY_CONFIG.APPLICATION.eq((Object)this.$application)).fetchOne((Field)Tables.DELIVERY_CONFIG.UID);
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$application = string;
                super(0);
            }
        });
        if (uid2 == null) {
            this.getLog().error("Config for app " + application2 + " does not exist, cannot recheck it");
            return;
        }
        this.getSqlRetry$keel_sql().withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, uid2){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $uid;

            public final int invoke() {
                return this.this$0.getJooq$keel_sql().update((Table)Tables.DELIVERY_CONFIG_LAST_CHECKED).set((Field)Tables.DELIVERY_CONFIG_LAST_CHECKED.AT, (Object)Instant.EPOCH.plusSeconds(1L)).set((Field)Tables.DELIVERY_CONFIG_LAST_CHECKED.LEASED_AT, (Object)Instant.EPOCH.plusSeconds(1L)).set((Field)Tables.DELIVERY_CONFIG_LAST_CHECKED.LEASED_BY, (Object)SqlDeliveryConfigRepository.access$getRECHECK_LEASE_NAME$p(this.this$0)).where(Tables.DELIVERY_CONFIG_LAST_CHECKED.DELIVERY_CONFIG_UID.eq((Object)this.$uid)).execute();
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$uid = string;
                super(0);
            }
        });
    }

    @NotNull
    public Collection<DeliveryConfig> itemsDueForCheck(@NotNull Duration minTimeSinceLastCheck, int limit) {
        Intrinsics.checkNotNullParameter((Object)minTimeSinceLastCheck, (String)"minTimeSinceLastCheck");
        Instant now = this.getClock$keel_sql().instant();
        Instant cutoff = now.minus(minTimeSinceLastCheck);
        List list = ((Result)this.getSqlRetry$keel_sql().withRetry(RetryCategory.WRITE, (Function0)new Function0<Result<Record3<String, String, Instant>>>(this, cutoff, limit, now){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ Instant $cutoff;
            final /* synthetic */ int $limit;
            final /* synthetic */ Instant $now;

            public final Result<Record3<String, String, Instant>> invoke() {
                return (Result)JooqKt.inTransaction(this.this$0.getJooq$keel_sql(), (Function1)new Function1<DSLContext, Result<Record3<String, String, Instant>>>(this){
                    final /* synthetic */ itemsDueForCheck.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final Result<Record3<String, String, Instant>> invoke(@NotNull DSLContext $this$inTransaction) {
                        Intrinsics.checkNotNullParameter((Object)$this$inTransaction, (String)"$receiver");
                        SelectConditionStep selectConditionStep = $this$inTransaction.select((SelectField)Tables.DELIVERY_CONFIG.UID, (SelectField)Tables.DELIVERY_CONFIG.NAME, (SelectField)Tables.DELIVERY_CONFIG_LAST_CHECKED.AT).from(new TableLike[]{(TableLike)Tables.DELIVERY_CONFIG, (TableLike)Tables.DELIVERY_CONFIG_LAST_CHECKED}).where(Tables.DELIVERY_CONFIG.UID.eq((Field)Tables.DELIVERY_CONFIG_LAST_CHECKED.DELIVERY_CONFIG_UID)).and(Tables.DELIVERY_CONFIG_LAST_CHECKED.AT.lessOrEqual((Object)this.this$0.$cutoff));
                        TableField<DeliveryConfigLastCheckedRecord, String> tableField = Tables.DELIVERY_CONFIG_LAST_CHECKED.LEASED_BY;
                        Intrinsics.checkNotNullExpressionValue(tableField, (String)"DELIVERY_CONFIG_LAST_CHECKED.LEASED_BY");
                        Result result = selectConditionStep.and(tableField.isNull().or(Tables.DELIVERY_CONFIG_LAST_CHECKED.LEASED_AT.lessOrEqual((Object)this.this$0.$cutoff))).andNotExists((Select)$this$inTransaction.selectOne().from((TableLike)Tables.PAUSED).where(Tables.PAUSED.NAME.eq((Field)Tables.DELIVERY_CONFIG.APPLICATION)).and(Tables.PAUSED.SCOPE.eq((Object)PauseScope.APPLICATION))).orderBy((OrderField)Tables.DELIVERY_CONFIG_LAST_CHECKED.AT).limit(this.this$0.$limit).forUpdate().fetch();
                        boolean bl = false;
                        boolean bl2 = false;
                        Result it = result;
                        boolean bl3 = false;
                        Result result2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"it");
                        Iterable $this$forEach$iv = (Iterable)result2;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            void name;
                            void uid2;
                            Record3 $dstr$uid$name$lastCheckedAt = (Record3)element$iv;
                            boolean bl4 = false;
                            String string = (String)$dstr$uid$name$lastCheckedAt.component1();
                            String string2 = (String)$dstr$uid$name$lastCheckedAt.component2();
                            Instant lastCheckedAt = (Instant)$dstr$uid$name$lastCheckedAt.component3();
                            UpdateSetFirstStep updateSetFirstStep = $this$inTransaction.update((Table)Tables.DELIVERY_CONFIG_LAST_CHECKED);
                            Field field = (Field)Tables.DELIVERY_CONFIG_LAST_CHECKED.LEASED_BY;
                            InetAddress inetAddress = InetAddress.getLocalHost();
                            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"InetAddress.getLocalHost()");
                            updateSetFirstStep.set(field, (Object)inetAddress.getHostName()).set((Field)Tables.DELIVERY_CONFIG_LAST_CHECKED.LEASED_AT, (Object)this.this$0.$now).where(Tables.DELIVERY_CONFIG_LAST_CHECKED.DELIVERY_CONFIG_UID.eq((Object)uid2)).execute();
                            ApplicationEventPublisher applicationEventPublisher = SqlDeliveryConfigRepository.access$getPublisher$p(this.this$0.this$0);
                            Instant instant = lastCheckedAt;
                            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"lastCheckedAt");
                            applicationEventPublisher.publishEvent((Object)new AboutToBeChecked(instant, "deliveryConfig", "deliveryConfig:" + (String)name));
                        }
                        return result;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$cutoff = instant;
                this.$limit = n;
                this.$now = instant2;
                super(0);
            }
        })).map((RecordMapper)new RecordMapper<Record3<String, String, Instant>, DeliveryConfig>(this){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;

            public final DeliveryConfig map(Record3<String, String, Instant> $dstr$_u24__u24$name) {
                String name;
                String string = name = (String)$dstr$_u24__u24$name.component2();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                return this.this$0.get(string);
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sqlRetry.withRetry(WRITE\u2026        get(name)\n      }");
        return list;
    }

    public void markCheckComplete(@NotNull DeliveryConfig deliveryConfig) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        this.getSqlRetry$keel_sql().withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, deliveryConfig){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;

            public final int invoke() {
                return this.this$0.getJooq$keel_sql().update((Table)Tables.DELIVERY_CONFIG_LAST_CHECKED).set((Field)Tables.DELIVERY_CONFIG_LAST_CHECKED.AT, (Object)this.this$0.getClock$keel_sql().instant()).setNull((Field)Tables.DELIVERY_CONFIG_LAST_CHECKED.LEASED_BY).setNull((Field)Tables.DELIVERY_CONFIG_LAST_CHECKED.LEASED_AT).where(Tables.DELIVERY_CONFIG_LAST_CHECKED.DELIVERY_CONFIG_UID.eq((Select)DSL.select((SelectField)((SelectField)Tables.DELIVERY_CONFIG.UID)).from((TableLike)Tables.DELIVERY_CONFIG).where(Tables.DELIVERY_CONFIG.NAME.eq((Object)this.$deliveryConfig.getName())))).and(Tables.DELIVERY_CONFIG_LAST_CHECKED.LEASED_BY.ne((Object)SqlDeliveryConfigRepository.access$getRECHECK_LEASE_NAME$p(this.this$0))).execute();
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$deliveryConfig = deliveryConfig;
                super(0);
            }
        });
    }

    private final Select<Record1<String>> getUids(String $this$uids) {
        SelectConditionStep selectConditionStep = DSL.select((SelectField)((SelectField)Tables.RESOURCE.UID)).from((TableLike)Tables.RESOURCE).where(Tables.RESOURCE.ID.eq((Object)$this$uids));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"select(RESOURCE.UID)\n   \u2026ere(RESOURCE.ID.eq(this))");
        return (Select)selectConditionStep;
    }

    private final String deliveryConfigUidByName(String deliveryConfigName) {
        return (String)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<String>(this, deliveryConfigName){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $deliveryConfigName;

            public final String invoke() {
                return (String)this.this$0.getJooq$keel_sql().select((SelectField)Tables.DELIVERY_CONFIG.UID).from((TableLike)Tables.DELIVERY_CONFIG).where(Tables.DELIVERY_CONFIG.NAME.eq((Object)this.$deliveryConfigName)).fetchOne((Field)Tables.DELIVERY_CONFIG.UID);
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$deliveryConfigName = string;
                super(0);
            }
        });
    }

    private final String environmentUidByName(String deliveryConfigName, String environmentName) {
        return (String)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<String>(this, deliveryConfigName, environmentName){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $deliveryConfigName;
            final /* synthetic */ String $environmentName;

            public final String invoke() {
                return (String)this.this$0.getJooq$keel_sql().select((SelectField)Tables.ENVIRONMENT.UID).from((TableLike)Tables.DELIVERY_CONFIG).innerJoin((TableLike)Tables.ENVIRONMENT).on(Tables.DELIVERY_CONFIG.UID.eq((Field)Tables.ENVIRONMENT.DELIVERY_CONFIG_UID)).where(new Condition[]{Tables.DELIVERY_CONFIG.NAME.eq((Object)this.$deliveryConfigName), Tables.ENVIRONMENT.NAME.eq((Object)this.$environmentName)}).fetchOne((Field)Tables.ENVIRONMENT.UID);
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$deliveryConfigName = string;
                this.$environmentName = string2;
                super(0);
            }
        });
    }

    private final Select<Record1<String>> envUid(String deliveryConfigName, String environmentName) {
        SelectConditionStep selectConditionStep = DSL.select((SelectField)((SelectField)Tables.ENVIRONMENT.UID)).from((TableLike)Tables.DELIVERY_CONFIG).innerJoin((TableLike)Tables.ENVIRONMENT).on(Tables.DELIVERY_CONFIG.UID.eq((Field)Tables.ENVIRONMENT.DELIVERY_CONFIG_UID)).where(new Condition[]{Tables.DELIVERY_CONFIG.NAME.eq((Object)deliveryConfigName), Tables.ENVIRONMENT.NAME.eq((Object)environmentName)});
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"select(ENVIRONMENT.UID)\n\u2026(environmentName)\n      )");
        return (Select)selectConditionStep;
    }

    private final String applicationByDeliveryConfigName(String name) {
        String string = (String)this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<String>(this, name){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ String $name;

            public final String invoke() {
                return (String)this.this$0.getJooq$keel_sql().select((SelectField)Tables.DELIVERY_CONFIG.APPLICATION).from((TableLike)Tables.DELIVERY_CONFIG).where(Tables.DELIVERY_CONFIG.NAME.eq((Object)this.$name)).fetchOne((Field)Tables.DELIVERY_CONFIG.APPLICATION);
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$name = string;
                super(0);
            }
        });
        if (string == null) {
            throw (Throwable)new NoSuchDeliveryConfigName(name);
        }
        return string;
    }

    private final <T> String toJson(T $this$toJson) {
        return this.getObjectMapper$keel_sql().writeValueAsString($this$toJson);
    }

    @NotNull
    public Collection<ApplicationSummary> getApplicationSummaries() {
        Object t = this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<List<ApplicationSummary>>(this){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;

            public final List<ApplicationSummary> invoke() {
                return this.this$0.getJooq$keel_sql().select((SelectField)Tables.DELIVERY_CONFIG.UID, (SelectField)Tables.DELIVERY_CONFIG.NAME, (SelectField)Tables.DELIVERY_CONFIG.APPLICATION, (SelectField)Tables.DELIVERY_CONFIG.SERVICE_ACCOUNT, (SelectField)Tables.DELIVERY_CONFIG.API_VERSION, (SelectField)DSL.count((Field)((Field)Tables.RESOURCE_WITH_METADATA.UID)), (SelectField)Tables.PAUSED.NAME).from((TableLike)Tables.DELIVERY_CONFIG).leftOuterJoin((TableLike)Tables.RESOURCE_WITH_METADATA).on(Tables.RESOURCE_WITH_METADATA.APPLICATION.eq((Field)Tables.DELIVERY_CONFIG.APPLICATION)).leftOuterJoin((TableLike)Tables.PAUSED).on(Tables.PAUSED.NAME.eq((Field)Tables.DELIVERY_CONFIG.APPLICATION).and(Tables.PAUSED.SCOPE.eq((Object)PauseScope.APPLICATION))).groupBy(new GroupField[]{(GroupField)Tables.DELIVERY_CONFIG.APPLICATION}).orderBy((OrderField)Tables.DELIVERY_CONFIG.APPLICATION).fetch((RecordMapper)getApplicationSummaries.1.INSTANCE);
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026        )\n        }\n    }");
        return (Collection)t;
    }

    @NotNull
    public Instant deliveryConfigLastChecked(@NotNull DeliveryConfig deliveryConfig) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Object t = this.getSqlRetry$keel_sql().withRetry(RetryCategory.READ, (Function0)new Function0<Instant>(this, deliveryConfig){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;

            public final Instant invoke() {
                Instant instant = (Instant)this.this$0.getJooq$keel_sql().select((SelectField)Tables.DELIVERY_CONFIG_LAST_CHECKED.AT).from(new TableLike[]{(TableLike)Tables.DELIVERY_CONFIG_LAST_CHECKED, (TableLike)Tables.DELIVERY_CONFIG}).where(Tables.DELIVERY_CONFIG_LAST_CHECKED.DELIVERY_CONFIG_UID.eq((Field)Tables.DELIVERY_CONFIG.UID)).and(Tables.DELIVERY_CONFIG.NAME.eq((Object)this.$deliveryConfig.getName())).fetchSingle((Field)Tables.DELIVERY_CONFIG_LAST_CHECKED.AT);
                if (instant == null) {
                    instant = Instant.EPOCH;
                }
                return instant;
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$deliveryConfig = deliveryConfig;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026HECKED.AT) ?: EPOCH\n    }");
        return (Instant)t;
    }

    public void addArtifactVersionToEnvironment(@NotNull DeliveryConfig deliveryConfig, @NotNull String environmentName, @NotNull DeliveryArtifact artifact, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Select<Record1<String>> environmentUid = this.envUid(deliveryConfig.getName(), environmentName);
        this.getSqlRetry$keel_sql().withRetry(RetryCategory.WRITE, (Function0)new Function0<Object>(this, environmentUid, artifact, version, deliveryConfig, environmentName){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;
            final /* synthetic */ Select $environmentUid;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ String $version;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ String $environmentName;

            @NotNull
            public final Object invoke() {
                Object object;
                boolean alreadyExists;
                SelectConditionStep selectConditionStep = this.this$0.getJooq$keel_sql().selectCount().from((TableLike)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION).where(Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ENVIRONMENT_UID.eq(this.$environmentUid)).and(Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ARTIFACT_UID.eq((Select)SqlDeliveryConfigRepository.access$getUid$p(this.this$0, this.$artifact))).and(Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ARTIFACT_VERSION.eq((Object)this.$version));
                Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"jooq\n        .selectCoun\u2026FACT_VERSION.eq(version))");
                ResultQuery $this$fetchOneInto$iv = (ResultQuery)selectConditionStep;
                boolean $i$f$fetchOneInto = false;
                boolean bl = alreadyExists = ((Number)$this$fetchOneInto$iv.fetchOneInto(Integer.class)).intValue() > 0;
                if (alreadyExists) {
                    SqlDeliveryConfigRepository.access$getLog$p(this.this$0).error("Artifact {} version {} is already associated with {}/{}", new Object[]{this.$artifact.getName(), this.$version, this.$deliveryConfig.getApplication(), this.$environmentName});
                    object = Unit.INSTANCE;
                } else {
                    SelectConditionStep selectConditionStep2 = this.this$0.getJooq$keel_sql().select((SelectField)DSL.coalesce((Field)((Field)DSL.max((Field)((Field)Tables.ENVIRONMENT_VERSION.VERSION))), (Field[])new Field[]{(Field)DSL.value((int)0)})).from((TableLike)Tables.ENVIRONMENT_VERSION).where(Tables.ENVIRONMENT_VERSION.ENVIRONMENT_UID.eq(this.$environmentUid));
                    Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"jooq\n          .select(c\u2026T_UID.eq(environmentUid))");
                    ResultQuery $this$fetchOneInto$iv2 = (ResultQuery)selectConditionStep2;
                    boolean $i$f$fetchOneInto2 = false;
                    Integer currentVersion = (Integer)$this$fetchOneInto$iv2.fetchOneInto(Integer.class);
                    int newVersion = currentVersion + 1;
                    SqlDeliveryConfigRepository.access$getLog$p(this.this$0).debug("Creating a new version {} of environment {}/{} because of a new version {} of artifact {}", new Object[]{newVersion, this.$deliveryConfig.getApplication(), this.$environmentName, this.$version, this.$artifact.getName()});
                    object = JooqKt.inTransaction(this.this$0.getJooq$keel_sql(), (Function1)new Function1<DSLContext, Integer>(this, newVersion, currentVersion){
                        final /* synthetic */ addArtifactVersionToEnvironment.1 this$0;
                        final /* synthetic */ int $newVersion;
                        final /* synthetic */ Integer $currentVersion;

                        public final int invoke(@NotNull DSLContext $this$inTransaction) {
                            Intrinsics.checkNotNullParameter((Object)$this$inTransaction, (String)"$receiver");
                            $this$inTransaction.insertInto((Table)Tables.ENVIRONMENT_VERSION).set((Field)Tables.ENVIRONMENT_VERSION.ENVIRONMENT_UID, this.this$0.$environmentUid).set((Field)Tables.ENVIRONMENT_VERSION.VERSION, (Object)this.$newVersion).set((Field)Tables.ENVIRONMENT_VERSION.CREATED_AT, (Object)this.this$0.this$0.getClock$keel_sql().instant()).execute();
                            $this$inTransaction.insertInto((Table)Tables.ENVIRONMENT_RESOURCE).columns((Field)Tables.ENVIRONMENT_RESOURCE.ENVIRONMENT_UID, (Field)Tables.ENVIRONMENT_RESOURCE.ENVIRONMENT_VERSION, (Field)Tables.ENVIRONMENT_RESOURCE.RESOURCE_UID, (Field)Tables.ENVIRONMENT_RESOURCE.RESOURCE_VERSION).select((Select)$this$inTransaction.select((SelectField)Tables.ENVIRONMENT_RESOURCE.ENVIRONMENT_UID, (SelectField)DSL.value((int)this.$newVersion), (SelectField)Tables.ENVIRONMENT_RESOURCE.RESOURCE_UID, (SelectField)Tables.ENVIRONMENT_RESOURCE.RESOURCE_VERSION).from((TableLike)Tables.ENVIRONMENT_RESOURCE).where(Tables.ENVIRONMENT_RESOURCE.ENVIRONMENT_UID.eq(this.this$0.$environmentUid)).and(Tables.ENVIRONMENT_RESOURCE.ENVIRONMENT_VERSION.eq((Object)this.$currentVersion))).execute();
                            $this$inTransaction.insertInto((Table)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION).set((Field)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ENVIRONMENT_UID, this.this$0.$environmentUid).set((Field)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ENVIRONMENT_VERSION, (Object)this.$newVersion).set((Field)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ARTIFACT_UID, (Select)SqlDeliveryConfigRepository.access$getUid$p(this.this$0.this$0, this.this$0.$artifact)).set((Field)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ARTIFACT_VERSION, (Object)this.this$0.$version).execute();
                            return $this$inTransaction.insertInto((Table)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION).columns((Field)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ENVIRONMENT_UID, (Field)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ENVIRONMENT_VERSION, (Field)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ARTIFACT_UID, (Field)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ARTIFACT_VERSION).select((Select)$this$inTransaction.select((SelectField)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ENVIRONMENT_UID, (SelectField)DSL.value((int)this.$newVersion), (SelectField)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ARTIFACT_UID, (SelectField)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ARTIFACT_VERSION).from((TableLike)Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION).where(Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ENVIRONMENT_UID.eq(this.this$0.$environmentUid)).and(Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ENVIRONMENT_VERSION.eq((Object)this.$currentVersion)).and(Tables.ENVIRONMENT_VERSION_ARTIFACT_VERSION.ARTIFACT_UID.ne((Select)SqlDeliveryConfigRepository.access$getUid$p(this.this$0.this$0, this.this$0.$artifact)))).execute();
                        }
                        {
                            this.this$0 = var1_1;
                            this.$newVersion = n;
                            this.$currentVersion = n2;
                            super(1);
                        }
                    });
                }
                return object;
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                this.$environmentUid = select;
                this.$artifact = deliveryArtifact;
                this.$version = string;
                this.$deliveryConfig = deliveryConfig;
                this.$environmentName = string2;
                super(0);
            }
        });
    }

    private final SelectConditionStep<Record1<String>> getUid(DeliveryArtifact $this$uid) {
        return this.getJooq$keel_sql().select((SelectField)Tables.DELIVERY_ARTIFACT.UID).from((TableLike)Tables.DELIVERY_ARTIFACT).where(Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME.eq((Object)$this$uid.getDeliveryConfigName())).and(Tables.DELIVERY_ARTIFACT.REFERENCE.eq((Object)$this$uid.getReference()));
    }

    public SqlDeliveryConfigRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull ResourceSpecIdentifier resourceSpecIdentifier, @NotNull ObjectMapper objectMapper, @NotNull SqlRetry sqlRetry, @NotNull List<? extends ArtifactSupplier<?, ?>> artifactSuppliers, @NotNull List<? extends SpecMigrator<?, ?>> specMigrators, @NotNull ApplicationEventPublisher publisher) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)resourceSpecIdentifier, (String)"resourceSpecIdentifier");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)sqlRetry, (String)"sqlRetry");
        Intrinsics.checkNotNullParameter(artifactSuppliers, (String)"artifactSuppliers");
        Intrinsics.checkNotNullParameter(specMigrators, (String)"specMigrators");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        super(jooq, clock, sqlRetry, objectMapper, resourceSpecIdentifier, artifactSuppliers, specMigrators);
        this.publisher = publisher;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SqlDeliveryConfigRepository this$0;

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
            {
                this.this$0 = sqlDeliveryConfigRepository;
                super(0);
            }
        }));
        this.RECHECK_LEASE_NAME = "recheck";
    }

    public /* synthetic */ SqlDeliveryConfigRepository(DSLContext dSLContext, Clock clock, ResourceSpecIdentifier resourceSpecIdentifier, ObjectMapper objectMapper, SqlRetry sqlRetry, List list, List list2, ApplicationEventPublisher applicationEventPublisher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(dSLContext, clock, resourceSpecIdentifier, objectMapper, sqlRetry, list, list2, applicationEventPublisher);
    }

    public static final /* synthetic */ Select access$envUid(SqlDeliveryConfigRepository $this, String deliveryConfigName, String environmentName) {
        return $this.envUid(deliveryConfigName, environmentName);
    }

    public static final /* synthetic */ Select access$getUids$p(SqlDeliveryConfigRepository $this, String $this$access_u24uids_u24p) {
        return $this.getUids($this$access_u24uids_u24p);
    }

    public static final /* synthetic */ List access$constraintStateForWithTransaction(SqlDeliveryConfigRepository $this, String deliveryConfigName, String environmentName, String artifactVersion, String artifactReference, DSLContext txn) {
        return $this.constraintStateForWithTransaction(deliveryConfigName, environmentName, artifactVersion, artifactReference, txn);
    }

    public static final /* synthetic */ String access$environmentUidByName(SqlDeliveryConfigRepository $this, String deliveryConfigName, String environmentName) {
        return $this.environmentUidByName(deliveryConfigName, environmentName);
    }

    public static final /* synthetic */ String access$getRECHECK_LEASE_NAME$p(SqlDeliveryConfigRepository $this) {
        return $this.RECHECK_LEASE_NAME;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getPublisher$p(SqlDeliveryConfigRepository $this) {
        return $this.publisher;
    }

    public static final /* synthetic */ SelectConditionStep access$getUid$p(SqlDeliveryConfigRepository $this, DeliveryArtifact $this$access_u24uid_u24p) {
        return $this.getUid($this$access_u24uid_u24p);
    }

    public static final /* synthetic */ Logger access$getLog$p(SqlDeliveryConfigRepository $this) {
        return $this.getLog();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/spinnaker/keel/sql/SqlDeliveryConfigRepository$Companion;", "", "()V", "DELETE_CHUNK_SIZE", "", "keel-sql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

