/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.persistence.metamodel.tables;

import com.netflix.spinnaker.jooq.LocalDateTimeToInstantConverter;
import com.netflix.spinnaker.keel.persistence.metamodel.Indexes;
import com.netflix.spinnaker.keel.persistence.metamodel.Keel;
import com.netflix.spinnaker.keel.persistence.metamodel.Keys;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.Environment;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.EnvironmentLeaseRecord;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row5;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class EnvironmentLease
extends TableImpl<EnvironmentLeaseRecord> {
    private static final long serialVersionUID = 532821426L;
    public static final EnvironmentLease ENVIRONMENT_LEASE = new EnvironmentLease();
    public final TableField<EnvironmentLeaseRecord, String> UID = EnvironmentLease.createField((Name)DSL.name((String)"uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentLeaseRecord, String> ENVIRONMENT_UID = EnvironmentLease.createField((Name)DSL.name((String)"environment_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentLeaseRecord, String> LEASED_BY = EnvironmentLease.createField((Name)DSL.name((String)"leased_by"), (DataType)SQLDataType.VARCHAR((int)63).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentLeaseRecord, Instant> LEASED_AT = EnvironmentLease.createField((Name)DSL.name((String)"leased_at"), (DataType)SQLDataType.LOCALDATETIME.nullable(false).defaultValue(DSL.field((String)"CURRENT_TIMESTAMP(3)", (DataType)SQLDataType.LOCALDATETIME)), (Table)this, (String)"", (Converter)new LocalDateTimeToInstantConverter());
    public final TableField<EnvironmentLeaseRecord, String> COMMENT = EnvironmentLease.createField((Name)DSL.name((String)"comment"), (DataType)SQLDataType.VARCHAR((int)511).nullable(false), (Table)this, (String)"");

    public Class<EnvironmentLeaseRecord> getRecordType() {
        return EnvironmentLeaseRecord.class;
    }

    public EnvironmentLease() {
        this(DSL.name((String)"environment_lease"), null);
    }

    public EnvironmentLease(String alias) {
        this(DSL.name((String)alias), (Table<EnvironmentLeaseRecord>)ENVIRONMENT_LEASE);
    }

    public EnvironmentLease(Name alias) {
        this(alias, (Table<EnvironmentLeaseRecord>)ENVIRONMENT_LEASE);
    }

    private EnvironmentLease(Name alias, Table<EnvironmentLeaseRecord> aliased) {
        this(alias, aliased, null);
    }

    private EnvironmentLease(Name alias, Table<EnvironmentLeaseRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public <O extends Record> EnvironmentLease(Table<O> child, ForeignKey<O, EnvironmentLeaseRecord> key) {
        super(child, key, (Table)ENVIRONMENT_LEASE);
    }

    public Schema getSchema() {
        return Keel.KEEL;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.ENVIRONMENT_LEASE_ENVIRONMENT_LEASE_ENVIRONMENT_UID_IDX);
    }

    public UniqueKey<EnvironmentLeaseRecord> getPrimaryKey() {
        return Keys.KEY_ENVIRONMENT_LEASE_PRIMARY;
    }

    public List<UniqueKey<EnvironmentLeaseRecord>> getKeys() {
        return Arrays.asList(Keys.KEY_ENVIRONMENT_LEASE_PRIMARY);
    }

    public List<ForeignKey<EnvironmentLeaseRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_ENVIRONMENT_LEASE_ENVIRONMENT_UID);
    }

    public Environment environment() {
        return new Environment(this, Keys.FK_ENVIRONMENT_LEASE_ENVIRONMENT_UID);
    }

    public EnvironmentLease as(String alias) {
        return new EnvironmentLease(DSL.name((String)alias), (Table<EnvironmentLeaseRecord>)this);
    }

    public EnvironmentLease as(Name alias) {
        return new EnvironmentLease(alias, (Table<EnvironmentLeaseRecord>)this);
    }

    public EnvironmentLease rename(String name) {
        return new EnvironmentLease(DSL.name((String)name), null);
    }

    public EnvironmentLease rename(Name name) {
        return new EnvironmentLease(name, null);
    }

    public Row5<String, String, String, Instant, String> fieldsRow() {
        return (Row5)super.fieldsRow();
    }
}

