/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.deploy.ops;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DeregisterTargetsResult;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetGroupsResult;
import com.amazonaws.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.RegisterTargetsResult;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetDescription;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetGroup;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.Environment;
import com.amazonaws.services.lambda.model.ListTagsRequest;
import com.amazonaws.services.lambda.model.ListTagsResult;
import com.amazonaws.services.lambda.model.TagResourceRequest;
import com.amazonaws.services.lambda.model.UntagResourceRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationResult;
import com.amazonaws.services.lambda.model.VpcConfig;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.lambda.cache.model.LambdaFunction;
import com.netflix.spinnaker.clouddriver.lambda.deploy.description.CreateLambdaFunctionConfigurationDescription;
import com.netflix.spinnaker.clouddriver.lambda.deploy.ops.AbstractLambdaAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class UpdateLambdaConfigurationAtomicOperation
extends AbstractLambdaAtomicOperation<CreateLambdaFunctionConfigurationDescription, UpdateFunctionConfigurationResult>
implements AtomicOperation<UpdateFunctionConfigurationResult> {
    public UpdateLambdaConfigurationAtomicOperation(CreateLambdaFunctionConfigurationDescription description) {
        super(description, "UPDATE_LAMBDA_FUNCTION_CONFIGURATION");
    }

    public UpdateFunctionConfigurationResult operate(List priorOutputs) {
        this.updateTaskStatus("Initializing Updating of AWS Lambda Function Configuration Operation...");
        return this.updateFunctionConfigurationResult();
    }

    private UpdateFunctionConfigurationResult updateFunctionConfigurationResult() {
        UpdateFunctionConfigurationResult result;
        block12: {
            AmazonElasticLoadBalancing loadBalancingV2;
            LambdaFunction cache;
            block11: {
                cache = (LambdaFunction)this.lambdaFunctionProvider.getFunction(((CreateLambdaFunctionConfigurationDescription)this.description).getAccount(), ((CreateLambdaFunctionConfigurationDescription)this.description).getRegion(), ((CreateLambdaFunctionConfigurationDescription)this.description).getFunctionName());
                AWSLambda client = this.getLambdaClient();
                UpdateFunctionConfigurationRequest request = new UpdateFunctionConfigurationRequest().withFunctionName(cache.getFunctionArn()).withDescription(((CreateLambdaFunctionConfigurationDescription)this.description).getDescription()).withHandler(((CreateLambdaFunctionConfigurationDescription)this.description).getHandler()).withMemorySize(((CreateLambdaFunctionConfigurationDescription)this.description).getMemorySize()).withRole(((CreateLambdaFunctionConfigurationDescription)this.description).getRole()).withTimeout(((CreateLambdaFunctionConfigurationDescription)this.description).getTimeout()).withDeadLetterConfig(((CreateLambdaFunctionConfigurationDescription)this.description).getDeadLetterConfig()).withLayers(((CreateLambdaFunctionConfigurationDescription)this.description).getLayers()).withVpcConfig(new VpcConfig().withSecurityGroupIds(((CreateLambdaFunctionConfigurationDescription)this.description).getSecurityGroupIds()).withSubnetIds(((CreateLambdaFunctionConfigurationDescription)this.description).getSubnetIds())).withKMSKeyArn(((CreateLambdaFunctionConfigurationDescription)this.description).getKmskeyArn()).withTracingConfig(((CreateLambdaFunctionConfigurationDescription)this.description).getTracingConfig()).withRuntime(((CreateLambdaFunctionConfigurationDescription)this.description).getRuntime());
                if (null != ((CreateLambdaFunctionConfigurationDescription)this.description).getEnvVariables()) {
                    request.setEnvironment(new Environment().withVariables(((CreateLambdaFunctionConfigurationDescription)this.description).getEnvVariables()));
                }
                result = client.updateFunctionConfiguration(request);
                TagResourceRequest tagResourceRequest = new TagResourceRequest();
                HashMap<String, String> objTag = new HashMap<String, String>();
                if (null != ((CreateLambdaFunctionConfigurationDescription)this.description).getTags()) {
                    for (Map.Entry<String, String> entry : ((CreateLambdaFunctionConfigurationDescription)this.description).getTags().entrySet()) {
                        objTag.put(entry.getKey(), entry.getValue());
                    }
                }
                if (!objTag.isEmpty()) {
                    UntagResourceRequest untagResourceRequest = new UntagResourceRequest().withResource(result.getFunctionArn());
                    ListTagsResult existingTags = client.listTags(new ListTagsRequest().withResource(result.getFunctionArn()));
                    for (Map.Entry entry : existingTags.getTags().entrySet()) {
                        untagResourceRequest.getTagKeys().add((String)entry.getKey());
                    }
                    if (!untagResourceRequest.getTagKeys().isEmpty()) {
                        client.untagResource(untagResourceRequest);
                    }
                    for (Map.Entry entry : objTag.entrySet()) {
                        tagResourceRequest.addTagsEntry((String)entry.getKey(), (String)entry.getValue());
                    }
                    tagResourceRequest.setResource(result.getFunctionArn());
                    client.tagResource(tagResourceRequest);
                }
                this.updateTaskStatus("Finished Updating of AWS Lambda Function Configuration Operation...");
                if (!StringUtils.isEmpty((Object)((CreateLambdaFunctionConfigurationDescription)this.description).getTargetGroups())) break block11;
                if (cache.getTargetGroups() == null || cache.getTargetGroups().isEmpty()) break block12;
                loadBalancingV2 = this.getAmazonElasticLoadBalancingClient();
                for (String groupName : cache.getTargetGroups()) {
                    this.deregisterTarget(loadBalancingV2, cache.getFunctionArn(), this.retrieveTargetGroup(loadBalancingV2, groupName).getTargetGroupArn());
                    this.updateTaskStatus("De-registered the target group...");
                }
                break block12;
            }
            loadBalancingV2 = this.getAmazonElasticLoadBalancingClient();
            if (cache.getTargetGroups().isEmpty()) {
                this.registerTarget(loadBalancingV2, cache.getFunctionArn(), this.retrieveTargetGroup(loadBalancingV2, ((CreateLambdaFunctionConfigurationDescription)this.description).getTargetGroups()).getTargetGroupArn());
                this.updateTaskStatus("Registered the target group...");
            } else {
                for (String groupName : cache.getTargetGroups()) {
                    if (groupName.equals(((CreateLambdaFunctionConfigurationDescription)this.description).getTargetGroups())) continue;
                    this.registerTarget(loadBalancingV2, cache.getFunctionArn(), this.retrieveTargetGroup(loadBalancingV2, ((CreateLambdaFunctionConfigurationDescription)this.description).getTargetGroups()).getTargetGroupArn());
                    this.updateTaskStatus("Registered the target group...");
                }
            }
        }
        return result;
    }

    private TargetGroup retrieveTargetGroup(AmazonElasticLoadBalancing loadBalancingV2, String targetGroupName) {
        DescribeTargetGroupsRequest request = new DescribeTargetGroupsRequest().withNames(new String[]{targetGroupName});
        DescribeTargetGroupsResult describeTargetGroupsResult = loadBalancingV2.describeTargetGroups(request);
        if (describeTargetGroupsResult.getTargetGroups().size() == 1) {
            return (TargetGroup)describeTargetGroupsResult.getTargetGroups().get(0);
        }
        if (describeTargetGroupsResult.getTargetGroups().size() > 1) {
            throw new IllegalArgumentException("There are multiple target groups with the name " + targetGroupName + ".");
        }
        throw new IllegalArgumentException("There is no target group with the name " + targetGroupName + ".");
    }

    private AmazonElasticLoadBalancing getAmazonElasticLoadBalancingClient() {
        AWSCredentialsProvider credentialsProvider = this.getCredentials().getCredentialsProvider();
        NetflixAmazonCredentials credentialAccount = ((CreateLambdaFunctionConfigurationDescription)this.description).getCredentials();
        return this.amazonClientProvider.getAmazonElasticLoadBalancingV2(credentialAccount, this.getRegion(), false);
    }

    private void registerTarget(AmazonElasticLoadBalancing loadBalancingV2, String functionArn, String targetGroupArn) {
        RegisterTargetsResult result = loadBalancingV2.registerTargets(new RegisterTargetsRequest().withTargets(new TargetDescription[]{new TargetDescription().withId(functionArn)}).withTargetGroupArn(targetGroupArn));
    }

    private void deregisterTarget(AmazonElasticLoadBalancing loadBalancingV2, String functionArn, String targetGroupArn) {
        DeregisterTargetsResult result = loadBalancingV2.deregisterTargets(new DeregisterTargetsRequest().withTargetGroupArn(targetGroupArn).withTargets(new TargetDescription[]{new TargetDescription().withId(functionArn)}));
    }
}

