/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.deploy.ops;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetGroupsResult;
import com.amazonaws.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.RegisterTargetsResult;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetDescription;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetGroup;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.AddPermissionRequest;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.CreateFunctionResult;
import com.amazonaws.services.lambda.model.Environment;
import com.amazonaws.services.lambda.model.FunctionCode;
import com.amazonaws.services.lambda.model.VpcConfig;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.lambda.deploy.description.CreateLambdaFunctionDescription;
import com.netflix.spinnaker.clouddriver.lambda.deploy.ops.AbstractLambdaAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CreateLambdaAtomicOperation
extends AbstractLambdaAtomicOperation<CreateLambdaFunctionDescription, CreateFunctionResult>
implements AtomicOperation<CreateFunctionResult> {
    public CreateLambdaAtomicOperation(CreateLambdaFunctionDescription description) {
        super(description, "CREATE_LAMBDA_FUNCTION");
    }

    public CreateFunctionResult operate(List priorOutputs) {
        this.updateTaskStatus("Initializing Creation of AWS Lambda Function Operation...");
        return this.createFunction();
    }

    private CreateFunctionResult createFunction() {
        FunctionCode code = new FunctionCode().withS3Bucket(((CreateLambdaFunctionDescription)this.description).getProperty("s3bucket").toString()).withS3Key(((CreateLambdaFunctionDescription)this.description).getProperty("s3key").toString());
        HashMap<String, String> objTag = new HashMap<String, String>();
        if (null != ((CreateLambdaFunctionDescription)this.description).getTags()) {
            for (Map.Entry<String, String> entry : ((CreateLambdaFunctionDescription)this.description).getTags().entrySet()) {
                objTag.put(entry.getKey(), entry.getValue());
            }
        }
        AWSLambda client = this.getLambdaClient();
        CreateFunctionRequest request = new CreateFunctionRequest();
        request.setFunctionName(this.combineAppDetail(((CreateLambdaFunctionDescription)this.description).getAppName(), ((CreateLambdaFunctionDescription)this.description).getFunctionName()));
        request.setDescription(((CreateLambdaFunctionDescription)this.description).getDescription());
        request.setHandler(((CreateLambdaFunctionDescription)this.description).getHandler());
        request.setMemorySize(((CreateLambdaFunctionDescription)this.description).getMemorySize());
        request.setPublish(((CreateLambdaFunctionDescription)this.description).getPublish());
        request.setRole(((CreateLambdaFunctionDescription)this.description).getRole());
        request.setRuntime(((CreateLambdaFunctionDescription)this.description).getRuntime());
        request.setTimeout(((CreateLambdaFunctionDescription)this.description).getTimeout());
        request.setLayers(((CreateLambdaFunctionDescription)this.description).getLayers());
        request.setCode(code);
        request.setTags(objTag);
        Map<String, String> envVariables = ((CreateLambdaFunctionDescription)this.description).getEnvVariables();
        if (null != envVariables) {
            request.setEnvironment(new Environment().withVariables(envVariables));
        }
        if (null != ((CreateLambdaFunctionDescription)this.description).getSecurityGroupIds() || null != ((CreateLambdaFunctionDescription)this.description).getSubnetIds()) {
            request.setVpcConfig(new VpcConfig().withSecurityGroupIds(((CreateLambdaFunctionDescription)this.description).getSecurityGroupIds()).withSubnetIds(((CreateLambdaFunctionDescription)this.description).getSubnetIds()));
        }
        if (!((CreateLambdaFunctionDescription)this.description).getDeadLetterConfig().getTargetArn().isEmpty()) {
            request.setDeadLetterConfig(((CreateLambdaFunctionDescription)this.description).getDeadLetterConfig());
        }
        request.setKMSKeyArn(((CreateLambdaFunctionDescription)this.description).getKmskeyArn());
        request.setTracingConfig(((CreateLambdaFunctionDescription)this.description).getTracingConfig());
        CreateFunctionResult result = client.createFunction(request);
        this.updateTaskStatus("Finished Creation of AWS Lambda Function Operation...");
        if (((CreateLambdaFunctionDescription)this.description).getTargetGroups() != null && !((CreateLambdaFunctionDescription)this.description).getTargetGroups().isEmpty()) {
            this.updateTaskStatus(String.format("Started registering lambda to targetGroup (%s)", ((CreateLambdaFunctionDescription)this.description).getTargetGroups()));
            String functionArn = result.getFunctionArn();
            this.registerTargetGroup(functionArn, client);
        }
        return result;
    }

    protected String combineAppDetail(String appName, String functionName) {
        Names functionAppName = Names.parseName((String)functionName);
        if (null != functionAppName) {
            return functionAppName.getApp().equals(appName) ? functionName : appName + "-" + functionName;
        }
        throw new IllegalArgumentException(String.format("Function name {%s} contains invlaid charachetrs ", functionName));
    }

    private RegisterTargetsResult registerTargetGroup(String functionArn, AWSLambda lambdaClient) {
        AmazonElasticLoadBalancing loadBalancingV2 = this.getAmazonElasticLoadBalancingClient();
        TargetGroup targetGroup = this.retrieveTargetGroup(loadBalancingV2);
        AddPermissionRequest addPermissionRequest = new AddPermissionRequest().withFunctionName(functionArn).withAction("lambda:InvokeFunction").withSourceArn(targetGroup.getTargetGroupArn()).withPrincipal("elasticloadbalancing.amazonaws.com").withStatementId(UUID.randomUUID().toString());
        lambdaClient.addPermission(addPermissionRequest);
        this.updateTaskStatus(String.format("Lambda (%s) invoke permissions added to Target group (%s).", functionArn, targetGroup.getTargetGroupArn()));
        RegisterTargetsResult result = loadBalancingV2.registerTargets(new RegisterTargetsRequest().withTargets(new TargetDescription[]{new TargetDescription().withId(functionArn)}).withTargetGroupArn(targetGroup.getTargetGroupArn()));
        this.updateTaskStatus(String.format("Registered the Lambda (%s) with Target group (%s).", functionArn, targetGroup.getTargetGroupArn()));
        return result;
    }

    private TargetGroup retrieveTargetGroup(AmazonElasticLoadBalancing loadBalancingV2) {
        DescribeTargetGroupsRequest request = new DescribeTargetGroupsRequest().withNames(new String[]{((CreateLambdaFunctionDescription)this.description).getTargetGroups()});
        DescribeTargetGroupsResult describeTargetGroupsResult = loadBalancingV2.describeTargetGroups(request);
        if (describeTargetGroupsResult.getTargetGroups().size() == 1) {
            return (TargetGroup)describeTargetGroupsResult.getTargetGroups().get(0);
        }
        if (describeTargetGroupsResult.getTargetGroups().size() > 1) {
            throw new IllegalArgumentException("There are multiple target groups with the name " + ((CreateLambdaFunctionDescription)this.description).getTargetGroups() + ".");
        }
        throw new IllegalArgumentException("There is no target group with the name " + ((CreateLambdaFunctionDescription)this.description).getTargetGroups() + ".");
    }

    private AmazonElasticLoadBalancing getAmazonElasticLoadBalancingClient() {
        AWSCredentialsProvider credentialsProvider = this.getCredentials().getCredentialsProvider();
        NetflixAmazonCredentials credentialAccount = ((CreateLambdaFunctionDescription)this.description).getCredentials();
        return this.amazonClientProvider.getAmazonElasticLoadBalancingV2(credentialAccount, this.getRegion(), false);
    }
}

