/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.cache.client;

import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;

abstract class AbstractCacheClient<T> {
    private final String keyNamespace;
    protected final Cache cacheView;

    AbstractCacheClient(Cache cacheView, String keyNamespace) {
        this.cacheView = cacheView;
        this.keyNamespace = keyNamespace;
    }

    protected abstract T convert(CacheData var1);

    public Collection<T> getAll() {
        Collection allData = this.cacheView.getAll(this.keyNamespace);
        return this.convertAll(allData);
    }

    public Collection<T> getAll(String account, String region) {
        Collection<CacheData> data = this.fetchFromCache(account, region);
        return this.convertAll(data);
    }

    public T get(String key) {
        CacheData cacheData = this.cacheView.get(this.keyNamespace, key);
        if (cacheData != null) {
            return this.convert(cacheData);
        }
        return null;
    }

    private Collection<T> convertAll(Collection<CacheData> cacheData) {
        return cacheData.stream().map(this::convert).collect(Collectors.toList());
    }

    private Collection<CacheData> fetchFromCache(String account, String region) {
        Object accountFilter = account != null ? account + ":" : "*:";
        Object regionFilter = region != null ? region + ":" : "*:";
        HashSet keys = new HashSet();
        String pattern = "aws:" + this.keyNamespace + ":" + (String)accountFilter + (String)regionFilter + "*";
        Collection nameMatches = this.cacheView.filterIdentifiers(this.keyNamespace, pattern);
        keys.addAll(nameMatches);
        Collection allData = this.cacheView.getAll(this.keyNamespace, keys);
        if (allData == null) {
            return Collections.emptyList();
        }
        return allData;
    }
}

