/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import io.specto.hoverfly.junit.core.model.DelaySettings;
import io.specto.hoverfly.junit.core.model.Request;
import io.specto.hoverfly.junit.core.model.RequestFieldMatcher;
import io.specto.hoverfly.junit.core.model.RequestResponsePair;
import io.specto.hoverfly.junit.dsl.RequestMatcherBuilder;
import io.specto.hoverfly.junit.dsl.ResponseBuilder;
import io.specto.hoverfly.junit.dsl.StubServiceDelaySettingsBuilder;
import io.specto.hoverfly.junit.dsl.matchers.HoverflyMatchers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class StubServiceBuilder {
    private final Set<RequestResponsePair> requestResponsePairs = new LinkedHashSet<RequestResponsePair>();
    private final List<DelaySettings> delaySettings = new ArrayList<DelaySettings>();
    private static final String SEPARATOR = "://";
    protected final List<RequestFieldMatcher<String>> destination;
    protected List<RequestFieldMatcher<String>> scheme;

    public RequestMatcherBuilder get(String path) {
        return this.get(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder get(RequestFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.GET, path);
    }

    public RequestMatcherBuilder delete(String path) {
        return this.delete(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder delete(RequestFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.DELETE, path);
    }

    public RequestMatcherBuilder put(String path) {
        return this.put(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder put(RequestFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.PUT, path);
    }

    public RequestMatcherBuilder post(String path) {
        return this.post(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder post(RequestFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.POST, path);
    }

    public RequestMatcherBuilder patch(String path) {
        return this.patch(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder patch(RequestFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.PATCH, path);
    }

    public RequestMatcherBuilder options(String path) {
        return this.options(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder options(RequestFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.OPTIONS, path);
    }

    public RequestMatcherBuilder head(String path) {
        return this.head(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder head(RequestFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.HEAD, path);
    }

    public RequestMatcherBuilder connect(String path) {
        return this.connect(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder connect(RequestFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.CONNECT, path);
    }

    public RequestMatcherBuilder anyMethod(String path) {
        return this.anyMethod(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder anyMethod(RequestFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.ANY, path);
    }

    StubServiceBuilder(String baseUrl) {
        String[] elements = baseUrl.split(SEPARATOR);
        if (baseUrl.contains(SEPARATOR)) {
            this.scheme = Collections.singletonList(RequestFieldMatcher.newExactMatcher(elements[0]));
            this.destination = Collections.singletonList(RequestFieldMatcher.newExactMatcher(elements[1]));
        } else {
            this.destination = Collections.singletonList(RequestFieldMatcher.newExactMatcher(elements[0]));
        }
    }

    StubServiceBuilder(RequestFieldMatcher matcher) {
        this.destination = Collections.singletonList(matcher);
    }

    public Set<RequestResponsePair> getRequestResponsePairs() {
        return Collections.unmodifiableSet(this.requestResponsePairs);
    }

    StubServiceBuilder addRequestResponsePair(RequestResponsePair requestResponsePair) {
        this.requestResponsePairs.add(requestResponsePair);
        return this;
    }

    public StubServiceDelaySettingsBuilder andDelay(int delay, TimeUnit delayTimeUnit) {
        return new StubServiceDelaySettingsBuilder(delay, delayTimeUnit, this);
    }

    public List<DelaySettings> getDelaySettings() {
        return Collections.unmodifiableList(this.delaySettings);
    }

    void addDelaySetting(DelaySettings delaySettings) {
        if (delaySettings != null) {
            this.delaySettings.add(delaySettings);
        }
    }

    StubServiceBuilder addDelaySetting(Request request, ResponseBuilder responseBuilder) {
        responseBuilder.addDelay().to(this).forRequest(request);
        return this;
    }

    private RequestMatcherBuilder createRequestMatcherBuilder(HttpMethod httpMethod, RequestFieldMatcher<String> path) {
        return new RequestMatcherBuilder(this, httpMethod, this.scheme, this.destination, Collections.singletonList(path));
    }

    static enum HttpMethod {
        GET,
        PUT,
        POST,
        DELETE,
        PATCH,
        OPTIONS,
        CONNECT,
        HEAD,
        ANY;


        List<RequestFieldMatcher<String>> getRequestFieldMatcher() {
            List<RequestFieldMatcher<String>> matchers = null;
            if (this != ANY) {
                matchers = Collections.singletonList(RequestFieldMatcher.newExactMatcher(this.name()));
            }
            return matchers;
        }
    }
}

