/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import io.specto.hoverfly.junit.core.model.LogNormalDelay;
import io.specto.hoverfly.junit.core.model.Response;
import io.specto.hoverfly.junit.dsl.HttpBodyConverter;
import io.specto.hoverfly.junit.dsl.ResponseDelaySettingsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ResponseBuilder {
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private String body = "";
    private boolean encodedBody = false;
    private int status = 200;
    private boolean templated = true;
    private final Map<String, String> transitionsState = new HashMap<String, String>();
    private final List<String> removesState = new ArrayList<String>();
    private int fixedDelay;
    private LogNormalDelay logNormalDelay;
    private int delay;
    private TimeUnit delayTimeUnit;

    ResponseBuilder() {
    }

    @Deprecated
    public static ResponseBuilder response() {
        return new ResponseBuilder();
    }

    public ResponseBuilder body(String body) {
        this.body = body;
        return this;
    }

    public ResponseBuilder status(int status) {
        this.status = status;
        return this;
    }

    public ResponseBuilder header(String key, String value) {
        this.headers.put(key, Collections.singletonList(value));
        return this;
    }

    public ResponseBuilder andSetState(String key, String value) {
        this.transitionsState.put(key, value);
        return this;
    }

    public ResponseBuilder andRemoveState(String stateToRemove) {
        this.removesState.add(stateToRemove);
        return this;
    }

    Response build() {
        return new Response(this.status, this.body, this.encodedBody, this.templated, this.headers, this.transitionsState, this.removesState, this.fixedDelay, this.logNormalDelay, null);
    }

    public ResponseBuilder body(HttpBodyConverter httpBodyConverter) {
        this.body = httpBodyConverter.body();
        this.header("Content-Type", httpBodyConverter.contentType());
        return this;
    }

    public ResponseBuilder disableTemplating() {
        this.templated = false;
        return this;
    }

    public ResponseBuilder binaryEncoding() {
        this.encodedBody = true;
        return this;
    }

    public ResponseBuilder withFixedDelay(int delay, TimeUnit delayTimeUnit) {
        this.fixedDelay = (int)delayTimeUnit.toMillis(delay);
        return this;
    }

    public ResponseBuilder withLogNormalDelay(int mean, int median, TimeUnit delayTimeUnit) {
        this.logNormalDelay = new LogNormalDelay(0, 0, (int)delayTimeUnit.toMillis(mean), (int)delayTimeUnit.toMillis(median));
        return this;
    }

    public ResponseBuilder withLogNormalDelay(int mean, int median, int min, int max, TimeUnit delayTimeUnit) {
        this.logNormalDelay = new LogNormalDelay((int)delayTimeUnit.toMillis(min), (int)delayTimeUnit.toMillis(max), (int)delayTimeUnit.toMillis(mean), (int)delayTimeUnit.toMillis(median));
        return this;
    }

    @Deprecated
    public ResponseBuilder withDelay(int delay, TimeUnit delayTimeUnit) {
        this.delay = delay;
        this.delayTimeUnit = delayTimeUnit;
        return this;
    }

    ResponseDelaySettingsBuilder addDelay() {
        return new ResponseDelaySettingsBuilder(this.delay, this.delayTimeUnit);
    }
}

