/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import io.specto.hoverfly.junit.api.HoverflyClient;
import io.specto.hoverfly.junit.api.HoverflyClientException;
import io.specto.hoverfly.junit.api.model.ModeArguments;
import io.specto.hoverfly.junit.api.view.DiffView;
import io.specto.hoverfly.junit.api.view.HoverflyInfoView;
import io.specto.hoverfly.junit.api.view.StateView;
import io.specto.hoverfly.junit.core.HoverflyConfig;
import io.specto.hoverfly.junit.core.HoverflyMode;
import io.specto.hoverfly.junit.core.HoverflyUtils;
import io.specto.hoverfly.junit.core.LoggingOutputStream;
import io.specto.hoverfly.junit.core.ObjectMapperFactory;
import io.specto.hoverfly.junit.core.ProxyConfigurer;
import io.specto.hoverfly.junit.core.SimulationPreprocessor;
import io.specto.hoverfly.junit.core.SimulationSource;
import io.specto.hoverfly.junit.core.SslConfigurer;
import io.specto.hoverfly.junit.core.SystemConfig;
import io.specto.hoverfly.junit.core.SystemConfigFactory;
import io.specto.hoverfly.junit.core.TempFileManager;
import io.specto.hoverfly.junit.core.config.HoverflyConfiguration;
import io.specto.hoverfly.junit.core.model.Journal;
import io.specto.hoverfly.junit.core.model.Request;
import io.specto.hoverfly.junit.core.model.RequestResponsePair;
import io.specto.hoverfly.junit.core.model.Simulation;
import io.specto.hoverfly.junit.dsl.RequestMatcherBuilder;
import io.specto.hoverfly.junit.dsl.StubServiceBuilder;
import io.specto.hoverfly.junit.dsl.matchers.HoverflyMatchers;
import io.specto.hoverfly.junit.verification.HoverflyDiffAssertionError;
import io.specto.hoverfly.junit.verification.HoverflyVerifications;
import io.specto.hoverfly.junit.verification.VerificationCriteria;
import io.specto.hoverfly.junit.verification.VerificationData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;

public class Hoverfly
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Hoverfly.class);
    private static final int BOOT_TIMEOUT_SECONDS = 10;
    private static final int RETRY_BACKOFF_INTERVAL_MS = 100;
    private final HoverflyConfiguration hoverflyConfig;
    private final HoverflyMode hoverflyMode;
    private final ProxyConfigurer proxyConfigurer;
    private final SslConfigurer sslConfigurer = new SslConfigurer();
    private final HoverflyClient hoverflyClient;
    private final TempFileManager tempFileManager = new TempFileManager();
    private StartedProcess startedProcess;
    Thread shutdownThread = null;

    public Hoverfly(HoverflyConfig hoverflyConfigBuilder, HoverflyMode hoverflyMode) {
        this.hoverflyConfig = hoverflyConfigBuilder.build();
        this.proxyConfigurer = new ProxyConfigurer(this.hoverflyConfig);
        this.hoverflyClient = HoverflyClient.custom().scheme(this.hoverflyConfig.getScheme()).host(this.hoverflyConfig.getHost()).port(this.hoverflyConfig.getAdminPort()).withAuthToken().build();
        this.hoverflyMode = hoverflyMode;
    }

    public Hoverfly(HoverflyMode hoverflyMode) {
        this(HoverflyConfig.localConfigs(), hoverflyMode);
    }

    public void start() {
        this.shutdownThread = new Thread(this::close);
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        if (this.startedProcess != null) {
            LOGGER.warn("Local Hoverfly is already running.");
            return;
        }
        if (!this.hoverflyConfig.isRemoteInstance()) {
            this.startHoverflyProcess();
        } else {
            this.resetJournal();
        }
        this.waitForHoverflyToBecomeHealthy();
        LOGGER.info("A {} Hoverfly with version {} is ready", (Object)(this.hoverflyConfig.isRemoteInstance() ? "remote" : "local"), (Object)this.hoverflyClient.getConfigInfo().getVersion());
        this.setModeWithArguments(this.hoverflyMode, this.hoverflyConfig);
        if (StringUtils.isNotBlank((CharSequence)this.hoverflyConfig.getDestination())) {
            this.setDestination(this.hoverflyConfig.getDestination());
        }
        if (this.hoverflyConfig.getProxyCaCertificate().isPresent()) {
            this.sslConfigurer.setDefaultSslContext(this.hoverflyConfig.getProxyCaCertificate().get());
        } else if (StringUtils.isNotBlank((CharSequence)this.hoverflyConfig.getSslCertificatePath())) {
            this.sslConfigurer.setDefaultSslContext(this.hoverflyConfig.getSslCertificatePath());
        } else {
            this.sslConfigurer.setDefaultSslContext();
        }
        this.proxyConfigurer.setProxySystemProperties();
    }

    private void startHoverflyProcess() {
        HoverflyUtils.checkPortInUse(this.hoverflyConfig.getProxyPort());
        HoverflyUtils.checkPortInUse(this.hoverflyConfig.getAdminPort());
        SystemConfig systemConfig = new SystemConfigFactory(this.hoverflyConfig).createSystemConfig();
        if (this.hoverflyConfig.getBinaryLocation() != null) {
            this.tempFileManager.setBinaryLocation(this.hoverflyConfig.getBinaryLocation());
        }
        Path binaryPath = this.tempFileManager.copyHoverflyBinary(systemConfig);
        LOGGER.info("Executing binary at {}", (Object)binaryPath);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(binaryPath.toString());
        if (!this.hoverflyConfig.getCommands().isEmpty()) {
            commands.addAll(this.hoverflyConfig.getCommands());
        }
        commands.add("-pp");
        commands.add(String.valueOf(this.hoverflyConfig.getProxyPort()));
        commands.add("-ap");
        commands.add(String.valueOf(this.hoverflyConfig.getAdminPort()));
        if (StringUtils.isNotBlank((CharSequence)this.hoverflyConfig.getSslCertificatePath())) {
            this.tempFileManager.copyClassPathResource(this.hoverflyConfig.getSslCertificatePath(), "ca.crt");
            commands.add("-cert");
            commands.add("ca.crt");
        }
        if (StringUtils.isNotBlank((CharSequence)this.hoverflyConfig.getSslKeyPath())) {
            this.tempFileManager.copyClassPathResource(this.hoverflyConfig.getSslKeyPath(), "ca.key");
            commands.add("-key");
            commands.add("ca.key");
        }
        if (this.hoverflyConfig.isClientAuthEnabled()) {
            this.tempFileManager.copyClassPathResource(this.hoverflyConfig.getClientCertPath(), "client-auth.crt");
            this.tempFileManager.copyClassPathResource(this.hoverflyConfig.getClientKeyPath(), "client-auth.key");
            commands.add("-client-authentication-client-cert");
            commands.add("client-auth.crt");
            commands.add("-client-authentication-client-key");
            commands.add("client-auth.key");
            commands.add("-client-authentication-destination");
            commands.add(this.hoverflyConfig.getClientAuthDestination());
            if (StringUtils.isNotBlank((CharSequence)this.hoverflyConfig.getClientCaCertPath())) {
                this.tempFileManager.copyClassPathResource(this.hoverflyConfig.getClientCaCertPath(), "client-ca.crt");
                commands.add("-client-authentication-ca-cert");
                commands.add("client-ca.crt");
            }
        }
        if (this.hoverflyConfig.isPlainHttpTunneling()) {
            commands.add("-plain-http-tunneling");
        }
        if (this.hoverflyConfig.isWebServer()) {
            commands.add("-webserver");
        }
        if (this.hoverflyConfig.isTlsVerificationDisabled()) {
            commands.add("-tls-verification=false");
        }
        if (this.hoverflyConfig.getHoverflyLogger().isPresent()) {
            commands.add("-logs");
            commands.add("json");
        }
        if (this.hoverflyConfig.getLogLevel().isPresent()) {
            commands.add("-log-level");
            commands.add(this.hoverflyConfig.getLogLevel().get().name().toLowerCase());
        }
        if (this.hoverflyConfig.isMiddlewareEnabled()) {
            String path = this.hoverflyConfig.getLocalMiddleware().getPath();
            String scriptName = path.contains(File.separator) ? path.substring(path.lastIndexOf(File.separator) + 1) : path;
            this.tempFileManager.copyClassPathResource(path, scriptName);
            commands.add("-middleware");
            commands.add(this.hoverflyConfig.getLocalMiddleware().getBinary() + " " + scriptName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.hoverflyConfig.getUpstreamProxy())) {
            commands.add("-upstream-proxy");
            commands.add(this.hoverflyConfig.getUpstreamProxy());
        }
        if (StringUtils.isNotBlank((CharSequence)this.hoverflyConfig.getResponseBodyFilesPath())) {
            commands.add("-response-body-files-path");
            commands.add(this.hoverflyConfig.getResponseBodyFilesPath());
        }
        try {
            this.startedProcess = new ProcessExecutor().command(commands).redirectOutput(this.hoverflyConfig.getHoverflyLogger().map(LoggingOutputStream::new).orElse(System.out)).directory(this.tempFileManager.getTempDirectory().toFile()).start();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not start Hoverfly process", e);
        }
    }

    @Override
    public void close() {
        this.cleanUp();
    }

    @Deprecated
    public void importSimulation(SimulationSource simulationSource) {
        this.simulate(simulationSource, new SimulationSource[0]);
    }

    public void simulate(SimulationSource simulationSource, SimulationSource ... sources) {
        LOGGER.info("Importing simulation data to Hoverfly");
        Optional<SimulationPreprocessor> simulationPreprocessor = this.hoverflyConfig.getSimulationPreprocessor();
        if (sources.length > 0 || simulationPreprocessor.isPresent()) {
            Simulation simulation = HoverflyUtils.readSimulationFromString(simulationSource.getSimulation());
            Stream.of(sources).map(SimulationSource::getSimulation).map(HoverflyUtils::readSimulationFromString).forEach(s -> {
                simulation.getHoverflyData().getPairs().addAll(s.getHoverflyData().getPairs());
                simulation.getHoverflyData().getGlobalActions().getDelays().addAll(s.getHoverflyData().getGlobalActions().getDelays());
            });
            simulationPreprocessor.ifPresent(p -> p.accept(simulation));
            this.hoverflyClient.setSimulation(simulation);
        } else {
            String simulation = simulationSource.getSimulation();
            this.hoverflyClient.setSimulation(simulation);
        }
    }

    public void reset() {
        this.hoverflyClient.deleteSimulation();
        this.resetJournal();
        this.resetState();
    }

    public void resetJournal() {
        try {
            this.hoverflyClient.deleteJournal();
        }
        catch (HoverflyClientException e) {
            LOGGER.warn("Older version of Hoverfly may not have a reset journal API", (Throwable)e);
        }
    }

    public void resetState() {
        try {
            this.hoverflyClient.deleteState();
        }
        catch (HoverflyClientException e) {
            LOGGER.warn("Older version of Hoverfly may not have a delete state API", (Throwable)e);
        }
    }

    public Map<String, String> getState() {
        try {
            StateView stateView = this.hoverflyClient.getState();
            if (stateView == null) {
                return Collections.emptyMap();
            }
            return stateView.getState();
        }
        catch (HoverflyClientException e) {
            LOGGER.warn("Older version of Hoverfly may not have a get state API", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public void setState(Map<String, String> state) {
        try {
            this.hoverflyClient.setState(new StateView(state));
        }
        catch (HoverflyClientException e) {
            LOGGER.warn("Older version of Hoverfly may not have a set state API", (Throwable)e);
        }
    }

    public void updateState(Map<String, String> state) {
        try {
            this.hoverflyClient.updateState(new StateView(state));
        }
        catch (HoverflyClientException e) {
            LOGGER.warn("Older version of Hoverfly may not have a update state API", (Throwable)e);
        }
    }

    public void resetDiffs() {
        try {
            this.hoverflyClient.cleanDiffs();
        }
        catch (HoverflyClientException e) {
            LOGGER.warn("Older version of Hoverfly may not have a delete diffs API", (Throwable)e);
        }
    }

    public void exportSimulation(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("Export path cannot be null.");
        }
        LOGGER.info("Exporting simulation data from Hoverfly");
        try {
            Files.deleteIfExists(path);
            Simulation simulation = this.hoverflyClient.getSimulation();
            this.persistSimulation(path, simulation);
        }
        catch (Exception e) {
            LOGGER.error("Failed to export simulation data", (Throwable)e);
        }
    }

    public Simulation getSimulation() {
        return this.hoverflyClient.getSimulation();
    }

    public HoverflyInfoView getHoverflyInfo() {
        return this.hoverflyClient.getConfigInfo();
    }

    public void setDestination(String destination) {
        this.hoverflyClient.setDestination(destination);
    }

    public void setMode(HoverflyMode mode) {
        this.hoverflyClient.setMode(mode);
    }

    public void resetMode(HoverflyMode mode) {
        this.setModeWithArguments(mode, this.hoverflyConfig);
    }

    public HoverflyConfiguration getHoverflyConfig() {
        return this.hoverflyConfig;
    }

    public HoverflyMode getMode() {
        return HoverflyMode.valueOf(this.hoverflyClient.getConfigInfo().getMode().toUpperCase());
    }

    public boolean isHealthy() {
        return this.hoverflyClient.getHealth();
    }

    public SslConfigurer getSslConfigurer() {
        return this.sslConfigurer;
    }

    public void verify(RequestMatcherBuilder requestMatcher, VerificationCriteria criteria) {
        this.verifyRequest(requestMatcher.build(), criteria);
    }

    public void assertThatNoDiffIsReported(boolean shouldResetDiff) {
        DiffView diffs = this.hoverflyClient.getDiffs();
        if (diffs.getDiffs() != null && !diffs.getDiffs().isEmpty()) {
            StringBuilder message = new StringBuilder("There has been reported a diff in any of the actual and expected responses:\n");
            diffs.getDiffs().forEach(diff -> message.append(diff.createDiffMessage()));
            if (shouldResetDiff) {
                this.hoverflyClient.cleanDiffs();
            }
            throw new HoverflyDiffAssertionError(message.toString(), diffs);
        }
    }

    public void verify(RequestMatcherBuilder requestMatcher) {
        this.verify(requestMatcher, HoverflyVerifications.times(1));
    }

    public void verifyZeroRequestTo(StubServiceBuilder requestedServiceBuilder) {
        this.verify(requestedServiceBuilder.anyMethod(HoverflyMatchers.any()), HoverflyVerifications.never());
    }

    public void verifyAll() {
        Simulation simulation = this.hoverflyClient.getSimulation();
        simulation.getHoverflyData().getPairs().stream().map(RequestResponsePair::getRequest).forEach(request -> this.verifyRequest((Request)request, HoverflyVerifications.atLeastOnce()));
    }

    private void verifyRequest(Request request, VerificationCriteria criteria) {
        Journal journal = this.hoverflyClient.searchJournal(request);
        criteria.verify(request, new VerificationData(journal));
    }

    private void persistSimulation(Path path, Simulation simulation) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        ObjectMapperFactory.getPrettyPrinter().writeValue(path.toFile(), (Object)simulation);
    }

    private void waitForHoverflyToBecomeHealthy() {
        Instant now = Instant.now();
        while (Duration.between(now, Instant.now()).getSeconds() < 10L) {
            if (this.hoverflyClient.getHealth()) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("Hoverfly has not become healthy in 10 seconds");
    }

    private void setModeWithArguments(HoverflyMode mode, HoverflyConfiguration config) {
        if (mode == HoverflyMode.CAPTURE) {
            this.hoverflyClient.setMode(mode, new ModeArguments(config.getCaptureHeaders(), config.isStatefulCapture()));
        } else if (mode == HoverflyMode.DIFF) {
            this.hoverflyClient.setMode(mode, new ModeArguments(config.getCaptureHeaders()));
        } else {
            this.hoverflyClient.setMode(mode);
        }
    }

    private void cleanUp() {
        LOGGER.info("Destroying hoverfly process");
        if (this.startedProcess != null) {
            Process process = this.startedProcess.getProcess();
            process.destroy();
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future<Integer> future = executorService.submit(process::waitFor);
            try {
                future.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOGGER.warn("Timeout when waiting for hoverfly process to terminate.");
            }
            executorService.shutdownNow();
            this.startedProcess = null;
        }
        this.proxyConfigurer.restoreProxySystemProperties();
        this.sslConfigurer.reset();
        this.tempFileManager.purge();
        try {
            if (this.shutdownThread != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

