/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.json;

import io.smallrye.graphql.api.CustomFloatScalar;
import io.smallrye.graphql.api.CustomIntScalar;
import io.smallrye.graphql.api.CustomStringScalar;
import io.smallrye.graphql.json.GraphQLNamingStrategy;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.InputType;
import io.smallrye.graphql.spi.ClassloadingService;
import jakarta.json.JsonValue;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.config.PropertyNamingStrategy;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.bind.serializer.JsonbSerializer;
import jakarta.json.bind.serializer.SerializationContext;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class JsonBCreator {
    private static final Jsonb JSONB = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withFormatting(Boolean.valueOf(true)).withNullValues(Boolean.valueOf(true)).withSerializers(new JsonbSerializer[]{CustomScalarSerializers.CUSTOM_STRING_SERIALIZER, CustomScalarSerializers.CUSTOM_INT_SERIALIZER, CustomScalarSerializers.CUSTOM_FLOAT_SERIALIZER}).withDeserializers(new JsonbDeserializer[]{CustomScalarSerializers.CUSTOM_STRING_DESERIALIZER, CustomScalarSerializers.CUSTOM_INT_DESERIALIZER, CustomScalarSerializers.CUSTOM_FLOAT_DESERIALIZER}));
    private static final Map<String, Jsonb> jsonMap = new HashMap<String, Jsonb>();

    private JsonBCreator() {
    }

    protected static void register(InputType inputType) {
        if (inputType.hasFields()) {
            HashMap<String, String> namemapping = new HashMap<String, String>();
            Collection fields = inputType.getFields().values();
            for (Field field : fields) {
                if (field.getName().equals(field.getPropertyName())) continue;
                namemapping.put(field.getPropertyName(), field.getName());
            }
            if (!namemapping.isEmpty()) {
                Jsonb jsonB = JsonBCreator.createJsonB(namemapping);
                jsonMap.put(inputType.getClassName(), jsonB);
            }
        }
    }

    protected static void override(Map<String, Jsonb> overrides) {
        jsonMap.putAll(overrides);
    }

    public static Jsonb getJsonB(String className) {
        if (jsonMap.containsKey(className)) {
            return jsonMap.get(className);
        }
        return JsonBCreator.getJsonB();
    }

    public static Jsonb getJsonB() {
        return JSONB;
    }

    private static Jsonb createJsonB(Map<String, String> customFieldNameMapping) {
        JsonbConfig config = JsonBCreator.createDefaultConfig().withPropertyNamingStrategy((PropertyNamingStrategy)new GraphQLNamingStrategy(customFieldNameMapping));
        return JsonbBuilder.create((JsonbConfig)config);
    }

    private static JsonbConfig createDefaultConfig() {
        return new JsonbConfig().withNullValues(Boolean.TRUE).withFormatting(Boolean.TRUE);
    }

    static class CustomScalarSerializers {
        static JsonbSerializer<CustomStringScalar> CUSTOM_STRING_SERIALIZER = new JsonbSerializer<CustomStringScalar>(){

            public void serialize(CustomStringScalar customStringScalar, JsonGenerator jsonGenerator, SerializationContext serializationContext) {
                jsonGenerator.write(customStringScalar.stringValueForSerialization());
            }
        };
        static JsonbDeserializer<CustomStringScalar> CUSTOM_STRING_DESERIALIZER = new JsonbDeserializer<CustomStringScalar>(){

            public CustomStringScalar deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Type type) {
                ClassloadingService classloadingService = ClassloadingService.get();
                try {
                    if (jsonParser.getValue().getValueType() == JsonValue.ValueType.NULL) {
                        return null;
                    }
                    return (CustomStringScalar)classloadingService.loadClass(type.getTypeName()).getConstructor(String.class).newInstance(jsonParser.getString());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        static JsonbSerializer<CustomIntScalar> CUSTOM_INT_SERIALIZER = new JsonbSerializer<CustomIntScalar>(){

            public void serialize(CustomIntScalar customIntScalar, JsonGenerator jsonGenerator, SerializationContext serializationContext) {
                jsonGenerator.write(customIntScalar.intValueForSerialization());
            }
        };
        static JsonbDeserializer<CustomIntScalar> CUSTOM_INT_DESERIALIZER = new JsonbDeserializer<CustomIntScalar>(){

            public CustomIntScalar deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Type type) {
                ClassloadingService classloadingService = ClassloadingService.get();
                try {
                    if (jsonParser.getValue().getValueType() == JsonValue.ValueType.NULL) {
                        return null;
                    }
                    return (CustomIntScalar)classloadingService.loadClass(type.getTypeName()).getConstructor(Integer.class).newInstance(jsonParser.getInt());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        static JsonbSerializer<CustomFloatScalar> CUSTOM_FLOAT_SERIALIZER = new JsonbSerializer<CustomFloatScalar>(){

            public void serialize(CustomFloatScalar customFloatScalar, JsonGenerator jsonGenerator, SerializationContext serializationContext) {
                jsonGenerator.write(customFloatScalar.floatValueForSerialization());
            }
        };
        static JsonbDeserializer<CustomFloatScalar> CUSTOM_FLOAT_DESERIALIZER = new JsonbDeserializer<CustomFloatScalar>(){

            public CustomFloatScalar deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Type type) {
                ClassloadingService classloadingService = ClassloadingService.get();
                try {
                    if (jsonParser.getValue().getValueType() == JsonValue.ValueType.NULL) {
                        return null;
                    }
                    return (CustomFloatScalar)classloadingService.loadClass(type.getTypeName()).getConstructor(BigDecimal.class).newInstance(jsonParser.getBigDecimal());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };

        CustomScalarSerializers() {
        }
    }
}

