/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.ScanningContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SourceOperationHelper {
    private final Logger LOG = Logger.getLogger((String)SourceOperationHelper.class.getName());
    private Map<DotName, List<MethodParameterInfo>> sourceAnnotations = this.scanAllSourceAnnotations(false, false, Type.Kind.CLASS, Type.Kind.PRIMITIVE);
    private Map<DotName, List<MethodParameterInfo>> sourceListAnnotations = this.scanAllSourceAnnotations(true, false, Type.Kind.ARRAY);

    public Map<DotName, List<MethodParameterInfo>> getSourceAnnotations() {
        return this.sourceAnnotations;
    }

    public Map<DotName, List<MethodParameterInfo>> getSourceListAnnotations() {
        return this.sourceListAnnotations;
    }

    private Map<DotName, List<MethodParameterInfo>> scanAllSourceAnnotations(boolean includeCollections, boolean includeMap, Type.Kind ... forReturnType) {
        HashMap<DotName, List<MethodParameterInfo>> sourceFields = new HashMap<DotName, List<MethodParameterInfo>>();
        Collection sourceAnnotations = ScanningContext.getIndex().getAnnotations(Annotations.SOURCE);
        for (AnnotationInstance ai : sourceAnnotations) {
            AnnotationTarget target = ai.target();
            if (target.kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER)) {
                DotName name;
                MethodParameterInfo methodParameter = target.asMethodParameter();
                short position = methodParameter.position();
                Type returnType = methodParameter.method().parameterType((int)position);
                if (forReturnType == null || Arrays.asList(forReturnType).contains(returnType.kind())) {
                    name = this.getName(returnType);
                    sourceFields.computeIfAbsent(name, k -> new ArrayList()).add(methodParameter);
                    continue;
                }
                if (!returnType.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) continue;
                if (includeCollections && Classes.isCollection(returnType)) {
                    name = this.getName(returnType);
                    sourceFields.computeIfAbsent(name, k -> new ArrayList()).add(methodParameter);
                    continue;
                }
                if (!includeMap || !Classes.isMap(returnType)) continue;
                name = this.getName(returnType);
                sourceFields.computeIfAbsent(name, k -> new ArrayList()).add(methodParameter);
                continue;
            }
            this.LOG.warn((Object)("Ignoring " + ai.target() + " on kind " + ai.target().kind() + ". Only expecting @" + Annotations.SOURCE.local() + " on Method parameters"));
        }
        return sourceFields;
    }

    private DotName getName(Type returnType) {
        if (returnType.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) {
            Type typeInCollection = (Type)returnType.asParameterizedType().arguments().get(0);
            return this.getName(typeInCollection);
        }
        if (returnType.kind().equals((Object)Type.Kind.ARRAY)) {
            Type typeInArray = returnType.asArrayType().component();
            return this.getName(typeInArray);
        }
        return returnType.name();
    }
}

