/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator.type;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.creator.ModelCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Directives;
import io.smallrye.graphql.schema.model.CustomScalarType;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class CustomScalarCreator
extends ModelCreator {
    private static final Logger LOG = Logger.getLogger((String)CustomScalarCreator.class.getName());
    private Directives directives;

    public CustomScalarCreator(ReferenceCreator referenceCreator) {
        super(referenceCreator);
    }

    public CustomScalarType create(ClassInfo classInfo, String scalarName) {
        CustomScalarType.CustomScalarPrimitiveType customScalarPrimitiveType;
        LOG.debug((Object)("Creating custom scalar from " + classInfo.name().toString()));
        Annotations annotations = Annotations.getAnnotationsForClass(classInfo);
        Set interfaces = classInfo.interfaceNames().stream().map(DotName::toString).collect(Collectors.toSet());
        if (interfaces.contains("io.smallrye.graphql.api.CustomIntScalar")) {
            CustomScalarCreator.checkForOneArgConstructor(classInfo, BigInteger.class);
            customScalarPrimitiveType = CustomScalarType.CustomScalarPrimitiveType.INT_TYPE;
        } else if (interfaces.contains("io.smallrye.graphql.api.CustomFloatScalar")) {
            CustomScalarCreator.checkForOneArgConstructor(classInfo, BigDecimal.class);
            customScalarPrimitiveType = CustomScalarType.CustomScalarPrimitiveType.FLOAT_TYPE;
        } else if (interfaces.contains("io.smallrye.graphql.api.CustomStringScalar")) {
            CustomScalarCreator.checkForOneArgConstructor(classInfo, String.class);
            customScalarPrimitiveType = CustomScalarType.CustomScalarPrimitiveType.STRING_TYPE;
        } else {
            throw new RuntimeException(classInfo.name().toString() + " is required to implement a known CustomScalar primitive type. (CustomStringScalar, CustomFloatScalar, CustomIntScalar)");
        }
        return new CustomScalarType(classInfo.name().toString(), scalarName, (String)DescriptionHelper.getDescriptionForType(annotations).orElse(null), customScalarPrimitiveType);
    }

    private static void checkForOneArgConstructor(ClassInfo classInfo, Class<?> argType) {
        if (classInfo.constructors().stream().noneMatch(methodInfo -> methodInfo.parameters().size() == 1 && methodInfo.parameterType(0).equals((Object)ClassType.create((Class)argType)))) {
            throw new RuntimeException(classInfo.name().toString() + " is required to implement a one arg constructor with a type of " + argType.getName());
        }
    }

    @Override
    public String getDirectiveLocation() {
        return "SCALAR";
    }

    private List<DirectiveInstance> getDirectiveInstances(Annotations annotations, String referenceName) {
        return this.directives.buildDirectiveInstances(annotations, this.getDirectiveLocation(), referenceName);
    }

    @Override
    public void setDirectives(Directives directives) {
        this.directives = directives;
    }
}

