/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.vertx;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.file.FileSystemOptions;
import org.jboss.logging.Logger;

public class VertxManager {
    private static volatile Vertx globalInstance;
    private static volatile Vertx customInstance;
    private static final Logger log;

    public static Vertx get() {
        if (globalInstance != null) {
            log.debug((Object)"Using the global Vert.x instance");
            return globalInstance;
        }
        Vertx fromContext = VertxManager.getFromContext();
        if (fromContext != null) {
            log.debug((Object)("Using Vert.x instance " + fromContext.toString() + " found in the context"));
            return fromContext;
        }
        return VertxManager.getOrCreateCustom();
    }

    public static void setFromGlobal(Vertx vertx) {
        globalInstance = vertx;
    }

    public static Future<Void> closeCustomInstance() {
        if (customInstance != null) {
            return customInstance.close();
        }
        return Future.succeededFuture();
    }

    private static Vertx getFromContext() {
        Context vertxContext = Vertx.currentContext();
        if (vertxContext != null && vertxContext.owner() != null) {
            return vertxContext.owner();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Vertx getOrCreateCustom() {
        if (customInstance == null) {
            Class<VertxManager> clazz = VertxManager.class;
            // MONITORENTER : io.smallrye.graphql.client.vertx.VertxManager.class
            if (customInstance == null) {
                if (!System.getProperties().contains("vertx.disableDnsResolver")) {
                    System.setProperty("vertx.disableDnsResolver", "true");
                }
                FileSystemOptions fso = new FileSystemOptions();
                fso.setFileCachingEnabled(false);
                VertxOptions options = new VertxOptions();
                options.setFileSystemOptions(fso);
                customInstance = Vertx.vertx((VertxOptions)options);
            }
            // MONITOREXIT : clazz
        }
        log.debug((Object)("Using custom Vert.x instance " + customInstance.toString()));
        return customInstance;
    }

    static {
        log = Logger.getLogger(VertxManager.class);
    }
}

