/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.producer;

import graphql.execution.ExecutionStrategy;
import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.bootstrap.Bootstrap;
import io.smallrye.graphql.cdi.context.CDISmallRyeContext;
import io.smallrye.graphql.execution.ExecutionService;
import io.smallrye.graphql.schema.model.Schema;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import java.util.Optional;
import java.util.concurrent.SubmissionPublisher;

@ApplicationScoped
public class GraphQLProducer {
    @Produces
    ExecutionService executionService;
    @Produces
    GraphQLSchema graphQLSchema;
    @Produces
    Schema schema;
    private Optional<SubmissionPublisher<String>> traficPublisher = Optional.empty();

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setTraficPublisher(SubmissionPublisher<String> traficPublisher) {
        this.traficPublisher = Optional.of(traficPublisher);
    }

    public GraphQLSchema initialize(Schema schema) {
        return this.initialize(schema, null, null);
    }

    public GraphQLSchema initialize(Schema schema, ExecutionStrategy queryExecutionStrategy, ExecutionStrategy mutationExecutionStrategy) {
        return this.initialize(schema, false, queryExecutionStrategy, mutationExecutionStrategy);
    }

    public GraphQLSchema initialize(Schema schema, boolean allowMultipleDeployments) {
        return this.initialize(schema, allowMultipleDeployments, null, null);
    }

    public GraphQLSchema initialize(Schema schema, boolean allowMultipleDeployments, ExecutionStrategy queryExecutionStrategy, ExecutionStrategy mutationExecutionStrategy) {
        this.schema = schema;
        return this.initialize(allowMultipleDeployments, queryExecutionStrategy, mutationExecutionStrategy);
    }

    public GraphQLSchema initialize(boolean allowMultipleDeployments) {
        return this.initialize(allowMultipleDeployments, null, null);
    }

    public GraphQLSchema initialize(boolean allowMultipleDeployments, ExecutionStrategy queryExecutionStrategy, ExecutionStrategy mutationExecutionStrategy) {
        this.graphQLSchema = Bootstrap.bootstrap((Schema)this.schema, (boolean)allowMultipleDeployments);
        this.executionService = new ExecutionService(this.graphQLSchema, this.schema, this.traficPublisher, queryExecutionStrategy, mutationExecutionStrategy);
        return this.graphQLSchema;
    }

    public GraphQLSchema initialize(ExecutionStrategy queryExecutionStrategy, ExecutionStrategy mutationExecutionStrategy) {
        return this.initialize(false, queryExecutionStrategy, mutationExecutionStrategy);
    }

    public GraphQLSchema initialize() {
        return this.initialize(false);
    }

    @Produces
    @Dependent
    public CDISmallRyeContext produceSmallRyeContext() {
        return new CDISmallRyeContext(GraphQLProducer.class.getName());
    }
}

