/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.spi.EventingService;
import java.time.Duration;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;

public class MicrometerMetricsService
implements EventingService {
    private final MeterRegistry meterRegistry = Metrics.globalRegistry;
    private final Map<Context, Long> startTimes = Collections.synchronizedMap(new IdentityHashMap());
    private static final String METRIC_NAME = "mp_graphql";
    private final String DESCRIPTION = "Call statistics for the operation denoted by the 'name' tag";

    public Operation createOperation(Operation operation) {
        Tags tags = this.getTags(operation);
        Timer.builder((String)METRIC_NAME).tags((Iterable)tags).description("Call statistics for the operation denoted by the 'name' tag").register(this.meterRegistry);
        return operation;
    }

    public void beforeDataFetch(Context context) {
        this.startTimes.put(context, System.nanoTime());
    }

    public void afterDataFetch(Context context) {
        Long startTime = this.startTimes.remove(context);
        if (startTime != null) {
            long duration = System.nanoTime() - startTime;
            this.meterRegistry.timer(METRIC_NAME, (Iterable)this.getTags(context)).record(Duration.ofNanos(duration));
        }
    }

    public String getConfigKey() {
        return "smallrye.graphql.metrics.enabled";
    }

    private Tags getTags(Context context) {
        return Tags.of((String)"name", (String)context.getFieldName()).and("type", context.getOperationType()).and("source", String.valueOf(context.getSource() != null));
    }

    private Tags getTags(Operation operation) {
        return Tags.of((String)"name", (String)operation.getName()).and("type", operation.getOperationType().toString()).and("source", String.valueOf(operation.isSourceField()));
    }
}

