/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.config;

import io.smallrye.graphql.spi.config.LogPayloadOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class MicroProfileConfig
implements io.smallrye.graphql.spi.config.Config {
    private Optional<List<String>> hideList;
    private Optional<List<String>> showList;
    private String defaultErrorMessage;
    private Boolean printDataFetcherException;
    private Boolean allowGet;
    private Boolean allowPostWithQueryParameters;
    private Boolean metricsEnabled;
    private Boolean tracingEnabled;
    private Boolean validationEnabled;
    private Boolean eventsEnabled;
    private Boolean includeScalarsInSchema;
    private Boolean includeDirectivesInSchema;
    private Boolean includeSchemaDefinitionInSchema;
    private Boolean includeIntrospectionTypesInSchema;
    private LogPayloadOption logPayload;
    private String fieldVisibility;
    private Optional<List<String>> unwrapExceptions;
    private Optional<List<String>> errorExtensionFields;

    public String getName() {
        return "MicroProfile Config Service";
    }

    public String getDefaultErrorMessage() {
        if (this.defaultErrorMessage == null) {
            this.defaultErrorMessage = this.getStringConfigValue("mp.graphql.defaultErrorMessage", "System error");
        }
        return this.defaultErrorMessage;
    }

    public boolean isPrintDataFetcherException() {
        if (this.printDataFetcherException == null) {
            this.printDataFetcherException = this.getBooleanConfigValue("smallrye.graphql.printDataFetcherException");
        }
        return this.printDataFetcherException;
    }

    public Optional<List<String>> getHideErrorMessageList() {
        if (this.hideList == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            Optional blackList = microProfileConfig.getOptionalValues("mp.graphql.exceptionsBlackList", String.class);
            this.hideList = this.mergeList(microProfileConfig.getOptionalValues("mp.graphql.hideErrorMessage", String.class), blackList);
        }
        return this.hideList;
    }

    public Optional<List<String>> getShowErrorMessageList() {
        if (this.showList == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            Optional whiteList = microProfileConfig.getOptionalValues("mp.graphql.exceptionsWhiteList", String.class);
            this.showList = this.mergeList(microProfileConfig.getOptionalValues("mp.graphql.showErrorMessage", String.class), whiteList);
        }
        return this.showList;
    }

    public boolean isAllowGet() {
        if (this.allowGet == null) {
            this.allowGet = this.getBooleanConfigValue("smallrye.graphql.allowGet");
        }
        return this.allowGet;
    }

    public boolean isAllowPostWithQueryParameters() {
        if (this.allowPostWithQueryParameters == null) {
            this.allowPostWithQueryParameters = this.getBooleanConfigValue("smallrye.graphql.allowPostWithQueryParameters");
        }
        return this.allowPostWithQueryParameters;
    }

    public boolean isMetricsEnabled() {
        if (this.metricsEnabled == null) {
            this.metricsEnabled = this.getBooleanConfigValue("smallrye.graphql.metrics.enabled");
        }
        return this.metricsEnabled;
    }

    public boolean isTracingEnabled() {
        if (this.tracingEnabled == null) {
            this.tracingEnabled = this.getBooleanConfigValue("smallrye.graphql.tracing.enabled");
        }
        return this.tracingEnabled;
    }

    public boolean isValidationEnabled() {
        if (this.validationEnabled == null) {
            this.validationEnabled = this.getBooleanConfigValue("smallrye.graphql.validation.enabled");
        }
        return this.validationEnabled;
    }

    public boolean isEventsEnabled() {
        if (this.eventsEnabled == null) {
            this.eventsEnabled = this.getBooleanConfigValue("smallrye.graphql.events.enabled");
        }
        return this.eventsEnabled;
    }

    public boolean isIncludeScalarsInSchema() {
        if (this.includeScalarsInSchema == null) {
            this.includeScalarsInSchema = this.getBooleanConfigValue("smallrye.graphql.schema.includeScalars", true);
        }
        return this.includeScalarsInSchema;
    }

    public boolean isIncludeDirectivesInSchema() {
        if (this.includeDirectivesInSchema == null) {
            this.includeDirectivesInSchema = this.getBooleanConfigValue("smallrye.graphql.schema.includeDirectives");
        }
        return this.includeDirectivesInSchema;
    }

    public boolean isIncludeSchemaDefinitionInSchema() {
        if (this.includeSchemaDefinitionInSchema == null) {
            this.includeSchemaDefinitionInSchema = this.getBooleanConfigValue("smallrye.graphql.schema.includeSchemaDefinition");
        }
        return this.includeSchemaDefinitionInSchema;
    }

    public boolean isIncludeIntrospectionTypesInSchema() {
        if (this.includeIntrospectionTypesInSchema == null) {
            this.includeIntrospectionTypesInSchema = this.getBooleanConfigValue("smallrye.graphql.schema.includeIntrospectionTypes");
        }
        return this.includeIntrospectionTypesInSchema;
    }

    public LogPayloadOption logPayload() {
        if (this.logPayload == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            this.logPayload = microProfileConfig.getOptionalValue("smallrye.graphql.logPayload", LogPayloadOption.class).orElse(LogPayloadOption.off);
        }
        return this.logPayload;
    }

    public String getFieldVisibility() {
        if (this.fieldVisibility == null) {
            this.fieldVisibility = this.getStringConfigValue("smallrye.graphql.fieldVisibility", "default");
        }
        return this.fieldVisibility;
    }

    public Optional<List<String>> getUnwrapExceptions() {
        if (this.unwrapExceptions == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            this.unwrapExceptions = microProfileConfig.getOptionalValues("smallrye.graphql.unwrapExceptions", String.class);
        }
        return this.unwrapExceptions;
    }

    public Optional<List<String>> getErrorExtensionFields() {
        if (this.errorExtensionFields == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            this.errorExtensionFields = microProfileConfig.getOptionalValues("smallrye.graphql.errorExtensionFields", String.class);
        }
        return this.errorExtensionFields;
    }

    public <T> T getConfigValue(String key, Class<T> type, T defaultValue) {
        Config microProfileConfig = ConfigProvider.getConfig();
        return microProfileConfig.getOptionalValue(key, type).orElse(defaultValue);
    }

    public void setHideErrorMessageList(Optional<List<String>> hideList) {
        this.hideList = hideList;
    }

    public void setShowErrorMessageList(Optional<List<String>> showList) {
        this.showList = showList;
    }

    public void setDefaultErrorMessage(String defaultErrorMessage) {
        this.defaultErrorMessage = defaultErrorMessage;
    }

    public void setPrintDataFetcherException(boolean printDataFetcherException) {
        this.printDataFetcherException = printDataFetcherException;
    }

    public void setAllowGet(boolean allowGet) {
        this.allowGet = allowGet;
    }

    public void setAllowPostWithQueryParameters(boolean allowPostWithQueryParameters) {
        this.allowPostWithQueryParameters = allowPostWithQueryParameters;
    }

    public void setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    public void setTracingEnabled(boolean tracingEnabled) {
        this.tracingEnabled = tracingEnabled;
    }

    public void setIncludeScalarsInSchema(boolean includeScalarsInSchema) {
        this.includeScalarsInSchema = includeScalarsInSchema;
    }

    public void setIncludeDirectivesInSchema(boolean includeDirectivesInSchema) {
        this.includeDirectivesInSchema = includeDirectivesInSchema;
    }

    public void setIncludeSchemaDefinitionInSchema(boolean includeSchemaDefinitionInSchema) {
        this.includeSchemaDefinitionInSchema = includeSchemaDefinitionInSchema;
    }

    public void setIncludeIntrospectionTypesInSchema(boolean includeIntrospectionTypesInSchema) {
        this.includeIntrospectionTypesInSchema = includeIntrospectionTypesInSchema;
    }

    public void setLogPayload(LogPayloadOption logPayload) {
        this.logPayload = logPayload;
    }

    public void setFieldVisibility(String fieldVisibility) {
        this.fieldVisibility = fieldVisibility;
    }

    public void setUnwrapExceptions(Optional<List<String>> unwrapExceptions) {
        this.unwrapExceptions = unwrapExceptions;
    }

    public void setErrorExtensionFields(Optional<List<String>> errorExtensionFields) {
        this.errorExtensionFields = errorExtensionFields;
    }

    public void setHideList(Optional<List<String>> hideList) {
        this.hideList = hideList;
    }

    public void setShowList(Optional<List<String>> showList) {
        this.showList = showList;
    }

    public void setPrintDataFetcherException(Boolean printDataFetcherException) {
        this.printDataFetcherException = printDataFetcherException;
    }

    public void setAllowGet(Boolean allowGet) {
        this.allowGet = allowGet;
    }

    public void setAllowPostWithQueryParameters(Boolean allowPostWithQueryParameters) {
        this.allowPostWithQueryParameters = allowPostWithQueryParameters;
    }

    public void setMetricsEnabled(Boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    public void setTracingEnabled(Boolean tracingEnabled) {
        this.tracingEnabled = tracingEnabled;
    }

    public void setValidationEnabled(Boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    public void setEventsEnabled(Boolean eventsEnabled) {
        this.eventsEnabled = eventsEnabled;
    }

    public void setIncludeScalarsInSchema(Boolean includeScalarsInSchema) {
        this.includeScalarsInSchema = includeScalarsInSchema;
    }

    public void setIncludeDirectivesInSchema(Boolean includeDirectivesInSchema) {
        this.includeDirectivesInSchema = includeDirectivesInSchema;
    }

    public void setIncludeSchemaDefinitionInSchema(Boolean includeSchemaDefinitionInSchema) {
        this.includeSchemaDefinitionInSchema = includeSchemaDefinitionInSchema;
    }

    public void setIncludeIntrospectionTypesInSchema(Boolean includeIntrospectionTypesInSchema) {
        this.includeIntrospectionTypesInSchema = includeIntrospectionTypesInSchema;
    }

    private Optional<List<String>> mergeList(Optional<List<String>> currentList, Optional<List<String>> deprecatedList) {
        ArrayList combined = new ArrayList();
        if (deprecatedList.isPresent()) {
            combined.addAll(deprecatedList.get());
        }
        if (currentList.isPresent()) {
            combined.addAll(currentList.get());
        }
        if (!combined.isEmpty()) {
            return Optional.of(combined);
        }
        return Optional.empty();
    }

    private String getStringConfigValue(String key) {
        return this.getStringConfigValue(key, null);
    }

    private String getStringConfigValue(String key, String defaultValue) {
        return this.getConfigValue(key, String.class, defaultValue);
    }

    private boolean getBooleanConfigValue(String key) {
        return this.getBooleanConfigValue(key, false);
    }

    private boolean getBooleanConfigValue(String key, boolean defaultValue) {
        return this.getConfigValue(key, Boolean.class, defaultValue);
    }
}

