/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.tracing;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextController;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class TracingContextProvider
implements ThreadContextProvider {
    private static final ThreadContextController DO_NOTHING = () -> {};

    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        Tracer tracer = GlobalTracer.get();
        ScopeManager scopeManager = tracer.scopeManager();
        Span span = scopeManager.activeSpan();
        if (span != null) {
            return () -> {
                Scope propagated = scopeManager.activate(span);
                return () -> ((Scope)propagated).close();
            };
        }
        return () -> DO_NOTHING;
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        return () -> DO_NOTHING;
    }

    public String getThreadContextType() {
        return "OpenTracing";
    }
}

