/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.async;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.async.AsyncLogger;
import io.smallrye.faulttolerance.core.event.loop.EventLoop;
import io.smallrye.faulttolerance.core.util.Preconditions;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

public class RememberEventLoop<V>
implements FaultToleranceStrategy<CompletionStage<V>> {
    private final FaultToleranceStrategy<CompletionStage<V>> delegate;
    private final EventLoop eventLoop;

    public RememberEventLoop(FaultToleranceStrategy<CompletionStage<V>> delegate, EventLoop eventLoop) {
        this.delegate = delegate;
        this.eventLoop = Preconditions.checkNotNull(eventLoop, "Event loop must be set");
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) throws Exception {
        AsyncLogger.LOG.trace("RememberEventLoopExecutor started");
        try {
            CompletionStage<V> completionStage = this.doApply(ctx);
            return completionStage;
        }
        finally {
            AsyncLogger.LOG.trace("RememberEventLoopExecutor finished");
        }
    }

    private CompletionStage<V> doApply(InvocationContext<CompletionStage<V>> ctx) throws Exception {
        if (this.eventLoop.isEventLoopThread()) {
            ctx.set(Executor.class, this.eventLoop.executor());
        }
        return this.delegate.apply(ctx);
    }
}

