/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.async;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.async.AsyncLogger;
import io.smallrye.faulttolerance.core.async.CancellationEvent;
import io.smallrye.faulttolerance.core.util.Preconditions;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureExecution<V>
implements FaultToleranceStrategy<Future<V>> {
    private final FaultToleranceStrategy<Future<V>> delegate;
    private final Executor executor;

    public FutureExecution(FaultToleranceStrategy<Future<V>> delegate, Executor executor) {
        this.delegate = delegate;
        this.executor = Preconditions.checkNotNull(executor, "Executor must be set");
    }

    @Override
    public Future<V> apply(InvocationContext<Future<V>> ctx) {
        AsyncLogger.LOG.trace("FutureExecution started");
        try {
            Future<V> future = this.doApply(ctx);
            return future;
        }
        finally {
            AsyncLogger.LOG.trace("FutureExecution finished");
        }
    }

    private Future<V> doApply(final InvocationContext<Future<V>> ctx) {
        final FutureTask<Future> task = new FutureTask<Future>(() -> this.delegate.apply(ctx));
        this.executor.execute(task);
        return new Future<V>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                ctx.fireEvent(mayInterruptIfRunning ? CancellationEvent.INTERRUPTIBLE : CancellationEvent.NONINTERRUPTIBLE);
                return task.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return task.isCancelled();
            }

            @Override
            public boolean isDone() {
                return task.isDone();
            }

            @Override
            public V get() throws InterruptedException, ExecutionException {
                return ((Future)task.get()).get();
            }

            @Override
            public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return ((Future)task.get(timeout, unit)).get(timeout, unit);
            }
        };
    }
}

