/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timeout;

import java.util.concurrent.atomic.AtomicInteger;

final class TimeoutExecution {
    private static final int STATE_RUNNING = 0;
    private static final int STATE_FINISHED = 1;
    private static final int STATE_TIMED_OUT = 2;
    private final AtomicInteger state = new AtomicInteger(0);
    private final Thread executingThread;
    private final Runnable timeoutAction;
    private final long timeoutInMillis;

    TimeoutExecution(Thread executingThread, long timeoutInMillis) {
        this(executingThread, timeoutInMillis, null);
    }

    TimeoutExecution(Thread executingThread, long timeoutInMillis, Runnable timeoutAction) {
        this.executingThread = executingThread;
        this.timeoutInMillis = timeoutInMillis;
        this.timeoutAction = timeoutAction;
    }

    long timeoutInMillis() {
        return this.timeoutInMillis;
    }

    boolean isRunning() {
        return this.state.get() == 0;
    }

    boolean hasFinished() {
        return this.state.get() == 1;
    }

    boolean hasTimedOut() {
        return this.state.get() == 2;
    }

    void finish(Runnable ifFinished) {
        if (this.state.compareAndSet(0, 1)) {
            ifFinished.run();
        }
    }

    void timeoutAndInterrupt() {
        if (this.state.compareAndSet(0, 2)) {
            if (this.executingThread != null) {
                this.executingThread.interrupt();
            }
            if (this.timeoutAction != null) {
                this.timeoutAction.run();
            }
        }
    }
}

