/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl;

import io.smallrye.context.SmallRyeContextManager;
import io.smallrye.context.impl.DefaultValues;
import io.smallrye.context.impl.ManagedExecutorImpl;
import io.smallrye.context.impl.ThreadContextImpl;
import org.eclipse.microprofile.context.ManagedExecutor;

public class ManagedExecutorBuilderImpl
implements ManagedExecutor.Builder {
    private SmallRyeContextManager manager;
    private int maxAsync;
    private int maxQueued;
    private String[] propagated;
    private String[] cleared;
    private String injectionPointName = null;

    public ManagedExecutorBuilderImpl(SmallRyeContextManager manager) {
        this.manager = manager;
        DefaultValues defaultValues = manager.getDefaultValues();
        this.propagated = defaultValues.getExecutorPropagated();
        this.cleared = defaultValues.getExecutorCleared();
        this.maxAsync = defaultValues.getExecutorAsync();
        this.maxQueued = defaultValues.getExecutorQueue();
    }

    public ManagedExecutor build() {
        return ManagedExecutorImpl.newThreadPoolExecutor(this.maxAsync, this.maxQueued, new ThreadContextImpl(this.manager, this.propagated, SmallRyeContextManager.NO_STRING, this.cleared), this.injectionPointName);
    }

    public ManagedExecutor.Builder propagated(String ... types) {
        this.propagated = types;
        return this;
    }

    public ManagedExecutor.Builder maxAsync(int max) {
        if (max == 0 || max < -1) {
            throw new IllegalArgumentException("ManagedExecutor parameter maxAsync cannot be 0 or lower then -1.");
        }
        this.maxAsync = max;
        return this;
    }

    public ManagedExecutor.Builder maxQueued(int max) {
        if (max == 0 || max < -1) {
            throw new IllegalArgumentException("ManagedExecutor parameter maxQueued cannot be 0 or lower than -1.");
        }
        this.maxQueued = max;
        return this;
    }

    public ManagedExecutor.Builder cleared(String ... types) {
        this.cleared = types;
        return this;
    }

    public ManagedExecutor.Builder injectionPointName(String name) {
        this.injectionPointName = name;
        return this;
    }
}

