/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.propagators.rxjava2;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.functions.Function;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ThreadContext;

public class ContextPropagatorOnSingleAssemblyAction
implements Function<Single, Single> {
    private ThreadContext threadContext;

    public ContextPropagatorOnSingleAssemblyAction(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    public Single apply(Single t) throws Exception {
        return new ContextPropagatorSingle(t, this.threadContext.currentContextExecutor());
    }

    public static class ContextPropagatorSingle<T>
    extends Single<T> {
        private final Single<T> source;
        private final Executor contextExecutor;

        public ContextPropagatorSingle(Single<T> t, Executor contextExecutor) {
            this.source = t;
            this.contextExecutor = contextExecutor;
        }

        protected void subscribeActual(SingleObserver<? super T> observer) {
            this.contextExecutor.execute(() -> this.source.subscribe(observer));
        }
    }
}

