/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.methods;

import io.smallrye.mutiny.vertx.UniHelper;
import io.smallrye.mutiny.vertx.codegen.lang.CodeGenHelper;
import io.smallrye.mutiny.vertx.codegen.methods.MutinyMethodDescriptor;
import io.smallrye.mutiny.vertx.codegen.methods.MutinyMethodGenerator;
import io.smallrye.mutiny.vertx.codegen.methods.UniMethodGenerator;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AwaitMethodGenerator
extends MutinyMethodGenerator {
    public static final String SUFFIX_AND_AWAIT = "AndAwait";

    public AwaitMethodGenerator(PrintWriter writer) {
        super(writer);
    }

    public void generate(MethodInfo method) {
        MutinyMethodDescriptor awaitMethod = this.computeMethodInfo(method);
        this.generateJavadoc(awaitMethod);
        this.generateMethodDeclaration(awaitMethod);
        this.generateBody(awaitMethod);
        this.writer.println();
    }

    public void generateDeclaration(MethodInfo method) {
        MutinyMethodDescriptor awaitMethod = this.computeMethodInfo(method);
        this.generateJavadoc(awaitMethod);
        this.generateMethodDeclaration(awaitMethod);
        this.writer.println(";");
        this.writer.println();
    }

    public void generateOther(MethodInfo method) {
        MutinyMethodDescriptor awaitMethod = this.computeMethodInfoOther(method);
        this.generateJavadoc(awaitMethod);
        this.generateMethodDeclaration(awaitMethod);
        this.generateBodyOther(awaitMethod);
        this.writer.println();
    }

    private void generateBody(MutinyMethodDescriptor descriptor) {
        MethodInfo method = descriptor.getMethod();
        MethodInfo original = descriptor.getOriginalMethod();
        this.writer.println(" { ");
        if (!descriptor.getMethod().getReturnType().isVoid()) {
            this.writer.print("    return (" + CodeGenHelper.genTranslatedTypeName(method.getReturnType()) + ") ");
        }
        this.writer.print(original.getName());
        this.writer.print("(");
        List params = method.getParams();
        this.writer.print(params.stream().map(ParamInfo::getName).collect(Collectors.joining(", ")));
        this.writer.println(").await().indefinitely();");
        this.writer.println("  }");
    }

    private void generateBodyOther(MutinyMethodDescriptor method) {
        this.writer.println(" { ");
        if (!method.getMethod().getReturnType().isVoid()) {
            this.writer.print("    return " + UniHelper.class.getName() + ".toUni(delegate.");
        }
        this.writer.print(method.getOriginalMethodName());
        this.writer.print("(");
        List params = method.getMethod().getParams();
        this.writer.print(params.stream().map(pi -> {
            if (pi.getType().getKind() == ClassKind.API) {
                return pi.getName() + ".getDelegate()";
            }
            return pi.getName();
        }).collect(Collectors.joining(", ")));
        if (method.getMethod().getReturnType().getKind() == ClassKind.API) {
            this.writer.println(").map(x -> newInstance(x))).await().indefinitely();");
        } else {
            this.writer.println(")).await().indefinitely();");
        }
        this.writer.println("  }");
        this.writer.println("");
    }

    private MutinyMethodDescriptor computeMethodInfoOther(MethodInfo method) {
        TypeInfo itemType = ((ParameterizedTypeInfo)method.getReturnType()).getArg(0);
        MethodInfo newMethod = method.copy().setReturnType(itemType).setName(method.getName() + SUFFIX_AND_AWAIT);
        return new MutinyMethodDescriptor(newMethod, method, MutinyMethodDescriptor.MutinyKind.AWAIT);
    }

    private MutinyMethodDescriptor computeMethodInfo(MethodInfo method) {
        ArrayList<ParamInfo> params = new ArrayList<ParamInfo>(method.getParams());
        ParamInfo handler = (ParamInfo)params.remove(method.getParams().size() - 1);
        TypeInfo returnType = ((ParameterizedTypeInfo)((ParameterizedTypeInfo)handler.getType()).getArg(0)).getArg(0);
        List<ParamInfo> paramInfos = UniMethodGenerator.updateParamInfoIfNeeded(params);
        return new MutinyMethodDescriptor(method.copy().setName(method.getName() + SUFFIX_AND_AWAIT).setReturnType(returnType).setParams(paramInfos), method, MutinyMethodDescriptor.MutinyKind.AWAIT);
    }
}

