package io.vertx.mutiny.sqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A transaction.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Transaction original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.Transaction.class)
public class Transaction implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<Transaction> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Transaction((io.vertx.sqlclient.Transaction) obj),
    Transaction::getDelegate
  );

  private final io.vertx.sqlclient.Transaction delegate;
  
  public Transaction(io.vertx.sqlclient.Transaction delegate) {
    this.delegate = delegate;
  }

  public Transaction(Object delegate) {
    this.delegate = (io.vertx.sqlclient.Transaction)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Transaction() {
    this.delegate = null;
  }

  @Override
  public io.vertx.sqlclient.Transaction getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Transaction that = (Transaction) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Like {@link io.vertx.mutiny.sqlclient.Transaction#commit} with an handler to be notified when the transaction commit has completed
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> commit() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.commit(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.Transaction#commit}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void commitAndAwait() { 
    return (Void) commit().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.Transaction#commit} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.Transaction#commit}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.Transaction#commit} but you don't need to compose it with other operations.
   */
  public void commitAndForget() { 
    commit().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.sqlclient.Transaction#rollback} with an handler to be notified when the transaction rollback has completed
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> rollback() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.rollback(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.Transaction#rollback}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void rollbackAndAwait() { 
    return (Void) rollback().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.Transaction#rollback} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.Transaction#rollback}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.Transaction#rollback} but you don't need to compose it with other operations.
   */
  public void rollbackAndForget() { 
    rollback().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.sqlclient.Transaction#completion} but with a callback
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> completion() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.completion(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.Transaction#completion}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void completionAndAwait() { 
    return (Void) completion().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.Transaction#completion} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.Transaction#completion}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.Transaction#completion} but you don't need to compose it with other operations.
   */
  public void completionAndForget() { 
    completion().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  Transaction newInstance(io.vertx.sqlclient.Transaction arg) {
    return arg != null ? new Transaction(arg) : null;
  }

}
