package io.vertx.mutiny.sqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;
import java.util.function.Function;

/**
 * A query.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Query original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.Query.class)
public class Query<T> implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<Query> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Query((io.vertx.sqlclient.Query) obj),
    Query::getDelegate
  );

  private final io.vertx.sqlclient.Query<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public Query(io.vertx.sqlclient.Query delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public Query(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.sqlclient.Query)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public Query(io.vertx.sqlclient.Query delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Query() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  @Override
  public io.vertx.sqlclient.Query getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Query that = (Query) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Execute the query.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<T> execute() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.execute(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> (T)__typeArg_0.wrap(event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.Query#execute}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the T instance produced by the operation.
   */
  public T executeAndAwait() { 
    return (T) execute().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.Query#execute} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.Query#execute}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.Query#execute} but you don't need to compose it with other operations.
   */
  public void executeAndForget() { 
    execute().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param mapper 
   * @return 
   */
  public <U> io.vertx.mutiny.sqlclient.Query<io.vertx.mutiny.sqlclient.RowSet<U>> mapping(Function<io.vertx.mutiny.sqlclient.Row, U> mapper) { 
    io.vertx.mutiny.sqlclient.Query<io.vertx.mutiny.sqlclient.RowSet<U>> ret = io.vertx.mutiny.sqlclient.Query.newInstance((io.vertx.sqlclient.Query)delegate.mapping(new java.util.function.Function<io.vertx.sqlclient.Row,U>() {
      public U apply(io.vertx.sqlclient.Row arg) {
        U ret = mapper.apply(io.vertx.mutiny.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)arg));
        return ret;
      }
    }), new TypeArg<io.vertx.mutiny.sqlclient.RowSet<U>>(o0 -> io.vertx.mutiny.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o0, TypeArg.unknown()), o0 -> o0.getDelegate()));
    return ret;
  }

  public static <T>Query<T> newInstance(io.vertx.sqlclient.Query arg) {
    return arg != null ? new Query<T>(arg) : null;
  }


  public static <T>Query<T> newInstance(io.vertx.sqlclient.Query arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new Query<T>(arg, __typeArg_T) : null;
  }

}
