package io.vertx.mutiny.sqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.List;
import io.vertx.core.Handler;
import java.util.function.Supplier;
import io.vertx.core.Future;
import io.vertx.sqlclient.PoolOptions;

/**
 * Builder for {@link io.vertx.mutiny.sqlclient.SqlClient} instances.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.ClientBuilder original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.ClientBuilder.class)
public class ClientBuilder<C> implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<ClientBuilder> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ClientBuilder((io.vertx.sqlclient.ClientBuilder) obj),
    ClientBuilder::getDelegate
  );

  private final io.vertx.sqlclient.ClientBuilder<C> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<C> __typeArg_0;
  
  public ClientBuilder(io.vertx.sqlclient.ClientBuilder delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public ClientBuilder(Object delegate, TypeArg<C> typeArg_0) {
    this.delegate = (io.vertx.sqlclient.ClientBuilder)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public ClientBuilder(io.vertx.sqlclient.ClientBuilder delegate, io.smallrye.mutiny.vertx.TypeArg<C> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ClientBuilder() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  @Override
  public io.vertx.sqlclient.ClientBuilder getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClientBuilder that = (ClientBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param options the pool options
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.ClientBuilder<C> with(io.vertx.sqlclient.PoolOptions options) { 
    delegate.with(options);
    return this;
  }

  /**
   * @param database the database coordinates
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.ClientBuilder<C> connectingTo(io.vertx.sqlclient.SqlConnectOptions database) { 
    delegate.connectingTo(database);
    return this;
  }

  /**
   * @param database the database URI
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.ClientBuilder<C> connectingTo(String database) { 
    delegate.connectingTo(database);
    return this;
  }

  /**
   * @param databases the list of database coordinates
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.ClientBuilder<C> connectingTo(List<io.vertx.sqlclient.SqlConnectOptions> databases) { 
    delegate.connectingTo(databases);
    return this;
  }

  /**
   * @param vertx the vertx instance
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.ClientBuilder<C> using(io.vertx.mutiny.core.Vertx vertx) { 
    delegate.using(vertx.getDelegate());
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.sqlclient.ClientBuilder<C> __withConnectHandler(Handler<io.vertx.mutiny.sqlclient.SqlConnection> handler) { 
    delegate.withConnectHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, event -> io.vertx.mutiny.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.sqlclient.ClientBuilder<C> withConnectHandler(java.util.function.Consumer<io.vertx.mutiny.sqlclient.SqlConnection> handler) {
    return __withConnectHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertConsumer(handler));
  }

  /**
   * @return the client
   */
  public C build() { 
    C ret = (C)__typeArg_0.wrap(delegate.build());
    return ret;
  }

  /**
   * @param supplier the supplier of database coordinates
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.ClientBuilder<C> connectingTo(java.util.function.Supplier<io.smallrye.mutiny.Uni<io.vertx.sqlclient.SqlConnectOptions>> supplier) { 
    delegate.connectingTo(() -> io.smallrye.mutiny.vertx.UniHelper.toFuture(supplier.get()));
    return this;
  }

  public static <C>ClientBuilder<C> newInstance(io.vertx.sqlclient.ClientBuilder arg) {
    return arg != null ? new ClientBuilder<C>(arg) : null;
  }


  public static <C>ClientBuilder<C> newInstance(io.vertx.sqlclient.ClientBuilder arg, io.smallrye.mutiny.vertx.TypeArg<C> __typeArg_C) {
    return arg != null ? new ClientBuilder<C>(arg, __typeArg_C) : null;
  }

}
