/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.sqlclient;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.Pool;
import io.vertx.mutiny.sqlclient.SqlClient;
import io.vertx.mutiny.sqlclient.SqlConnection;
import java.util.function.Function;

public class SqlClientHelper {
    public static <T> Multi<T> inTransactionMulti(Pool pool, Function<SqlClient, Multi<T>> sourceSupplier) {
        return SqlClientHelper.usingConnectionMulti(pool, conn -> conn.begin().onItem().transformToMulti(transaction -> {
            Multi multi = ((Multi)sourceSupplier.apply((SqlClient)conn)).onCompletion().call(() -> transaction.commit()).onFailure().call(() -> transaction.rollback());
            return multi;
        }));
    }

    public static <T> Uni<T> inTransactionUni(Pool pool, Function<SqlClient, Uni<T>> sourceSupplier) {
        return SqlClientHelper.usingConnectionUni(pool, conn -> conn.begin().onItem().transformToUni(tx -> ((Uni)sourceSupplier.apply((SqlClient)conn)).onItemOrFailure().transformToUni((res, fail) -> {
            if (fail != null) {
                return tx.rollback().onItem().failWith(x -> fail);
            }
            return tx.commit().onItem().transform(x -> res);
        })));
    }

    public static <T> Multi<T> usingConnectionMulti(Pool pool, Function<SqlConnection, Multi<T>> sourceSupplier) {
        return pool.getConnection().onItem().transformToMulti(conn -> {
            try {
                return ((Multi)sourceSupplier.apply((SqlConnection)conn)).onTermination().call(conn::close);
            }
            catch (Throwable t) {
                return conn.close().onItem().transformToMulti(x -> Multi.createFrom().failure(t));
            }
        });
    }

    public static <T> Uni<T> usingConnectionUni(Pool pool, Function<SqlConnection, Uni<T>> sourceSupplier) {
        return pool.getConnection().onItem().transformToUni(conn -> {
            try {
                return ((Uni)sourceSupplier.apply((SqlConnection)conn)).onTermination().call(conn::close);
            }
            catch (Throwable t) {
                return conn.close().onItem().failWith(x -> t);
            }
        });
    }

    private SqlClientHelper() {
    }
}

