/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.sqlclient;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.mutiny.sqlclient.Cursor;
import io.vertx.mutiny.sqlclient.PreparedQuery;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowSet;
import io.vertx.mutiny.sqlclient.RowStream;
import io.vertx.mutiny.sqlclient.Tuple;

@MutinyGen(value=io.vertx.sqlclient.PreparedStatement.class)
public class PreparedStatement {
    public static final TypeArg<PreparedStatement> __TYPE_ARG = new TypeArg(obj -> new PreparedStatement((io.vertx.sqlclient.PreparedStatement)obj), PreparedStatement::getDelegate);
    private final io.vertx.sqlclient.PreparedStatement delegate;
    static final TypeArg<Row> TYPE_ARG_2 = new TypeArg(o1 -> Row.newInstance((io.vertx.sqlclient.Row)o1), o1 -> o1.getDelegate());
    static final TypeArg<RowSet<Row>> TYPE_ARG_0 = new TypeArg(o1 -> RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg(o2 -> Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
    static final TypeArg<Row> TYPE_ARG_1 = new TypeArg(o1 -> Row.newInstance((io.vertx.sqlclient.Row)o1), o1 -> o1.getDelegate());

    public PreparedStatement(io.vertx.sqlclient.PreparedStatement delegate) {
        this.delegate = delegate;
    }

    public PreparedStatement(Object delegate) {
        this.delegate = (io.vertx.sqlclient.PreparedStatement)delegate;
    }

    PreparedStatement() {
        this.delegate = null;
    }

    public io.vertx.sqlclient.PreparedStatement getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreparedStatement that = (PreparedStatement)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public PreparedQuery<RowSet<Row>> query() {
        PreparedQuery<RowSet<Row>> ret = PreparedQuery.newInstance(this.delegate.query(), TYPE_ARG_0);
        return ret;
    }

    public Cursor cursor() {
        Cursor ret = Cursor.newInstance(this.delegate.cursor());
        return ret;
    }

    public Cursor cursor(Tuple args) {
        Cursor ret = Cursor.newInstance(this.delegate.cursor(args.getDelegate()));
        return ret;
    }

    public RowStream<Row> createStream(int fetch) {
        RowStream<Row> ret = RowStream.newInstance(this.delegate.createStream(fetch), TYPE_ARG_1);
        return ret;
    }

    public RowStream<Row> createStream(int fetch, Tuple args) {
        RowStream<Row> ret = RowStream.newInstance(this.delegate.createStream(fetch, args.getDelegate()), TYPE_ARG_2);
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.close(completionHandler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public static PreparedStatement newInstance(io.vertx.sqlclient.PreparedStatement arg) {
        return arg != null ? new PreparedStatement(arg) : null;
    }
}

