/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.sqlclient;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;

@MutinyGen(value=io.vertx.sqlclient.Transaction.class)
public class Transaction {
    public static final TypeArg<Transaction> __TYPE_ARG = new TypeArg(obj -> new Transaction((io.vertx.sqlclient.Transaction)obj), Transaction::getDelegate);
    private final io.vertx.sqlclient.Transaction delegate;

    public Transaction(io.vertx.sqlclient.Transaction delegate) {
        this.delegate = delegate;
    }

    public Transaction(Object delegate) {
        this.delegate = (io.vertx.sqlclient.Transaction)delegate;
    }

    Transaction() {
        this.delegate = null;
    }

    public io.vertx.sqlclient.Transaction getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @CheckReturnValue
    public Uni<Void> commit() {
        return AsyncResultUni.toUni(handler -> this.delegate.commit(handler));
    }

    public Void commitAndAwait() {
        return (Void)this.commit().await().indefinitely();
    }

    public void commitAndForget() {
        this.commit().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> rollback() {
        return AsyncResultUni.toUni(handler -> this.delegate.rollback(handler));
    }

    public Void rollbackAndAwait() {
        return (Void)this.rollback().await().indefinitely();
    }

    public void rollbackAndForget() {
        this.rollback().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> completion() {
        return AsyncResultUni.toUni(handler -> this.delegate.completion(handler));
    }

    public Void completionAndAwait() {
        return (Void)this.completion().await().indefinitely();
    }

    public void completionAndForget() {
        this.completion().subscribe().with(UniHelper.NOOP);
    }

    public static Transaction newInstance(io.vertx.sqlclient.Transaction arg) {
        return arg != null ? new Transaction(arg) : null;
    }
}

